/************/
/**  Menu  **/
/************/

jQuery(document).ready(function($){
	$('.nav-menu').each(function() {
		var menu = $(this);
		menu.hover(function() {
			menu.addClass('hover');
		}, function() {
			menu.removeClass('hover');
		});
	});
});


/************************************************************/
/**  Fonction pour fermer ou ouvrir un calque via un lien  **/
/************************************************************/

function slideMe(monDiv, effet, lien, lienTexteOn, lienTexteOff, statutDepart, numero){

	if(numero==null){ var numero = ''; }

	// Si le calque est déjà visible, alors il doit disparaitre
	if(Element.visible(monDiv)){

		Effect.SlideUp(monDiv, { duration: 0 });

		if(lienTexteOn != ''){
			document.getElementById(lien).innerHTML = lienTexteOn;
			if(statutDepart != ''){
				var fichier_selection = 'fichier_selection' + numero;
				// var fichier_selection_debug = 'fichier_selection_debug' + numero;
				document.getElementById(fichier_selection).value = statutDepart;
				// document.getElementById(fichier_selection_debug).innerHTML = statutDepart;
			}
		}

	// Si le calque est invisible, alors on doit s'afficher
	}else{

		if(effet == 0){
			Effect.Appear(monDiv, { from: 0, to: 1, duration: 0 });
		}else{
			Effect.SlideDown(monDiv, { duration: 0.4 });
		}

		if(lienTexteOff != ''){
			document.getElementById(lien).innerHTML = lienTexteOff;
			if(statutDepart != ''){
				var fichier_selection = 'fichier_selection' + numero;
				// var fichier_selection_debug = 'fichier_selection_debug' + numero;
				document.getElementById(fichier_selection).value = 'ajouter_remplacer';
				// document.getElementById(fichier_selection_debug).innerHTML = 'ajouter_remplacer';
			}
		}

	}

}


/*****************************************************/
/**  Fonction pour supprimer un fichier téléchargé  **/
/*****************************************************/

// Supprimer le fichier
function fichier_supprimer(numero, texte){
	if(numero==null){ var numero = ''; }
	document.getElementById('fichier_selection' + numero).value = 'supprimer';
	document.getElementById('fichier_bloc_lien_annuler_suppression' + numero).style.display = 'block';
	document.getElementById('fichier_bloc_affichage' + numero).style.display = 'none';
	document.getElementById('fichier_bloc_liens' + numero).style.display = 'none';

	document.getElementById('fichier_lien_remplacer' + numero).innerHTML = texte;
	document.getElementById('fichier_bloc_selection' + numero).style.display = 'none';

	// document.getElementById('fichier_selection_debug' + numero).innerHTML = 'supprimer';
}


/********************************************************************/
/**  Fonction pour annuler la suppression d'un fichier téléchargé  **/
/********************************************************************/

function fichier_supprimer_annulation(numero){
	if(numero==null){ var numero = ''; }
	document.getElementById('fichier_selection' + numero).value = 'garder';
	document.getElementById('fichier_bloc_affichage' + numero).style.display = 'block';
	document.getElementById('fichier_bloc_liens' + numero).style.display = 'block';
	document.getElementById('fichier_bloc_lien_annuler_suppression' + numero).style.display = 'none';

	// document.getElementById('fichier_selection_debug' + numero).innerHTML = 'garder';
}


/****************************************/
/**  Fonction pour formater un nombre  **/
/****************************************/

function format_chiffre(valeur) {

	var decimal = 2;
	var separateur = '';

	// formate un chiffre avec 'decimal' chiffres après la virgule et un separateur
	var deci = Math.round( Math.pow(10,decimal)*(Math.abs(valeur)-Math.floor(Math.abs(valeur)))) ; 
	var val = Math.floor(Math.abs(valeur));
	if((decimal==0) || (deci==Math.pow(10,decimal))) {
		val = Math.floor(Math.abs(valeur));
		deci = 0;
	}
	var val_format = val + '';
	var nb = val_format.length;
	for(var i=1; i<4; i++) {
		if (val >= Math.pow(10,(3*i))) {
			val_format = val_format.substring(0,nb-(3*i))+separateur+val_format.substring(nb-(3*i));
		}
	}
	if(decimal > 0) {
		var decim = ''; 
		for(var j=0; j<(decimal-deci.toString().length); j++){ decim += '0'; }
		deci = decim + deci.toString();
		val_format = val_format + '.' + deci;
	}
	if(parseFloat(valeur) < 0){
		val_format = '-' + val_format;
	}

	return val_format;
}


/*************************************************************/
/**  Fonction AJAX pour interroger un script en asynchrone  **/
/*************************************************************/

function file(fichier){
	if(window.XMLHttpRequest)										// Firefox
		xhr_object = new XMLHttpRequest(); 
	else if(window.ActiveXObject)									// Internet Explorer
		xhr_object = new ActiveXObject('Microsoft.XMLHTTP'); 
	else 
		return(false); 
	xhr_object.open('GET', fichier, false); 
	xhr_object.send(null); 
	if(xhr_object.readyState == 4) return(xhr_object.responseText);
	else return(false);
}
