<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(1, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(2, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
if(isset($action) AND $action=='modifier'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($module_libelle))==0){
		$erreur_message .= "- le libellé est manquant<br>";
	}
	if(strlen(trim($module_repertoire))==0){
		$erreur_message .= "- le répertoire est manquant<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$module_libelle = htmlentities(ucfirst($module_libelle), ENT_QUOTES);
	$module_repertoire = htmlentities(strtolower($module_repertoire), ENT_QUOTES);
	if(!isset($module_activation)){ $module_activation = 0; }

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		// Requête de mise à jour du module
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE admin_modules SET module_niveau="'.$module_niveau.'", module_libelle="'.$module_libelle.'", module_repertoire="'.$module_repertoire.'", module_activation="'.$module_activation.'" WHERE module_id='.$module_id);

		echo '<meta http-equiv="refresh" content="0; url=./">';
		exit;

	}else{
		$module_libelle = stripslashes($module_libelle);
		$module_repertoire = stripslashes($module_repertoire);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Sélection du module
	$requete_module = mysqli_query($connexion_mysql, 'SELECT module_niveau, module_libelle, module_repertoire, module_activation FROM admin_modules WHERE module_id='.$module_id);
	$resultat_module = mysqli_fetch_array($requete_module);
	$module_niveau = $resultat_module[0];
	$module_libelle = ucfirst(decodage_apostrophe(html_entity_decode(stripslashes($resultat_module[1]))));
	$module_repertoire = $resultat_module[2];
	$module_activation = $resultat_module[3];

}


include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 450px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Arborescence</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">
				<input type="hidden" name="module_id" value="<?=$module_id?>">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Activation</div>
					<div id="formulaire_champ"><input type="checkbox" name="module_activation" value="1" <?php if($module_activation==1){ echo 'checked'; } ?>></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Niveau</div>
					<div id="formulaire_champ">
						<input type="radio" id="module_niveau_primaire" name="module_niveau" value="primaire" <?php if($module_niveau=='primaire'){ echo 'checked'; } ?>> <label for="module_niveau_primaire">Primaire</label>&nbsp;&nbsp;&nbsp;&nbsp; 
						<input type="radio" id="module_niveau_secondaire" name="module_niveau" value="secondaire" <?php if($module_niveau=='secondaire'){ echo 'checked'; } ?>> <label for="module_niveau_secondaire">Secondaire</label>
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Libellé</div>
					<div id="formulaire_champ"><input type="text" name="module_libelle" value="<?=$module_libelle?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Répertoire</div>
					<div id="formulaire_champ"><input type="text" name="module_repertoire" value="<?=$module_repertoire?>" class="input" style="width: 270px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>


<script language="Javascript">
	<!-- 
	document.modifier.module_libelle.focus();
	//-->
</script>

</body>
</html>
