<?php
require_once '../../../../lib/configuration.inc';
require_once '../../../libs/fpdf.php';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(9, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


define('ESPACE', chr(32));		// Remplace le caractère Espace (&nbsp;)


// Sélection de la compétition
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_annee, competition_date_debut, competition_date_fin, competition_golfs, competition_sponsor_1, competition_sponsor_2, competition_sponsor_3, competition_sponsor_4 FROM competitions WHERE competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC');
$nb_competitions = mysqli_num_rows($requete_competition);
if($nb_competitions!=0){
	$resultat_competition = mysqli_fetch_array($requete_competition);
	$competition_annee = $resultat_competition[0];
	$competition_date_debut = $resultat_competition[1];
	$competition_date_fin = $resultat_competition[2];
	$competition_golfs = explode(',', $resultat_competition[3]);
}


// Sélection des dates enregistrées
$requete_dates = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_depart_date) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id ORDER BY planning_depart_date');
$nb_dates = mysqli_num_rows($requete_dates);
if($nb_dates!=0){
	$tab_dates = array();
	for($date_boucle=0; $date_boucle<$nb_dates; $date_boucle++){
		$resultat_date = mysqli_fetch_array($requete_dates);
		$date_competition = $resultat_date[0];

		$tab_date_competition = explode('-', $date_competition);
		$date_competition_libelle_1 = $tab_date_competition[2].' / '.$tab_date_competition[1].' / '.$tab_date_competition[0];
		$date_competition_libelle_2 = $tab_date_competition[2].' / '.$tab_date_competition[1];

		array_push($tab_dates, array($date_competition, $date_competition_libelle_1, $date_competition_libelle_2));
	}
}


// Critères de la recherche
$where = $sous_titre_libelle = '';
if(isset($critere_dates)){
	$critere_dates = explode(',', $critere_dates);
}else{
	$critere_dates = array('cumul');
}
if(strlen(trim($critere_groupes))!=0){
	$critere_groupes = explode(',', $critere_groupes);
}else{
	$critere_groupes = array();
}
if(strlen(trim($critere_golfs))!=0){
	$critere_golfs = explode(',', $critere_golfs);
}else{
	$critere_golfs = array();
}

if(isset($critere_dates) AND in_array('cumul', $critere_dates)==false){
	$where .= ' AND planning_depart_date IN ("'.implode('","', $critere_dates).'")';
}

if(isset($critere_groupes) AND count($critere_groupes)!=0){

	if(count($critere_groupes)>1){
		$sous_titre_libelle = 'Groupes '.ESPACE;
	}else{
		$sous_titre_libelle = 'Groupe ';
	}

	$where .= ' AND planning_groupe IN ("'.implode('","', $critere_groupes).'")';
	$sous_titre_libelle .= trim(implode(' ', $critere_groupes));

}

if(isset($critere_golfs) AND count($critere_golfs)!=0){

	if(count($critere_golfs)>1){
		$sous_titre_libelle_2 .= 'GOLFS ';
	}else{
		$sous_titre_libelle_2 .= 'GOLF ';
	}

	$where .= ' AND golf_id IN ("'.implode('","', $critere_golfs).'")';

	foreach($critere_golfs as $golf_cle=>$golf_selection){

		// Sélection des dates enregistrées
		$requete_golf = mysqli_query($connexion_mysql, 'SELECT golf_nom FROM golfs WHERE golf_id="'.$golf_selection.'"');
		$resultat_golf = mysqli_fetch_array($requete_golf);
		$golf_nom = strtoupper_max($resultat_golf[0]);

		$sous_titre_libelle_2 .= $golf_nom.' - ';
	}

	$sous_titre_libelle_2 = trim(substr(trim($sous_titre_libelle_2), 0, -1));

}


$tab_joueurs_pros_abandonnes = array();
$liste_joueurs_pros_abondonnes = '';

// Sélection des joueurs professionnels qui ont abandonnés
$requete_joueurs_pros_abandonnes = mysqli_query($connexion_mysql, 'SELECT equipe_id FROM scores WHERE score_joueur_pro_abandon=1');
$nb_joueurs_pros_abandonnes = mysqli_num_rows($requete_joueurs_pros_abandonnes);
if($nb_joueurs_pros_abandonnes!=0){
	for($joueur_pro_abandonne_boucle=0; $joueur_pro_abandonne_boucle<$nb_joueurs_pros_abandonnes; $joueur_pro_abandonne_boucle++){
		$resultat_joueur_pro_abandonne = mysqli_fetch_array($requete_joueurs_pros_abandonnes);
		$joueur_pro_abondonne_id = $resultat_joueur_pro_abandonne[0];

		array_push($tab_joueurs_pros_abandonnes, $joueur_pro_abondonne_id);		// Tableau stockant le numéro du classement des joueurs pros

	}
	$tab_joueurs_pros_abandonnes = array_unique($tab_joueurs_pros_abandonnes);
	$liste_joueurs_pros_abondonnes = implode('","', $tab_joueurs_pros_abandonnes);
}

// echo '//'.$liste_joueurs_pros_abondonnes.'//<br><br>';


// Sélection des joueurs enregistrés uniquement ceux n'ayant pas abandonnées
$requete_scores = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id NOT IN ("'.$liste_joueurs_pros_abondonnes.'")'.$where.'  GROUP BY A.equipe_id ORDER BY SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs C INNER JOIN equipes_joueurs D ON C.joueur_id=D.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")');
$nb_scores = mysqli_num_rows($requete_scores);

// Sélection des joueurs pros enregistrés uniquement ceux ayant abandonnés
$requete_scores_abandons = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total), planning_groupe FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id IN ("'.$liste_joueurs_pros_abondonnes.'")'.$where.'  GROUP BY A.equipe_id ORDER BY (SELECT SUM(score_joueur_pro_reference) FROM scores C INNER JOIN planning D ON C.planning_id=D.planning_id WHERE A.equipe_id=equipe_selection AND planning_depart_date<="'.$competition_date_fin.'"), SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs E INNER JOIN equipes_joueurs F ON E.joueur_id=F.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")');
$nb_scores_abandons = mysqli_num_rows($requete_scores_abandons);

// Traitement spécifique pour le classement des joueurs pros en cas de scores identiques
//$requete_scores_nums = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE '.$where.'  GROUP BY A.equipe_id ORDER BY SUM(score_joueur_pro_resultats_total), (SELECT joueur_nom FROM joueurs C INNER JOIN equipes_joueurs D ON C.joueur_id=D.ej_joueur WHERE ej_equipe=equipe_selection AND joueur_profil="pro")');


$requete_scores_nums = mysqli_query($connexion_mysql, 'SELECT A.equipe_id AS equipe_selection, SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id');

$nb_scores_nums = mysqli_num_rows($requete_scores_nums);
if($nb_scores_nums!=0){
	$tab_scores = array();

	for($score_num_boucle=0; $score_num_boucle<$nb_scores_nums; $score_num_boucle++){
		$resultat_score_num = mysqli_fetch_array($requete_scores_nums);
		$score_num_joueur_total = $resultat_score_num[1];

		array_push($tab_scores, $score_num_joueur_total);		// Tableau stockant le score total des joueurs pros

	}
}


/**************************************************************************************************************************************/

class PDF extends FPDF {

	function Header(){

		global $competition_annee;
		global $tab_dates;
		global $sous_titre_libelle;
		global $sous_titre_libelle_2;

		$this->Image('../../../img/logo_proamcoteopale_noirblanc.png', 8, 8.4, -300);		// Image de l'entête

		$this->SetFont('Arial', 'B', 38);
		$this->SetTextColor(0,0,0);
		$this->Cell(24.5, 1, '', 0, 0, 'L', false);
		$this->Cell(30, 9, $competition_annee, 0, 0, 'L', false);

		$this->SetFont('Arial', '', 20);
		$this->Cell(130, 9, utf8_decode('Classement cumulé PRO'), 0, 2, 'C', false);
		$this->SetFont('Arial', '', 16);
		if(strlen(trim($sous_titre_libelle))!=0){
			$this->Cell(130, 8, $sous_titre_libelle, 0, 1, 'C', false);
		}
		if(strlen(trim($sous_titre_libelle_2))!=0){
			if(strlen(trim($sous_titre_libelle))!=0){
				$this->Cell(57, 1, '', 0, 0, 'L', false);
			}
			$this->Cell(130, 8, $sous_titre_libelle_2, 0, 1, 'C', false);
		}
		if(strlen(trim($sous_titre_libelle))==0 AND strlen(trim($sous_titre_libelle_2))==0){
			$this->ln(16);
		}elseif(strlen(trim($sous_titre_libelle))==0 OR strlen(trim($sous_titre_libelle_2))==0){
			$this->ln(8);
		}

		$this->SetFont('Arial', 'B', 8);
		$this->Cell(10, 8, '', 0, 0, 'L', false);
		$this->Cell(60, 8, ESPACE.ESPACE.'PROFESSIONNEL', 0, 0, 'L', false);
		$this->Cell(22, 8, 'GROUPE', 0, 0, 'C', false);

		// Affichage des dates enregistrées
		if(count($tab_dates)!=0){
			foreach($tab_dates as $date_selection_cle=>$date_selection){
				$date_competition = $date_selection[2];

				$this->Cell(20, 8, $date_competition, 0, 0, 'C', false);

			}
		}

		$this->Cell(20, 8, 'CUMUL', 0, 1, 'C', false);

	}


	function Lignes($connexion_mysql, $requete_scores, $nb_scores, $requete_scores_abandons, $nb_scores_abandons, $tab_scores, $competition_id, $tab_dates, $critere_dates){

		$this->SetLineWidth(0.5);

		for($score_boucle=0; $score_boucle<$nb_scores; $score_boucle++){
			$resultat_score = mysqli_fetch_array($requete_scores);
			$equipe_id = $resultat_score[0];
			$score_joueur_total = $resultat_score[1];
			$planning_groupe = $resultat_score[2];

			if(!isset($score_classement_affichage) OR (isset($score_classement_affichage) AND $score_joueur_total!=$tab_scores[$score_boucle-1])){
				$score_classement_affichage = $score_boucle + 1;
			}

			// Sélection des joueurs de l'équipe
			$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="pro"');
			$resultat_joueur = mysqli_fetch_array($requete_joueurs);
			$joueur_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0]))));
			$joueur_prenom = utf8_decode(ucwords(strtolower(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))))));

			// Permet de mettre la 1ere lettre en majuscule si le prénom est composé (avec -)
			if(preg_match('/-/', $joueur_prenom)==true){
				$joueur_prenom_tab = explode('-', $joueur_prenom);
				$joueur_prenom = '';
				foreach($joueur_prenom_tab as $joueur_prenom_morceau){
					$joueur_prenom .= ucwords(strtolower($joueur_prenom_morceau)).'-';
				}
				$joueur_prenom = substr($joueur_prenom, 0, -1);
			}

			$joueur_nom_prenom = $joueur_nom.' '.$joueur_prenom;
			if(strlen($joueur_nom_prenom)>27){  $joueur_nom_prenom = substr($joueur_nom_prenom, 0, 27).'.'; }

			$this->SetFont('Arial', 'B', 10);
			$this->SetFillColor(241);
			$this->Cell(10, 8, $score_classement_affichage, 'TB', 0, 'C', true);
			$this->Cell(60, 8, ESPACE.ESPACE.$joueur_nom_prenom, 'TB', 0, 'L', false);

			$this->SetFont('Arial', '', 10);
			$this->Cell(22, 8, $planning_groupe, 'TB', 0, 'C', false);

			// Affichage des dates enregistrées
			if(count($tab_dates)!=0){
				foreach($tab_dates as $date_selection_cle=>$date_selection){
					$date_competition = $date_selection[0];
					if($date_selection_cle==count($tab_dates)-1){ $retour_ligne = 1; }else{ $retour_ligne = 0; }

					if(in_array($date_competition, $critere_dates)==true OR in_array('cumul', $critere_dates)==true){

						// Sélection du score du jour
						$requete_score_jour = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_resultats_total, score_joueur_pro_reference FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE planning_depart_date="'.$date_competition.'" AND A.equipe_id="'.$equipe_id.'"');
						$resultat_score_jour = mysqli_fetch_array($requete_score_jour);
						$score_joueur_jour = $resultat_score_jour[0];
						$score_joueur_pro_reference = $resultat_score_jour[1];

						$this->SetFont('Arial', 'B', 13);

						if(strlen(trim($score_joueur_jour))!=0){
							$this->Cell(20, 8, $score_joueur_jour, 'TB', 0, 'C', false);
						}else{
							$this->Cell(20, 8, '', 'TB', 0, 'C', false);
						}

					}else{

						$this->Cell(20, 8, '', 'TB', 0, 'C', false);

					}

				}

				// Sélection du score cumulé chaque jour
				$requete_score_cumule_jour = mysqli_query($connexion_mysql, 'SELECT SUM(score_joueur_pro_resultats_total) FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$equipe_id.'"');
				$resultat_score_cumule_jour = mysqli_fetch_array($requete_score_cumule_jour);
				$score_joueur_cumule_jours = $resultat_score_cumule_jour[0];

				$this->Cell(20, 8, $score_joueur_cumule_jours, 'TB', 1, 'C', false);

			}

		}


		/********************************************************/
		/****  AFFICHAGE DES JOUEURS PROS AYANT ABONNDONNÉS  ****/
		/********************************************************/

		for($score_abandon_boucle=0; $score_abandon_boucle<$nb_scores_abandons; $score_abandon_boucle++){
			$resultat_score_abandon = mysqli_fetch_array($requete_scores_abandons);
			$equipe_id = $resultat_score_abandon[0];
			$score_joueur_total = $resultat_score_abandon[1];
			$planning_groupe = $resultat_score_abandon[2];

			$score_classement_affichage = $score_boucle + 1;

			// Sélection des joueurs de l'équipe
			$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil="pro"');
			$resultat_joueur = mysqli_fetch_array($requete_joueurs);
			$joueur_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0]))));
			$joueur_prenom = utf8_decode(ucwords(strtolower(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))))));

			// Permet de mettre la 1ere lettre en majuscule si le prénom est composé (avec -)
			if(preg_match('/-/', $joueur_prenom)==true){
				$joueur_prenom_tab = explode('-', $joueur_prenom);
				$joueur_prenom = '';
				foreach($joueur_prenom_tab as $joueur_prenom_morceau){
					$joueur_prenom .= ucwords(strtolower($joueur_prenom_morceau)).'-';
				}
				$joueur_prenom = substr($joueur_prenom, 0, -1);
			}

			$joueur_nom_prenom = $joueur_nom.' '.$joueur_prenom;
			if(strlen($joueur_nom_prenom)>27){  $joueur_nom_prenom = substr($joueur_nom_prenom, 0, 27).'.'; }

			$this->SetFont('Arial', 'B', 10);
			$this->SetFillColor(241);
			$this->Cell(10, 8, $score_classement_affichage, 'TB', 0, 'C', true);
			$this->Cell(60, 8, ESPACE.ESPACE.$joueur_nom_prenom, 'TB', 0, 'L', false);

			$this->SetFont('Arial', '', 10);
			$this->Cell(22, 8, $planning_groupe, 'TB', 0, 'C', false);

			// Affichage des dates enregistrées
			if(count($tab_dates)!=0){
				$indicateur_pro_abdandon = 0;
				foreach($tab_dates as $date_selection_cle=>$date_selection){
					$date_competition = $date_selection[0];
					if($date_selection_cle==count($tab_dates)-1){ $retour_ligne = 1; }else{ $retour_ligne = 0; }

					if(in_array($date_competition, $critere_dates)==true OR in_array('cumul', $critere_dates)==true){

						// Sélection du score du jour
						$requete_score_jour = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_resultats_total, score_joueur_pro_reference, score_joueur_pro_abandon FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE planning_depart_date="'.$date_competition.'" AND A.equipe_id="'.$equipe_id.'"');
						$resultat_score_jour = mysqli_fetch_array($requete_score_jour);
						$score_joueur_jour = $resultat_score_jour[0];
						$score_joueur_pro_reference = $resultat_score_jour[1];
						$score_joueur_pro_abandon = $resultat_score_jour[2];

						$this->SetFont('Arial', 'B', 13);

						if($score_joueur_pro_abandon==1){
							$indicateur_pro_abdandon = 1;
							$this->Cell(20, 8, 'ABD', 'TB', 0, 'C', false);
						}elseif(strlen(trim($score_joueur_jour))!=0){
							$this->Cell(20, 8, $score_joueur_jour, 'TB', 0, 'C', false);
						}else{
							$this->Cell(20, 8, '', 'TB', 0, 'C', false);
						}

					}else{

						$this->Cell(20, 8, '', 'TB', 0, 'C', false);

					}

				}

				$this->Cell(20, 8, 'ABD', 'TB', 1, 'C', false);

			}

		}

	}


	// Pied de page
	function Footer(){

		$this->SetXY(0, -10);															// Positionnement à 0 cm à gauche et à 1,5 cm du bas

		$this->SetFont('Arial', '', 9);
		$this->SetTextColor(0,0,0);
		$this->Cell(205, 4, $this->PageNo().' / {nb}', 0, 1, 'R', false);				// Numéro de page

	}

}

/**************************************************************************************************************************************/

// Instanciation de la classe dérivée
$pdf = new PDF();
$pdf->AliasNbPages();

$pdf->SetMargins(8, 10, 8);
$pdf->AddPage();

$pdf->Lignes($connexion_mysql, $requete_scores, $nb_scores, $requete_scores_abandons, $nb_scores_abandons, $tab_scores, $competition_id, $tab_dates, $critere_dates);

if(isset($archive) AND $archive==1){
	$pdf->Output('../../../archives/archive_'.$competition_annee.'_classement_cumule_pro.pdf', 'F');
	header('Location: ../../competitions/competitions/archiver.php?process=fin');
	exit;
}else{
	$pdf->Output('Classement_cumulé_pro_'.$competition_annee.'.pdf', 'I');
}
?>
