<?php 
include '../lib/configuration.inc';

if(!isset($_SESSION['SessionWeb_joueur_id'])){
	header('Location: ./deconnexion.php');
	exit;
}
?>

<html>
<head>
	<title><?=$txt_page_titre?></title>
	<?php include './commun/metatags.inc'; ?>
</head>

<body>

<?php include './commun/entete.inc'; ?>

<div id="contenu" align="center">

<div id="contenu_bis" align="left">

	<h1><?=$txt_espace_equipe_equipe_titre?></h1>

	<div class="separateur"></div>

	<?php 
	// Récupération de l'ID de l'équipe
	$requete_equipe = mysqli_query($connexion_mysql, 'SELECT ej_equipe, equipe_nom FROM equipes_joueurs A INNER JOIN equipes B ON A.ej_equipe=B.equipe_id WHERE ej_joueur="'.$_SESSION['SessionWeb_joueur_id'].'"');
	$resultat_equipe = mysqli_fetch_array($requete_equipe);
	$equipe_id = $resultat_equipe[0];
	$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_equipe[1])));
	?>

	<span style="font-weight: normal;"><?=$txt_espace_equipe_equipe_equipe?> :</span>&nbsp; <?=$equipe_nom?><br><br><br>

	<?php 
	// Sélection des joueurs de l'équipe sélectionnée
	$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom, joueur_email, joueur_profil, joueur_handicap FROM joueurs WHERE joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$equipe_id.'") AND joueur_actif="1" ORDER BY joueur_profil DESC, joueur_nom, joueur_prenom');
	$nb_joueurs = mysqli_num_rows($requete_joueurs);
	if($nb_joueurs!=0){

		for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
			$resultat_joueur = mysqli_fetch_array($requete_joueurs);
			$joueur_id = $resultat_joueur[0];
			$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
			$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2])));
			$joueur_email = $resultat_joueur[3];
			$joueur_profil = $resultat_joueur[4];
			$joueur_handicap = number_format($resultat_joueur[5], 1, ',', '');

			if($joueur_profil=='pro'){ $joueur_profil = $txt_professionnel; }elseif($joueur_profil=='am'){ $joueur_profil = $txt_amateur; }else{ $joueur_profil = $txt_accompagnateur; }
			if($joueur_handicap!='0,0'){ $joueur_handicap = $txt_espace_equipe_equipe_hcp.' '.preg_replace('/,0/', '', $joueur_handicap); }else{ $joueur_handicap = ''; }
	?>

			<?php if(strlen(trim($joueur_email))!=0){ ?>
				<a href="mailto:<?=$joueur_email?>"><?=$joueur_nom.' '.$joueur_prenom?></a><br>
			<?php }else{ ?>
				<?=$joueur_nom.' '.$joueur_prenom?><br>
			<?php } ?>
			<span style="font-weight: normal;">
				<?=ucfirst($joueur_profil)?><br>
				<?php if(strlen(trim($joueur_handicap))!=0){ ?>
					<?=$joueur_handicap?><br>
				<?php } ?>
				<br>
			</span>

	<?php 
		}
	}
	?>

</div>
</div>

</body>
</html>
