<?php
require_once '../../../lib/configuration.inc';
require_once '../../libs/fpdf.php';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND in_array(7, $_SESSION['SessionADMIN_compte_acces_modules'])==false){
	header('Location: ../../');
	exit;
}


define('ESPACE', chr(32));		// Remplace le caractère Espace (&nbsp;)


/**************************************************************************************************************************************/

class PDF extends FPDF {

	function Equipes($connexion_mysql, $equipe_id){

		$boucle = 0;

		// Sélection des joueurs de l'équipe sélectionnée
		$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom, joueur_profil FROM joueurs A INNER JOIN equipes_joueurs B ON A.joueur_id=B.ej_joueur WHERE ej_equipe="'.$equipe_id.'" AND joueur_profil<>"acc" ORDER BY joueur_profil DESC, joueur_nom, joueur_prenom');
		$nb_joueurs = mysqli_num_rows($requete_joueurs);
		if($nb_joueurs!=0){

			for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
				$resultat_joueur = mysqli_fetch_array($requete_joueurs);
				$joueur_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0]))));
				$joueur_prenom = utf8_decode(substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))), 0, 1)).'.';
				$joueur_profil = utf8_decode($resultat_joueur[2]);

				if($joueur_profil=='pro'){

					$this->SetFont('Arial', 'B', 33);
					$this->SetTextColor(169, 120, 25);
					$this->Cell(130, 17, $joueur_nom.' '.$joueur_prenom, 0, 0, 'L', false);

				}else{

					if($boucle==1){
						$this->Cell(130, 17, '', 0, 0, 'L', false);
					}else{
						$boucle++;
					}

					$this->SetFont('Arial', 'B', 33);
					$this->SetTextColor(0, 0, 0);
					$this->Cell(92, 17, $joueur_nom.' '.$joueur_prenom, 0, 1, 'L', false);

				}

			}

			$this->ln(12);

		}

	}


}

/**************************************************************************************************************************************/

// Instanciation de la classe dérivée
$pdf = new PDF('Landscape');
$pdf->SetMargins(4, 12, 4);
$pdf->AddPage();

// Sélection de la compétition
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_id FROM competitions WHERE competition_active="1" AND competition_archive="0"');
$resultat_competition = mysqli_fetch_array($requete_competition);
$competition_id = $resultat_competition[0];

$tab_groupes = array('A', 'B', 'C', 'D');
$page = 0;

foreach($tab_groupes as $groupe){

	// Sélection des équipes du groupe sélectionné
	$requete_equipes = mysqli_query($connexion_mysql, 'SELECT DISTINCT(A.equipe_id) FROM planning A INNER JOIN equipes B ON A.equipe_id=B.equipe_id WHERE A.competition_id="'.$competition_id.'" AND planning_groupe="'.$groupe.'" ORDER BY equipe_nom');
	$nb_equipes = mysqli_num_rows($requete_equipes);
	if($nb_equipes!=0){
		for($equipe_boucle=0; $equipe_boucle<$nb_equipes; $equipe_boucle++){
			$resultat_equipe = mysqli_fetch_array($requete_equipes);
			$equipe_id = $resultat_equipe[0];

			$pdf->Equipes($connexion_mysql, $equipe_id);

			if($page==3){
				$pdf->AddPage();
				$page++;
			}

		}

	}

}

$pdf->Output('Leader_Board.pdf', 'I');
?>
