<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(6, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


// Sélection du départ
$requete_planning = mysqli_query($connexion_mysql, 'SELECT A.competition_id, planning_groupe, A.equipe_id, equipe_nom, A.golf_id, golf_nom, planning_depart_date, DATE_FORMAT(planning_depart_date, "%d/%m/%Y"), DATE_FORMAT(planning_depart_heure, "%kh%i") FROM (planning A INNER JOIN golfs B ON A.golf_id=B.golf_id) INNER JOIN equipes C ON A.equipe_id=C.equipe_id WHERE planning_id='.$planning_id);
$resultat_planning = mysqli_fetch_array($requete_planning);
$competition_id = $resultat_planning[0];
$planning_groupe = $resultat_planning[1];
$planning_equipe = $resultat_planning[2];
$planning_equipe_nom = $resultat_planning[3];
$planning_golf_id = $resultat_planning[4];
$planning_golf_nom = strtoupper_max($resultat_planning[5]);
$planning_depart_date_brut = $resultat_planning[6];
$planning_depart_date = $resultat_planning[7];
$planning_depart_heure = $resultat_planning[8];


if(isset($action) AND $action=='modifier'){

	// Récupération de l'ID des joueurs (pro + am)
	$j = 0;
	foreach($score as $element_cle=>$element){
		if($j==0){
			$joueur_pro_id = $element_cle;
		}elseif($j==1){
			$joueur_am1_id = $element_cle;
		}elseif($j==2){
			$joueur_am2_id = $element_cle;
		}elseif($j==3){
			$joueur_am3_id = $element_cle;
		}
		$j++;
	}

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	foreach($score[$joueur_pro_id] as $score_trou=>$score_pro){
		if($score_pro==''){
			$erreur_message .= "- le score du joueur professionnel pour le trou n°".($score_trou+1)." est manquant<br>";
		}elseif(is_numeric($score_pro)==false AND is_int($score_pro)==false){
			$erreur_message .= "- le score du joueur professionnel pour le trou n°".($score_trou+1)." est incorrect<br>";
		}
	}
	foreach($score[$joueur_am1_id] as $score_trou=>$score_am1){
		if($score_am1 =='' OR (is_numeric($score_am1)==true AND is_int($score_am1)==true)){
			$erreur_message .= "- le score du joueur amateur 1 pour le trou n°".($score_trou+1)." est manquant ou incorrect<br>";
		}elseif(is_numeric($score_am1)==false AND is_int($score_am1)==false){
			$erreur_message .= "- le score du joueur amateur 1 pour le trou n°".($score_trou+1)." est incorrect<br>";
		}
	}
	foreach($score[$joueur_am2_id] as $score_trou=>$score_am2){
		if($score_am2 =='' OR (is_numeric($score_am2)==true AND is_int($score_am2)==true)){
			$erreur_message .= "- le score du joueur amateur 2 pour le trou n°".($score_trou+1)." est manquant ou incorrect<br>";
		}elseif(is_numeric($score_am2)==false AND is_int($score_am2)==false){
			$erreur_message .= "- le score du joueur amateur 2 pour le trou n°".($score_trou+1)." est incorrect<br>";
		}
	}
	foreach($score[$joueur_am3_id] as $score_trou=>$score_am3){
		if($score_am3 =='' OR (is_numeric($score_am3)==true AND is_int($score_am3)==true)){
			$erreur_message .= "- le score du joueur amateur 3 pour le trou n°".($score_trou+1)." est manquant ou incorrect<br>";
		}elseif(is_numeric($score_am3)==false AND is_int($score_am3)==false){
			$erreur_message .= "- le score du joueur amateur 3 pour le trou n°".($score_trou+1)." est incorrect<br>";
		}
	}


	if($erreur_message==''){

		/******************************/
		/**  Traitement des données  **/
		/******************************/

		$score_pro_resultats = implode(',', $score[$joueur_pro_id]);
		$score_am1_resultats = implode(',', $score[$joueur_am1_id]);
		$score_am2_resultats = implode(',', $score[$joueur_am2_id]);
		$score_am3_resultats = implode(',', $score[$joueur_am3_id]);

		$score_joueur_am1_coupsrecus = implode(',', $coups_recus[$joueur_am1_id]);
		$score_joueur_am2_coupsrecus = implode(',', $coups_recus[$joueur_am2_id]);
		$score_joueur_am3_coupsrecus = implode(',', $coups_recus[$joueur_am3_id]);

		$resultat_brut_6derniers = 0;
		$resultat_brut_3derniers = 0;

		for($b6=12; $b6<=17; $b6++){
			$resultat_brut_6derniers = $resultat_brut_6derniers + $resultat_brut[$b6];
		}

		for($b3=15; $b3<=17; $b3++){
			$resultat_brut_3derniers = $resultat_brut_3derniers + $resultat_brut[$b3];
		}

		$resultat_net_6derniers = 0;
		$resultat_net_3derniers = 0;

		for($n6=12; $n6<=17; $n6++){
			$resultat_net_6derniers = $resultat_net_6derniers + $resultat_net[$n6];
		}

		for($n3=15; $n3<=17; $n3++){
			$resultat_net_3derniers = $resultat_net_3derniers + $resultat_net[$n3];
		}


		$score_joueur_brut = implode(',', $resultat_brut);
		$score_joueur_net = implode(',', $resultat_net);

		if(!isset($score_joueur_pro_abandon)){ $score_joueur_pro_abandon = 0; }


		/*******************************************************/
		/**  Calcul du score de référence en fonction du PAR  **/
		/*******************************************************/

		// Sélection du score total du joueur pro
		$requete_golfs_par_total = mysqli_query($connexion_mysql, 'SELECT golf_par FROM golfs WHERE golf_id IN (SELECT DISTINCT(A.golf_id) FROM planning A INNER JOIN golfs B ON A.golf_id=B.golf_id WHERE planning_groupe="'.$planning_groupe.'" AND planning_depart_date="'.$planning_depart_date_brut.'")');
		$resultat_golfs_par_total = mysqli_fetch_array($requete_golfs_par_total);
		$golfs_par_total = $resultat_golfs_par_total[0];

		// Calcul du score de référence du joueur pro
		$score_joueur_pro_reference = $score_total - $golfs_par_total;
		$score_joueur_brut_reference = ($resultat_brut_total - $golfs_par_total) - $golfs_par_total;
		$score_joueur_net_reference = ($resultat_net_total - $golfs_par_total) - $golfs_par_total;


		/****************************************/
		/**  Enregistrement des modifications  **/
		/****************************************/

		// Suppression des résultats déjà enregistrés
		$requete_suppression = mysqli_query($connexion_mysql, 'DELETE FROM scores WHERE planning_id='.$planning_id);

		// Requête d'insertion des résultats
		$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO scores (competition_id, planning_id, equipe_id, score_joueur_pro_id, score_joueur_pro_resultats, score_joueur_pro_resultats_aller, score_joueur_pro_resultats_retour, score_joueur_pro_resultats_total, score_joueur_pro_reference, score_joueur_pro_abandon, score_joueur_am1_id, score_joueur_am1_resultats, score_joueur_am1_coupsrecus, score_joueur_am2_id, score_joueur_am2_resultats, score_joueur_am2_coupsrecus, score_joueur_am3_id, score_joueur_am3_resultats, score_joueur_am3_coupsrecus, score_joueur_brut, score_joueur_net, score_joueur_brut_retour, score_joueur_brut_aller, score_joueur_brut_total, score_joueur_brut_6derniers, score_joueur_brut_3derniers, score_joueur_brut_reference, score_joueur_net_retour, score_joueur_net_aller, score_joueur_net_total, score_joueur_net_6derniers, score_joueur_net_3derniers, score_joueur_net_reference) VALUES("'.$competition_id.'", '.$planning_id.', "'.$planning_equipe.'", "'.$joueur_pro_id.'", "'.$score_pro_resultats.'", '.$score_aller.', '.$score_retour.', '.$score_total.', '.$score_joueur_pro_reference.', '.$score_joueur_pro_abandon.', "'.$joueur_am1_id.'", "'.$score_am1_resultats.'", "'.$score_joueur_am1_coupsrecus.'", "'.$joueur_am2_id.'", "'.$score_am2_resultats.'", "'.$score_joueur_am2_coupsrecus.'", "'.$joueur_am3_id.'", "'.$score_am3_resultats.'", "'.$score_joueur_am3_coupsrecus.'", "'.$score_joueur_brut.'", "'.$score_joueur_net.'", '.$resultat_brut_retour.', '.$resultat_brut_aller.', '.$resultat_brut_total.', '.$resultat_brut_6derniers.', '.$resultat_brut_3derniers.', '.$score_joueur_brut_reference.', '.$resultat_net_retour.', '.$resultat_net_aller.', '.$resultat_net_total.', '.$resultat_net_6derniers.', '.$resultat_net_3derniers.', '.$score_joueur_net_reference.')');

		header('Location: ./modifier.php?planning_id='.$planning_id.'&enregistrement=ok');
		exit;

	}

}



// Initialisation des variables
$tab_roadbook[1] = $tab_roadbook[2] = $tab_roadbook[3] = $tab_roadbook[4] = $tab_roadbook_par = $tab_golf_hcp_coups_recus[1] = $tab_golf_hcp_coups_recus[2] = $tab_golf_hcp_coups_recus[3] = $tab_golf_hcp_coups_recus[4] = array();
$liste_joueurs = '';

// Sélection du roadbook
$requete_roadbook = mysqli_query($connexion_mysql, 'SELECT roadbook_golf, roadbook_trou, roadbook_par, roadbook_hcp, roadbook_blanche, roadbook_jaune, roadbook_rouge FROM golfs_roadbook ORDER BY roadbook_golf, roadbook_trou');
$nb_roadbook = mysqli_num_rows($requete_roadbook);
if($nb_roadbook!=0){
	for($roadbook_boucle=0; $roadbook_boucle<$nb_roadbook; $roadbook_boucle++){
		$resultat_roadbook = mysqli_fetch_array($requete_roadbook);
		$roadbook_golf = $resultat_roadbook[0];
		$roadbook_trou = $resultat_roadbook[1];
		$roadbook_par = $resultat_roadbook[2];
		$roadbook_hcp = $resultat_roadbook[3];
		$roadbook_blanche = $resultat_roadbook[4];
		$roadbook_jaune = $resultat_roadbook[5];
		$roadbook_rouge = $resultat_roadbook[6];

		array_push($tab_golf_hcp_coups_recus[$roadbook_golf], $roadbook_hcp);

		array_push($tab_roadbook[$roadbook_golf], array($roadbook_trou, $roadbook_par, $roadbook_hcp, $roadbook_blanche, $roadbook_jaune, $roadbook_rouge));
	}

	for($num_golf=0; $num_golf<=3; $num_golf++){

		$golf_numero = $num_golf + 1;

		// Cacul de la somme des PAR pour le parcours aller
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou<=9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_aller = $resultat_roadbook_par[0];

		// Cacul de la somme des PAR pour le parcours retour
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou>9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_retour = $resultat_roadbook_par[0];

		// Cacul du total des PAR (aller + retour)
		$roadbook_golf_par_total = $roadbook_golf_par_aller + $roadbook_golf_par_retour;

		array_push($tab_roadbook_par, array($golf_numero, $roadbook_golf_par_retour, $roadbook_golf_par_aller, $roadbook_golf_par_total));

	}
}


if(isset($erreur_message) AND $erreur_message==''){

	// Sélection de la carte de score
	$requete_carte = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_id, score_joueur_pro_resultats, score_joueur_pro_resultats_aller, score_joueur_pro_resultats_retour, score_joueur_pro_resultats_total, score_joueur_pro_abandon, score_joueur_am1_id, score_joueur_am1_resultats, score_joueur_am1_coupsrecus, score_joueur_am2_id, score_joueur_am2_resultats, score_joueur_am2_coupsrecus, score_joueur_am3_id, score_joueur_am3_resultats, score_joueur_am3_coupsrecus, score_joueur_brut, score_joueur_net, score_joueur_brut_retour, score_joueur_brut_aller, score_joueur_brut_total, score_joueur_net_retour, score_joueur_net_aller, score_joueur_net_total FROM scores WHERE competition_id="'.$competition_id.'" AND planning_id='.$planning_id);
	$nb_carte = mysqli_num_rows($requete_carte);
	if($nb_carte!=0){

		$resultat_carte = mysqli_fetch_array($requete_carte);
		$score_joueur_pro_id = $resultat_carte[0];
		$score_joueur_pro_resultats = explode(',', $resultat_carte[1]);
		$score_aller = $resultat_carte[2];
		$score_retour = $resultat_carte[3];
		$score_total = $resultat_carte[4];
		$score_joueur_pro_abandon = $resultat_carte[5];
		$score_joueur_am1_id = $resultat_carte[6];
		$score_joueur_am1_resultats = explode(',', $resultat_carte[7]);
		$score_joueur_am1_coupsrecus = explode(',', $resultat_carte[8]);
		$score_joueur_am2_id = $resultat_carte[9];
		$score_joueur_am2_resultats = explode(',', $resultat_carte[10]);
		$score_joueur_am2_coupsrecus = explode(',', $resultat_carte[11]);
		$score_joueur_am3_id = $resultat_carte[12];
		$score_joueur_am3_resultats = explode(',', $resultat_carte[13]);
		$score_joueur_am3_coupsrecus = explode(',', $resultat_carte[14]);
		$resultat_brut = explode(',', $resultat_carte[15]);
		$resultat_net = explode(',', $resultat_carte[16]);
		$resultat_brut_retour = $resultat_carte[17];
		$resultat_brut_aller = $resultat_carte[18];
		$resultat_brut_total = $resultat_carte[19];
		$resultat_net_retour = $resultat_carte[20];
		$resultat_net_aller = $resultat_carte[21];
		$resultat_net_total = $resultat_carte[22];

		$score = array($score_joueur_pro_id=>$score_joueur_pro_resultats, $score_joueur_am1_id=>$score_joueur_am1_resultats, $score_joueur_am2_id=>$score_joueur_am2_resultats, $score_joueur_am3_id=>$score_joueur_am3_resultats);

	}else{

		$score_retour = $score_aller = $score_total = '';
		$resultat_brut_retour = $resultat_brut_aller = $resultat_brut_total = '';
		$resultat_net_retour = $resultat_net_aller = $resultat_net_total = '';

	}

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<link rel="stylesheet" type="text/css" href="<?=$general_path_relatif?>css/cartes_score.css">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
	<script language="Javascript">
		function scoring(joueur_1, joueur_2, joueur_3, joueur_4){

			var TableauJoueurs = new Array(joueur_1, joueur_2, joueur_3, joueur_4);
			var score_retour = score_aller = score_total = 0;
			var resultat_brut_retour = resultat_brut_aller = resultat_brut_total = 0;
			var resultat_net_retour = resultat_net_aller = resultat_net_total = 0;

			/**  Calcul des totaux du joueur pro  **/

			for(i=0; i<TableauJoueurs.length; i++){
		 		joueur = TableauJoueurs[i];															// Récupération de l'ID du joueur
				for(trou=0; trou<=17; trou++){
					if(document.getElementById('score_' + joueur + '_' + trou).value==''){
						document.getElementById('score_' + joueur + '_' + trou).value = 9;			// Si le score du joueur est vide, alors on lui affecte le score de 9
					}

					if(i==0){
						if(trou<=8){
							score_aller = parseInt(score_aller) + parseInt(document.getElementById('score_' + joueur + '_' + trou).value);			// Addition des scores à l'aller pour le joueur pro
						}else{
							score_retour = parseInt(score_retour) + parseInt(document.getElementById('score_' + joueur + '_' + trou).value);		// Addition des scores au retour pour le joueur pro
						}
						score_total = parseInt(score_total) + parseInt(document.getElementById('score_' + joueur + '_' + trou).value);				// Addition des scores au total (aller+retour) pour le joueur pro
					}

				}
			}

			document.getElementById('score_retour_id').value = score_retour;		// Affichage du score au retour pour le joueur pro
			document.getElementById('score_aller_id').value = score_aller;			// Affichage du score à l'aller pour le joueur pro
			document.getElementById('score_total_id').value = score_total;			// Affichage du score total pour le joueur pro

			/**  Calculs des scores burt & net  **/

			for(trou=0; trou<=17; trou++){

				score_brut_pro = parseInt(document.getElementById('score_' + TableauJoueurs[0] + '_' + trou).value);
				score_brut_am_1 = parseInt(document.getElementById('score_' + TableauJoueurs[1] + '_' + trou).value);
				score_brut_am_2 = parseInt(document.getElementById('score_' + TableauJoueurs[2] + '_' + trou).value);
				score_brut_am_3 = parseInt(document.getElementById('score_' + TableauJoueurs[3] + '_' + trou).value);

				score_net_pro = parseInt(document.getElementById('score_' + TableauJoueurs[0] + '_' + trou).value);
				score_net_am_1 = parseInt(document.getElementById('score_' + TableauJoueurs[1] + '_' + trou).value) - parseInt(document.getElementById('coups_recus_' + TableauJoueurs[1] + '_' + trou).value);
				score_net_am_2 = parseInt(document.getElementById('score_' + TableauJoueurs[2] + '_' + trou).value) - parseInt(document.getElementById('coups_recus_' + TableauJoueurs[2] + '_' + trou).value);
				score_net_am_3 = parseInt(document.getElementById('score_' + TableauJoueurs[3] + '_' + trou).value) - parseInt(document.getElementById('coups_recus_' + TableauJoueurs[3] + '_' + trou).value);

				var TableauScoresResultatsBrut = new Array;
				var TableauScoresResultatsNet = new Array;

				TableauScoresResultatsBrut[0] = score_brut_pro;
				TableauScoresResultatsBrut[1] = score_brut_am_1;
				TableauScoresResultatsBrut[2] = score_brut_am_2;
				TableauScoresResultatsBrut[3] = score_brut_am_3;

				TableauScoresResultatsNet[0] = score_net_pro;
				TableauScoresResultatsNet[1] = score_net_am_1;
				TableauScoresResultatsNet[2] = score_net_am_2;
				TableauScoresResultatsNet[3] = score_net_am_3;

				TableauScoresResultatsBrut.sort();
				TableauScoresResultatsNet.sort();

				score_brut = parseInt(TableauScoresResultatsBrut[0]) + parseInt(TableauScoresResultatsBrut[1]);
				score_net = parseInt(TableauScoresResultatsNet[0]) + parseInt(TableauScoresResultatsNet[1]);

				document.getElementById('resultat_brut_' + trou + '_id').value = parseInt(score_brut);
				document.getElementById('resultat_net_' + trou + '_id').value = parseInt(score_net);


				/**  Calcul des totaux des socres brut & net  **/

				if(trou<=8){
					resultat_brut_aller = resultat_brut_aller + parseInt(score_brut);
					resultat_net_aller = resultat_net_aller + parseInt(score_net);
				}else{
					resultat_brut_retour = resultat_brut_retour + parseInt(score_brut);
					resultat_net_retour = resultat_net_retour + parseInt(score_net);
				}

			}

			document.getElementById('resultat_brut_retour_id').value = parseInt(resultat_brut_retour);
			document.getElementById('resultat_brut_aller_id').value = parseInt(resultat_brut_aller);
			document.getElementById('resultat_brut_total_id').value = parseInt(resultat_brut_aller + resultat_brut_retour);

			document.getElementById('resultat_net_retour_id').value = parseInt(resultat_net_retour);
			document.getElementById('resultat_net_aller_id').value = parseInt(resultat_net_aller);
			document.getElementById('resultat_net_total_id').value = parseInt(resultat_net_aller + resultat_net_retour);

		}

		function switch_score_2(evenement, champ_actuel, champ_suivant, id_suivant){

			autorisation = file('./verifier_saisie_score.php?valeur=' + champ_actuel.value);

			if(autorisation==2){
				champ_actuel.value = '';
				champ_actuel.focus();
			}

			if(id_suivant!=18 && autorisation==1){
				champ_suivant.value = '';
				champ_suivant.focus();
				champ_suivant.select();
			}

		}
	</script>
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 940px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Cartes de score</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">
				<input type="hidden" name="competition_id" value="<?=$competition_id?>">
				<input type="hidden" name="planning_id" value="<?=$planning_id?>">
				<input type="hidden" name="planning_equipe" value="<?=$planning_equipe?>">				

				<div id="formulaire_ligne_intertitre" style="width: 890px; font-size: 14px; color: #9C9A8C;">GROUPE&nbsp; <b><?=$planning_groupe?></b> &nbsp;&nbsp;-&nbsp;&nbsp; &Eacute;QUIPE&nbsp; <b><?=$planning_equipe_nom?></b> &nbsp;&nbsp;-&nbsp;&nbsp; GOLF DE&nbsp; <b><?=$planning_golf_nom?></b> &nbsp;&nbsp;-&nbsp;&nbsp; <?=$planning_depart_date?> &nbsp;&agrave;&nbsp; <?=$planning_depart_heure?></div>

				<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
					<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
				<?php } ?>

				<?php if(isset($enregistrement) AND $enregistrement=='ok'){ ?>
					<div align="center"><div id="message_confirmation" style="width: 300px;"><b>La carte de score a bien été renregistrée.</b></div></div>
				<?php } ?>

				<table border="0" id="carte_score">
					<tr>
						<td class="carte_entete_ligne">Trou</td>
						<td class="carte_entete">1</td>
						<td class="carte_entete">2</td>
						<td class="carte_entete">3</td>
						<td class="carte_entete">4</td>
						<td class="carte_entete">5</td>
						<td class="carte_entete">6</td>
						<td class="carte_entete">7</td>
						<td class="carte_entete">8</td>
						<td class="carte_entete">9</td>
						<td class="carte_entete">10</td>
						<td class="carte_entete">11</td>
						<td class="carte_entete">12</td>
						<td class="carte_entete">13</td>
						<td class="carte_entete">14</td>
						<td class="carte_entete">15</td>
						<td class="carte_entete">16</td>
						<td class="carte_entete">17</td>
						<td class="carte_entete">18</td>
						<td class="carte_fin_ligne">Retour</td>
						<td class="carte_fin_ligne">Aller</td>
						<td class="carte_fin_ligne">Total</td>
					</tr>
					<tr>
						<td class="carte_entete_ligne">Par</td>
						<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
							<td class="carte_ligne" style="font-weight: bold;"><?=$tab_trou[1]?></td>
						<?php } ?>
						<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($planning_golf_id-1)][1]?></td>
						<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($planning_golf_id-1)][2]?></td>
						<td class="carte_fin_ligne" style="font-weight: bold;"><?=$tab_roadbook_par[($planning_golf_id-1)][3]?></td>
					</tr>
					<tr>
						<td class="carte_entete_ligne">Handicap</td>
						<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
							<td class="carte_ligne"><?=$tab_trou[2]?></td>
						<?php } ?>
					</tr>
				</table>

				<table border="0" id="carte_score">
					<?php 
					$tab_joueurs = array();

					// Sélection des joueurs de l'équipe sélectionnée
					$requete_equipe_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom, joueur_profil, joueur_handicap FROM joueurs WHERE joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$planning_equipe.'") AND joueur_actif="1" AND joueur_profil<>"acc" ORDER BY joueur_profil DESC, joueur_handicap, joueur_nom, joueur_prenom');
					$nb_equipe_joueurs = mysqli_num_rows($requete_equipe_joueurs);
					if($nb_equipe_joueurs!=0){
						for($equipe_joueur_boucle=0; $equipe_joueur_boucle<$nb_equipe_joueurs; $equipe_joueur_boucle++){
							$resultat_equipe_joueur = mysqli_fetch_array($requete_equipe_joueurs);
							$equipe_joueur_id = $resultat_equipe_joueur[0];

							array_push($tab_joueurs, $equipe_joueur_id);

						}
					}

					foreach($tab_joueurs as $joueur_cle=>$joueur_id){

						// Sélection des joueurs de l'équipe sélectionnée
						$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom, joueur_profil, joueur_handicap FROM joueurs WHERE joueur_id="'.$joueur_id.'" AND joueur_actif="1" AND joueur_profil<>"acc" ORDER BY joueur_profil DESC, joueur_handicap, joueur_nom, joueur_prenom');
						$resultat_joueur = mysqli_fetch_array($requete_joueurs);
						$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0])));
						$joueur_prenom = substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1]))), 0, 1).'.';
						$joueur_profil = $resultat_joueur[2];
						$joueur_handicap = number_format($resultat_joueur[3], 1, '.', '');

						$liste_joueurs .= "'".$joueur_id."',";

						if(strlen($joueur_nom)>16){ $joueur_nom = substr($joueur_nom, 0, 15).'.'; }

						if(isset($tab_joueurs[($joueur_cle+1)])){
							$joueur_id_prochain = $tab_joueurs[($joueur_cle+1)];
						}

						/**************************************************************/
						/***  Calcul et attribution des coups reçus pour le joueur  ***/
						/**************************************************************/
						$tab_joueur_coups_recus = array();
						$joueur_coups_recus = round(($joueur_handicap/4)*3);
						foreach($tab_golf_hcp_coups_recus[$planning_golf_id] as $tab_golf_hcp){
							if($tab_golf_hcp<=$joueur_coups_recus){
								array_push($tab_joueur_coups_recus, 1);
							}else{
								array_push($tab_joueur_coups_recus, 0);
							}
						}

						if(substr($joueur_handicap, -2)=='.0'){ $joueur_handicap_libelle = substr($joueur_handicap, 0, -2); }else{ $joueur_handicap_libelle = $joueur_handicap; }
						if($joueur_profil=='am'){ $joueur_handicap_libelle = '<br><span style="font-weight: normal;">('.$joueur_handicap_libelle.')</span>'; }else{ $joueur_handicap_libelle = ''; }
					?>
						<!-- SCORES DES JOUEURS -->
						<tr>
							<td class="carte_entete_ligne" style="font-size: 10px;"><?=$joueur_nom.' '.$joueur_prenom.$joueur_handicap_libelle?></td>
							<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
								<?php 
								if($boucle_trou==17){
									$champ_suivant = 'this.form.score_'.$joueur_id_prochain.'_0';
									if(count($tab_joueurs)==($joueur_cle+1)){ $id_suivant = 18; }else{ $id_suivant = 0; }
								}else{
									$champ_suivant = 'this.form.score_'.$joueur_id.'_'.($boucle_trou+1);
									$id_suivant = $boucle_trou + 1;
								}
								if($joueur_cle==3 AND $boucle_trou==17){
									$javascript_switch = '';
								}else{
									$javascript_switch = ' onkeyup="switch_score_2(event, this.form.score_'.$joueur_id.'_'.$boucle_trou.', '.$champ_suivant.', '.$id_suivant.')"';
								}
								?>
								<td class="carte_ligne_resultat"><input type="text" id="score_<?=$joueur_id?>_<?=$boucle_trou?>" name="score[<?=$joueur_id?>][<?=$boucle_trou?>]" value="<?php if(isset($score[$joueur_id][$boucle_trou])){ echo $score[$joueur_id][$boucle_trou]; } ?>" maxlength="1" class="score"<?=$javascript_switch?>></td>
							<?php } ?>
							<?php if($joueur_profil!='am'){ ?>
								<td class="carte_fin_ligne_resultat"><input type="text" id="score_retour_id" name="score_retour" value="<?=$score_retour?>" readonly class="score_calcul" style="width: 95%;"></td>
								<td class="carte_fin_ligne_resultat"><input type="text" id="score_aller_id" name="score_aller" value="<?=$score_aller?>" readonly class="score_calcul" style="width: 95%;"></td>
								<td class="carte_fin_ligne_resultat" style="font-weight: bold;"><input type="text" id="score_total_id" name="score_total" value="<?=$score_total?>" readonly class="score_calcul" style="width: 95%; font-weight: bold;"></td>
							<?php }else{ ?>
								<?php if($joueur_cle==1){ ?>
									<td rowspan="2" colspan="3" class="carte_fin_ligne_resultat" style="font-size: 12px; color: #333333;"><input type="checkbox" id="joueur_pro_abandon" name="score_joueur_pro_abandon" value="1"<?php if($score_joueur_pro_abandon==1){ echo 'checked'; } ?> style="margin-bottom: 5px;"><br><label for="joueur_pro_abandon">abondon du<br>joueur professionnel</label></td>
								<?php }else{ ?>
									<td rowspan="2" colspan="3" class="carte_fin_ligne_resultat">&nbsp;</td>
								<?php } ?>
							<?php } ?>
						</tr>
						<!-- COUPS RECUS -->
						<?php if($joueur_profil=='am'){ ?>
							<tr>
								<td class="carte_ligne_coups_recus">coups reçus</td>
								<?php foreach($tab_joueur_coups_recus as $joueur_coup_recu_cle=>$joueur_coup_recu){ ?>
									<td class="carte_ligne_petit" style="height: 15px;"><input type="text" id="coups_recus_<?=$joueur_id?>_<?=$joueur_coup_recu_cle?>" name="coups_recus[<?=$joueur_id?>][<?=$joueur_coup_recu_cle?>]" value="<?=$joueur_coup_recu?>" maxlength="1" class="coups_recus" readonly></td>
								<?php } ?>
							</tr>
					<?php 
						}
					}

					$liste_joueurs = substr($liste_joueurs, 0, -1);
					?>
				</table>

				<div align="center"><span class="bouton" style="width: 180px; margin: 30px 0px 30px 0px;"><a href="Javascript:void(0);" onclick="scoring(<?=$liste_joueurs?>);">Calculer les résultats</a></span></div>

				<table border="0" id="carte_score">
					<!-- RESULTATS BRUT -->
					<tr>
						<td class="carte_entete_ligne">Brut</td>
						<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
							<td class="carte_ligne_resultat"><input type="text" id="resultat_brut_<?=$boucle_trou?>_id" name="resultat_brut[<?=$boucle_trou?>]" value="<?php if(isset($resultat_brut[$boucle_trou])){ echo $resultat_brut[$boucle_trou]; } ?>" readonly class="score_calcul"></td>
						<?php } ?>
						<td class="carte_fin_ligne_resultat"><input type="text" id="resultat_brut_retour_id" name="resultat_brut_retour" value="<?=$resultat_brut_retour?>" class="score_calcul" style="width: 95%;"></td>
						<td class="carte_fin_ligne_resultat"><input type="text" id="resultat_brut_aller_id" name="resultat_brut_aller" value="<?=$resultat_brut_aller?>" class="score_calcul" style="width: 95%;"></td>
						<td class="carte_fin_ligne_resultat" style="font-weight: bold;"><input type="text" id="resultat_brut_total_id" name="resultat_brut_total" value="<?=$resultat_brut_total?>" class="score_calcul" style="width: 95%; font-weight: bold;"></td>
					</tr>
					<!-- RESULTATS NET -->
					<tr>
						<td class="carte_entete_ligne">Net</td>
						<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
							<td class="carte_ligne_resultat"><input type="text" id="resultat_net_<?=$boucle_trou?>_id" name="resultat_net[<?=$boucle_trou?>]" value="<?php if(isset($resultat_net[$boucle_trou])){ echo $resultat_net[$boucle_trou]; } ?>" readonly class="score_calcul"></td>
						<?php } ?>
						<td class="carte_fin_ligne_resultat"><input type="text" id="resultat_net_retour_id" name="resultat_net_retour" value="<?=$resultat_net_retour?>" readonly class="score_calcul" style="width: 95%;"></td>
						<td class="carte_fin_ligne_resultat"><input type="text" id="resultat_net_aller_id" name="resultat_net_aller" value="<?=$resultat_net_aller?>" readonly class="score_calcul" style="width: 95%;"</td>
						<td class="carte_fin_ligne_resultat" style="font-weight: bold;"><input type="text" id="resultat_net_total_id" name="resultat_net_total" value="<?=$resultat_net_total?>" readonly class="score_calcul" style="width: 95%; font-weight: bold;"></td>
					</tr>
				</table>

				<table border="0" id="carte_score">
					<tr>
						<td class="carte_entete_ligne">Blanches</td>
						<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
							<td class="carte_ligne_petit"><?=$tab_trou[3]?></td>
						<?php } ?>
					</tr>
					<tr>
						<td class="carte_entete_ligne">Jaunes</td>
						<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
							<td class="carte_ligne_petit"><?=$tab_trou[4]?></td>
						<?php } ?>
					</tr>
					<tr>
						<td class="carte_entete_ligne">Rouges</td>
						<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
							<td class="carte_ligne_petit"><?=$tab_trou[5]?></td>
						<?php } ?>
					</tr>
				</table>

				<br>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
