<?php
if(!isset($fichier)){
	require_once '../../../../lib/configuration.inc';
}
require_once '../../../libs/fpdf.php';

// Vérification si l'accès est valide
if(!isset($facture_id) OR (isset($facture_id) AND strlen(trim($facture_id))==0)){
	header('Location: ../../../');
	exit;
}


define('EURO', chr(128));		// Remplace le caractère Euro (&euro;)
define('ESPACE', chr(32));		// Remplace le caractère Espace (&nbsp;)


// Sélection de la commande
$requete_facture = mysqli_query($connexion_mysql, 'SELECT joueur_sexe, joueur_nom, joueur_prenom, joueur_adresse_1, joueur_adresse_2, joueur_code_postal, joueur_ville, joueur_pays, joueur_langue, facture_numero, DATE_FORMAT(facture_date, "%d/%m/%Y"), facture_package, facture_entreprise_nom, facture_entreprise_adresse_1, facture_entreprise_adresse_2, facture_entreprise_code_postal, facture_entreprise_ville, facture_entreprise_pays, facture_tva_appliquee, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_payee, facture_mode_paiement, prix_forfait, prix_option, prix_heb FROM factures A INNER JOIN joueurs B ON A.joueur_id=B.joueur_id WHERE facture_id="'.$facture_id.'"');
$resultat_facture = mysqli_fetch_array($requete_facture);
$joueur_sexe = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[0])));
$joueur_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[1]))));
$joueur_prenom = utf8_decode(strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[2])))));
$joueur_adresse_1 = utf8_decode(strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[3])))));
$joueur_adresse_2 = utf8_decode(strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[4])))));
$joueur_code_postal = $resultat_facture[5];
$joueur_ville = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[6]))));
$joueur_pays = $resultat_facture[7];
$joueur_langue = $resultat_facture[8];
$facture_numero = $resultat_facture[9];
$facture_date = $resultat_facture[10];
$facture_package = $resultat_facture[11];
$facture_entreprise_nom = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[12]))));
$facture_entreprise_adresse_1 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[13]))));
$facture_entreprise_adresse_2 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[14]))));
$facture_entreprise_code_postal = $resultat_facture[15];
$facture_entreprise_ville = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[16]))));
$facture_entreprise_pays = $resultat_facture[17];
$facture_tva_appliquee = $resultat_facture[18];
$facture_prix_ht = number_format($resultat_facture[19], 2, ',', ' ');
$facture_prix_tva = number_format($resultat_facture[20], 2, ',', ' ');
$facture_prix_ttc = number_format($resultat_facture[21], 2, ',', ' ');
$facture_payee = $resultat_facture[22];
$facture_mode_paiement = $resultat_facture[23];
$prix_forfait = $resultat_facture[24];
$prix_option = $resultat_facture[25];
$prix_heb = $resultat_facture[26];


// Récupérations textes "fixes" facture



// Traductions en FR + EN
if(!isset($joueur_langue) OR (isset($joueur_langue) AND strlen(trim($joueur_langue))==0)){ $joueur_langue = 'FR'; }
require '../../../../web/commun/traductions_'.$joueur_langue.'.inc';

if($joueur_sexe=='H'){ $joueur_civilite = $txt_facture_monsieur; }else{ $joueur_civilite = $txt_facture_madame; }
while(strlen(trim($facture_numero)) < 3){ $facture_numero = '0'.$facture_numero; }
$facture_numero = 'PAB - '.substr($facture_date, -4).' - '.$facture_numero;
$pourcentage_tva = '0';
$facture_tva_pourcentage = number_format($pourcentage_tva, 0, ',', ' ');




// Sélection de la commande

$requete_fix_facture = mysqli_query($connexion_mysql, 'SELECT input1, input2, input3, input4, input5, input6, input7, input8, input9, input10, input11, input12, input13 FROM admin_modif_facture_'.$joueur_langue.' WHERE ID=1');
$resultat_fix_facture = mysqli_fetch_array($requete_fix_facture);
$input1 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[0]))));
$input2 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[1]))));
$input3 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[2]))));
$input4 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[3]))));
$input5 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[4]))));
$input6 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[5]))));
$input7 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[6]))));
$input8 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[7]))));
$input9 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[8]))));
//$input10 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes(convertMethod($resultat_fix_facture[9])))));
$input10 = iconv("UTF-8", "CP1252", $resultat_fix_facture[9]);


//$input10 = html_entity_decode(stripslashes(iconv("UTF-8", "CP1252", $resultat_fix_facture[9])));

$input11 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[10]))));
$input12 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[11]))));
//$input13 = utf8_decode(decodage_apostrophe(html_entity_decode(stripslashes($resultat_fix_facture[12]))));
$input13 = iconv("UTF-8", "CP1252", $resultat_fix_facture[12]);




// Fonctionn de sélection du pays
function selection_pays($pays_code, $langue='FR') {

	global $connexion_mysql;

	// Sélection du pays
	$requete_pays = mysqli_query($connexion_mysql, 'SELECT pays_libelle_'.$langue.' FROM pays WHERE pays_code="'.$pays_code.'"');
	$resultat_pays = mysqli_fetch_array($requete_pays);
	$pays_libelle = utf8_decode(decodage_apostrophe(strtoupper_max(html_entity_decode(stripslashes($resultat_pays[0])))));

	return $pays_libelle;
}


// Cas où le destinataire de la facture est un particulier
if(strlen(trim($facture_entreprise_nom))==0) {

	$joueur_nom = $joueur_civilite.' '.$joueur_prenom.' '.$joueur_nom;

	$joueur_coordonnees  = '';
	if($joueur_adresse_1!=","){ $joueur_coordonnees  = $joueur_adresse_1."\n"; }
	if(strlen(trim($joueur_adresse_2))!=0 AND $joueur_adresse_2!=","){ $joueur_coordonnees .= $joueur_adresse_2."\n"; }
	if($joueur_code_postal!="," AND $joueur_ville!=","){ $joueur_coordonnees .= $joueur_code_postal.' '.$joueur_ville."\n"; }
	if(strlen(trim($joueur_coordonnees))!=0){ $joueur_coordonnees .= selection_pays($joueur_pays); }

// Cas où le destinataire de la facture est une entreprise
} else {

	$joueur_nom = $facture_entreprise_nom;

	$joueur_coordonnees  = $facture_entreprise_adresse_1."\n";
	if(strlen(trim($facture_entreprise_adresse_2))!=0){ $joueur_coordonnees .= $facture_entreprise_adresse_2."\n"; }
	$joueur_coordonnees .= $facture_entreprise_code_postal.' '.$facture_entreprise_ville."\n";
	$joueur_coordonnees .= selection_pays($facture_entreprise_pays);

}

// Sélection des libellés de la facture
$requete_facture_libelles = mysqli_query($connexion_mysql, 'SELECT facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht, libelle_forfait, libelle_option, libelle_heb FROM factures_libelles WHERE facture_id="'.$facture_id.'"');
$nb_facture_libelles = mysqli_num_rows($requete_facture_libelles);
if($nb_facture_libelles!=0){
	for($facture_libelle_boucle=0; $facture_libelle_boucle<$nb_facture_libelles; $facture_libelle_boucle++){
		$resultat_facture_libelle = mysqli_fetch_array($requete_facture_libelles);
		//print_r($resultat_facture_libelle);
		$facture_libelle_description = utf8_decode(strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture_libelle[0])))));
		$facture_libelle_prix_unitaire_ttc = number_format($resultat_facture_libelle[1], 2, ',', ' ');
		$facture_libelle_quantite = $resultat_facture_libelle[2];
		$facture_libelle_prix_total_ht = number_format($resultat_facture_libelle[3], 2, ',', ' ');

		$libelle_forfait = $resultat_facture_libelle[4];
		$libelle_option = $resultat_facture_libelle[5];
		//$libelle_heb = $resultat_facture_libelle[6];
		$libelle_heb = utf8_decode(strtoupper_max(decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture_libelle[6])))));
		$facture_libelle_description = "\n".$facture_libelle_description."\n";

		$produits[$facture_libelle_boucle][0] = $facture_libelle_description;
		$produits[$facture_libelle_boucle][1] = $facture_libelle_prix_unitaire_ht;
		$produits[$facture_libelle_boucle][2] = $facture_libelle_quantite;
		$produits[$facture_libelle_boucle][3] = $facture_libelle_prix_total_ht;

		$produits[$facture_libelle_boucle][4] = $libelle_forfait;
		$produits[$facture_libelle_boucle][5] = $libelle_option;
		$produits[$facture_libelle_boucle][6] = $libelle_heb;

		}
	} else {
		$produits = array();
	}


$txt_facture_slogan = utf8_decode($txt_facture_slogan);
$txt_facture_date_le = utf8_decode($txt_facture_date_le);
$txt_facture_facture = utf8_decode($txt_facture_facture.' n°');
$txt_facture_libelle = utf8_decode($txt_facture_libelle);
$txt_facture_montant = utf8_decode($txt_facture_montant);
$txt_facture_tva = utf8_decode($txt_facture_tva);
$txt_facture_tva_intracommunautaire = utf8_decode($txt_facture_tva_intracommunautaire);
$txt_facture_virement = utf8_decode($txt_facture_virement);
$txt_facture_code_iban = utf8_decode($txt_facture_code_iban);
$txt_facture_code_bic = utf8_decode($txt_facture_code_bic);
$txt_facture_tel = utf8_decode($txt_facture_tel);
$txt_facture_cheque = utf8_decode($txt_facture_cheque);
$txt_facture_especes = utf8_decode($txt_facture_especes);
$txt_facture_carte_bancaire = utf8_decode($txt_facture_carte_bancaire);
$txt_facture_facture_payee = utf8_decode($txt_facture_facture_payee);


/**************************************************************************************************************************************/

class PDF extends FPDF {

	// En-tête
	function Header(){

		global $txt_facture_slogan;
		global $input1;

		$this->Image('../../../img/logo_facture.png', 10, 10, 90, 0, 'PNG');		// Image de l'entête de facture

		$this->Ln(8);

		$this->SetFont('Arial', '', 14);
		$this->Cell(100, 4, '', 0, 0, 'L', false);

		if ($input1 != '') {
			$this->MultiCell(90, 4, $input1, 0, 'L');
		} else {
			$this->MultiCell(90, 4, $txt_facture_slogan , 0, 'L');
		}

		

		$this->Ln(20);

	}

	// Titre et coordonnées du client
	function TitreClient($facture_numero, $facture_date, $joueur_nom, $joueur_coordonnees, $txt_facture_date_le, $txt_facture_facture){

		$this->SetFont('Arial', 'B', 12);
		$this->Cell(100, 6, '', 0, 0, 'L', false);
		$this->Cell(90, 6, $joueur_nom, 0, 1, 'L', false);

		$this->SetFont('Arial', '', 11);
		$this->Cell(100, 6, '', 0, 0, 'L', false);
		$this->MultiCell(90, 6, $joueur_coordonnees, 0, 'L');

		$this->Ln(5);

		$this->SetFont('Arial', '', 12);
		$this->Cell(100, 4, 'Anglet, '.$txt_facture_date_le.$facture_date.'.', 0, 1, 'L', false);

		$this->Ln(10);

		$this->Cell(22, 4, $txt_facture_facture.' ', 0, 0, 'L', false);
		$this->SetFont('Arial', 'B', 12);
		$this->SetTextColor(6,55,150);
		$this->MultiCell(90, 4, $facture_numero, 0, 'L');

		$this->Ln(10);

	}




	// Liste des libellés
	function Tableau($produits, $facture_tva_appliquee, $facture_prix_ht, $facture_prix_tva, $facture_prix_ttc, $facture_tva_pourcentage, $pays_code, $txt_facture_libelle, $txt_facture_montant_euro_ht_1, $txt_facture_montant_euro_ht_2, $txt_facture_montant, $txt_facture_tva, $txt_facture_montant_total_ht, $txt_facture_montant_total_ttc){

		// Entête de colonne
		$this->SetFont('Arial', 'B', 10);
		$this->SetFillColor(238, 238, 238);
		$this->SetTextColor(25,25,25);
		$this->Cell(130, 8, $txt_facture_libelle, 1, 0, 'C', true);
		$this->Cell(50, 8, $txt_facture_montant_euro_ht_1.' '.EURO.ESPACE.' '.$txt_facture_montant_euro_ht_2, 1, 1, 'C', true);

		//print_r($produits);


		if(count($produits)!=0){
			foreach($produits as $produit_cle=>$produit){


				if(preg_match("/\n/", $produits[$produit_cle][0])==false){

					$this->SetFont('Arial', '', 10);
					$this->Cell(130, 8, ESPACE.ESPACE.$produits[$produit_cle][0], 'LR', 0, 'L', false);														// Libellé du produit
					$this->Cell(50, 8, $produits[$produit_cle][3].' '.EURO.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 1, 'R', false);								// Montant total HT

				} else {



					$produit_libelle_tab = explode("\n", $produits[$produit_cle][4]);


					foreach($produit_libelle_tab as $produit_libelle_cle=>$produit_libelle){


						if(strlen(trim($produit_libelle))!=0){



							$this->SetFont('Arial', '', 10);
							$this->Cell(130, 6, ESPACE.ESPACE.$produit_libelle, 'LR', 0, 'L', false);														// Libellé du produit
							if($produit_libelle_cle==1){
								$this->Cell(50, 5, ESPACE.ESPACE.$produits[$produit_cle][3]." ".EURO.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 1, 'R', false);		// Montant total HT
							}else{
								$this->Cell(50, 5, '', 'LR', 1, 'R', false);																				// Cellule vide
							}

						}else{
							$this->Cell(130, 3, '', 'LR', 0, 'L', false);																					// Cellule vide
							$this->Cell(50, 3, '', 'LR', 1, 'R', false);																					// Cellule vide
						}

					}

				}

				$this->Cell(180, 0, '', 'T', 1, 'L', false);																								// Séparateur horizontal des produits

			}

			// Cas particulier pour la Belgique
			if($facture_tva_appliquee=="0"){

				$this->SetFont('Arial', 'B', 12);
				$this->Cell(130, 12, $txt_facture_montant_total_ht.ESPACE.ESPACE.ESPACE.ESPACE, '', 0, 'R', false);											// Libellé Total HT
				$this->Cell(50, 12, $facture_prix_ht.' '.EURO.ESPACE.ESPACE.ESPACE, '', 1, 'R', false);														// Montant HT

			}else{

				$this->SetFont('Arial', '', 10);
				$this->Cell(130, 8, $txt_facture_montant_total_ht.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 0, 'R', false);										// Libellé Total HT
				$this->Cell(50, 8, $facture_prix_ht.' '.EURO.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 1, 'R', false);												// Montant total HT

				$this->Cell(180, 0, '', 'T', 1, 'L', false);																								// Séparateur horizontal des produits

				$this->Ln(2);

				$this->SetFont('Arial', '', 10);
				$this->Cell(130, 8, $txt_facture_tva.' '.$facture_tva_pourcentage." %".ESPACE.ESPACE.ESPACE.ESPACE, '', 0, 'R', false);						// Libellé de la TVA
				$this->Cell(50, 8, $facture_prix_tva.' '.EURO.ESPACE.ESPACE.ESPACE.ESPACE, '', 1, 'R', false);												// Montant TVA

				$this->SetFont('Arial', 'B', 12);
				$this->Cell(130, 6, $txt_facture_montant_total_ttc.ESPACE.ESPACE.ESPACE.ESPACE, '', 0, 'R', false);											// Libellé Total TTC
				$this->Cell(50, 6, $facture_prix_ttc.' '.EURO.ESPACE.ESPACE.ESPACE, '', 1, 'R', false);														// Montant TTC

			}

		}
		$this->Ln(10);

	}








/*

	// Liste des libellés
	function Tableau($produits, $facture_tva_appliquee, $facture_prix_ht, $facture_prix_tva, $facture_prix_ttc, $facture_tva_pourcentage, $pays_code, $txt_facture_libelle, $txt_facture_montant_euro_ht_1, $txt_facture_montant_euro_ht_2, $txt_facture_montant, $txt_facture_tva, $txt_facture_montant_total_ht, $txt_facture_montant_total_ttc, $libelle_forfait, $libelle_option, $libelle_heb, $prix_forfait, $prix_option, $prix_heb){

		// Entête de colonne
		$this->SetFont('Arial', 'B', 10);
		$this->SetFillColor(238, 238, 238);
		$this->SetTextColor(25,25,25);
		$this->Cell(130, 8, $txt_facture_libelle, 1, 0, 'C', true);
		$this->Cell(50, 8, $txt_facture_montant_euro_ht_1.' '.EURO.ESPACE.' '.$txt_facture_montant_euro_ht_2, 1, 1, 'C', true);




		if(count($produits)!=0){
			foreach( $produits as $produit_cle => $produit ) {

				//print_r($produit);


				foreach( $produit as $key => $value ) {


					print_r($produit);
					echo "\n";

					$this->SetFont('Arial', '', 10);

					if((int)$key == 3 && trim($libelle_forfait) != '') {
						$this->Cell(130, 6, ESPACE.ESPACE.$libelle_forfait, 'LR', 0, 'L', false);	
						$this->Cell(50, 5, $prix_forfait.' '.EURO.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 1, 'R', false);
					}
					else if ((int)$key == 4 and (int)$prix_option != 0) {
						$this->Cell(130, 6, ESPACE.ESPACE.$libelle_option, 'LR', 0, 'L', false);	
						$this->Cell(50, 5, $prix_option.' '.EURO.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 1, 'R', false);
					}
					else if ((int)$key == 5 and (int)$prix_heb != 0) {
						$libelle_heb = explode("\n", $libelle_heb);

						$numItems = count($libelle_heb);
						$i = 0;
						foreach($libelle_heb as $libelle_heb_cle=>$libelle_heb_value) {
							$this->SetFont('Arial', '', 10);
							$this->Cell(130, 6, ESPACE.ESPACE.$libelle_heb_value, 'LR', 0, 'L', false);	

							if(++$i === $numItems) {
								$this->Cell(50, 5, $prix_heb.' '.EURO.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 1, 'R', false);
							} else {
								$this->Cell(50, 5, '', 'LR', 1, 'R', false);
							}
							
						}


					}
					else {
						$nothing = '';
						//$this->Cell(130, 6, '', 'LR', 0, 'L', false);	
						//$this->Cell(50, 5, '', 'LR', 1, 'R', false);
					}

					$this->Cell(180, 0, '', 'T', 1, 'L', false);

				}
				break;


			}

			// Cas particulier pour la Belgique
			if($facture_tva_appliquee=="0") {

				$this->SetFont('Arial', 'B', 12);
				$this->Cell(130, 12, $txt_facture_montant_total_ht.ESPACE.ESPACE.ESPACE.ESPACE, '', 0, 'R', false);											// Libellé Total HT
				$this->Cell(50, 12, $facture_prix_ht.' '.EURO.ESPACE.ESPACE.ESPACE, '', 1, 'R', false);														// Montant HT

			} else {

				$this->SetFont('Arial', '', 10);
				$this->Cell(130, 8, $txt_facture_montant_total_ht.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 0, 'R', false);										// Libellé Total HT
				$this->Cell(50, 8, $facture_prix_ht.' '.EURO.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 1, 'R', false);												// Montant total HT

				$this->Cell(180, 0, '', 'T', 1, 'L', false);																								// Séparateur horizontal des produits

				$this->Ln(0);

				$this->SetFont('Arial', '', 10);
				$this->Cell(130, 8, $txt_facture_tva.' '.$facture_tva_pourcentage." %".ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 0, 'R', false);						// Libellé de la TVA
				$this->Cell(50, 8, $facture_prix_tva.' '.EURO.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 1, 'R', false);												// Montant TVA

				$this->SetFont('Arial', 'B', 12);
				$this->Cell(130, 6, $txt_facture_montant_total_ttc.ESPACE.ESPACE.ESPACE.ESPACE, 'LR', 0, 'R', false);											// Libellé Total TTC
				$this->Cell(50, 6, $facture_prix_ttc.' '.EURO.ESPACE.ESPACE.ESPACE, 'LR', 1, 'R', false);														// Montant TTC
				$this->Cell(180, 0, '', 'T', 1, 'L', false);
				


			}

		}
		$this->Ln(10);

	}
*/























	// Infos pour virement
	function Virement($joueur_langue, $txt_facture_tva_intracommunautaire, $txt_facture_virement, $txt_facture_code_iban, $txt_facture_code_bic) {

		global $input2, $input3, $input4, $input5, $input6, $input7;
		$txt_facture_tva_intracommunautaire_value = '';
		$txt_facture_code_iban = '';


		if($joueur_langue!='FR'){ $txt_facture_tva_intracommunautaire_cellule = 26; }else{ $txt_facture_tva_intracommunautaire_cellule = 68; }


		if($input2 != '') { $txt_facture_tva_intracommunautaire = $input2;}

		if($input3 != '') { $txt_facture_tva_intracommunautaire_value = $input3;}
		else { $txt_facture_tva_intracommunautaire_value = 'FRN 80343042107';}


		if($input4 != '') { $txt_facture_virement = $input4;}

		if($input5 != '') { $txt_facture_virement_val_1 = $input5;} else { $txt_facture_virement_val_1 = 'Banque BNP Paribas - Paris Docteur Blanche'; }
		if($input6 != '') { $txt_facture_virement_val_2 = $input6;} else { $txt_facture_virement_val_2 = 'Code IBAN : FR76 ....'; }

		if($input7 != '') { $txt_facture_virement_val_3 = $input7;} else { $txt_facture_virement_val_3 = 'Code BIC : BNP ....'; }


		//if($input5 != '') { $txt_facture_code_iban = $input5;}

		$this->SetFont('Arial', 'B', 11);
		$this->Cell(68, 8, $txt_facture_tva_intracommunautaire.' :', 0, 0, 'L', false);
		$this->SetFont('Arial', '', 11);
		$this->Cell(90, 8, $txt_facture_tva_intracommunautaire_value, 0, 1, 'L', false);

		$this->SetFont('Arial', 'B', 11);
		$this->Cell(26, 5, $txt_facture_virement.' :', 0, 0, 'L', false);
		$this->SetFont('Arial', '', 11);
		$this->Cell(90, 5, $txt_facture_virement_val_1, 0, 1, 'L', false);
		$this->Cell(26, 6, '', 0, 0, 'L', false);
		$this->Cell(90, 5, $txt_facture_virement_val_2, 0, 1, 'L', false);
		$this->Cell(26, 6, '', 0, 0, 'L', false);
		$this->Cell(90, 5, $txt_facture_virement_val_3, 0, 1, 'L', false);

	}


	// Paiement
	function Paiement($facture_payee, $facture_mode_paiement, $txt_facture_cheque, $txt_facture_virement, $txt_facture_especes, $txt_facture_carte_bancaire, $txt_facture_facture_payee){

		if($facture_payee=="1"){

			if($facture_mode_paiement=='CHQ'){
				$facture_mode_paiement = $txt_facture_cheque;
			}elseif($facture_mode_paiement=='VIR'){
				$facture_mode_paiement = $txt_facture_virement;
			}elseif($facture_mode_paiement=='ESP'){
				$facture_mode_paiement = $txt_facture_especes;
			}elseif($facture_mode_paiement=='CB'){
				$facture_mode_paiement = $txt_facture_carte_bancaire;
			}

			$this->Cell(135, 8, '', 0, 0, 'C', false);

			$this->SetFont('Arial', 'B', 10);
			$this->SetTextColor(0, 153, 0);
			$this->SetDrawColor(0, 153, 0);
			$this->SetFillColor(255, 255, 255);
			$this->MultiCell(45, 4, "\n".$txt_facture_facture_payee."\nPAR ".$facture_mode_paiement."\n\n", 1, 'C');

		}

	}


	// Pied de page
	function more_text(){

		global $input8, $input9, $input10;

		//$this->SetXY(0, -30);																	// Positionnement à 0 cm à gauche et à 1,5 cm du bas

		$this->SetFont('Arial', '', 10);
		$this->SetTextColor(25,25,25);
		//$this->Cell(210, 4, "\n", 0, 1, 'L', false);
		//$this->SetFont('Arial', '', 8);
		$this->Cell(190, 14, '',  0, 1, 'L', false);
	

		if($input8 != '') {$this->Cell(190, 6, $input8,  0, 1, 'L', false);}
		if($input9 != '') {$this->Cell(190, 6, $input9,  0, 1, 'L', false);}
		//if($input10 != '') {$this->Cell(190, 6, $input10,  0, 1, 'L', false);}
		//$this->SetFont('Arial','B',15);
		if($input10 != '') {$this->Multicell(190, 6, $input10);}
		

		//$this->WordWrap($input10,190);

	}




	// Pied de page
	function Footer(){

		global $txt_facture_tel;

		global $input11, $input12, $input13;

		$this->SetXY(0, -30);// Positionnement à 0 cm à gauche et à 1,5 cm du bas

		$this->SetFont('Arial', '', 10);
		$this->SetTextColor(25,25,25);
		$this->Cell(210, 4, "\n", 0, 1, 'C', false);
		$this->SetFont('Arial', '', 8);
		$this->Cell(190, 4, $input11, 0, 1, 'C', false);
		$this->Cell(190, 4, $input12, 0, 1, 'C', false);
		$this->Cell(190, 4, $input13, 0, 1, 'C', false);

		/*
		$this->Cell(190, 4, "Adresse juridique : 76 rue de la Pompe 75116 Paris".ESPACE.ESPACE."-".ESPACE.ESPACE."Adresse postale : Espace Gailleton 2 place Gailleton 69002 Lyon", 0, 1, 'C', false);
		$this->Cell(190, 4, $txt_facture_tel." : 04 81 88 45 64".ESPACE.ESPACE."-".ESPACE.ESPACE."www.golf-first.fr".ESPACE.ESPACE."-".ESPACE.ESPACE."www.proamcotedopale.com".ESPACE.ESPACE."-".ESPACE.ESPACE."proam@golf-first.fr", 0, 1, 'C', false);
		$this->Cell(190, 4, "SARL au capital de 7 622 ".EURO.ESPACE.ESPACE."-".ESPACE.ESPACE." 343 042 107 RCS PARIS", 0, 1, 'C');*/

		$this->Cell(190, 4, 'Page '.$this->PageNo().' / {nb}', 0, 1, 'R', false);					// Numéro de page

	}


}

/**************************************************************************************************************************************/

// Instanciation de la classe dérivée
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->TitreClient($facture_numero, $facture_date, $joueur_nom, $joueur_coordonnees, $txt_facture_date_le, $txt_facture_facture);
$pdf->Tableau($produits, $facture_tva_appliquee, $facture_prix_ht, $facture_prix_tva, $facture_prix_ttc, $facture_tva_pourcentage, $pays_code, $txt_facture_libelle, $txt_facture_montant_euro_ht_1, $txt_facture_montant_euro_ht_2, $txt_facture_montant, $txt_facture_tva, $txt_facture_montant_total_ht, $txt_facture_montant_total_ttc, $libelle_forfait, $libelle_option, $libelle_heb, $prix_forfait, $prix_option, $prix_heb);
$pdf->Virement($joueur_langue, $txt_facture_tva_intracommunautaire, $txt_facture_virement, $txt_facture_code_iban, $txt_facture_code_bic);

if($facture_prix_ttc!='0,00'){
	$pdf->Paiement($facture_payee, $facture_mode_paiement, $txt_facture_cheque, $txt_facture_virement, $txt_facture_especes, $txt_facture_carte_bancaire, $txt_facture_facture_payee);
}

$pdf->more_text();


if(isset($fichier) AND $fichier==1){
	$pdf->Output('../../../temp/'.$facture_id.'.pdf', 'F');
}else{
	$pdf->Output($txt_facture_facture.'_-'.$facture_numero.'.pdf', 'I');
}

?>