<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(5, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($facture_date))==0){
		$erreur_message .= "- la date est manquante<br>";
	}
	if(strlen(trim($facture_numero))==0){
		$erreur_message .= "- le numéro est manquant<br>";
	}
	if(strlen(trim($facture_package))==0){
		$erreur_message .= "- le package est manquant<br>";
	}
	if(isset($facture_payee) AND $facture_payee==1 AND $facture_mode_paiement=='-'){
		$erreur_message .= "- le mode de paiement est manquant<br>";
	}
	if($facture_destinataire=='-'){
		$erreur_message .= "- le destinataire est manquant<br>";
	}
	if($facture_package=='entreprise' OR strlen(trim($facture_entreprise_nom))!=0 OR strlen(trim($facture_entreprise_adresse_1))!=0 OR strlen(trim($facture_entreprise_code_postal))!=0 OR strlen(trim($facture_entreprise_ville))!=0 OR $facture_entreprise_pays!='-'){
		if(strlen(trim($facture_entreprise_nom))==0){
			$erreur_message .= "- le nom de l'entreprise est manquant<br>";
		}
		if(strlen(trim($facture_entreprise_adresse_1))==0){
			$erreur_message .= "- l'adresse de l'entreprise est manquante<br>";
		}
		if(strlen(trim($facture_entreprise_code_postal))==0){
			$erreur_message .= "- le code postal de l'entreprise est manquant<br>";
		}
		if(strlen(trim($facture_entreprise_ville))==0){
			$erreur_message .= "- la ville de l'entreprise est manquante<br>";
		}
		if($facture_entreprise_pays=='-'){
			$erreur_message .= "- le pays de l'entreprise est manquant<br>";
		}
	}

	/*
	if(strlen(trim($facture_libelle_description[0]))==0){
		$erreur_message .= "- la description du libellé n°1 est manquant<br>";
	}
	if(strlen(trim($facture_libelle_prix_unitaire_ht[0]))==0){
		$erreur_message .= "- le prix unitaire HT du libellé n°1 est manquant<br>";
	}
	if(strlen(trim($facture_libelle_quantite[0]))==0){
		$erreur_message .= "- la quantité du libellé n°1 est manquant<br>";
	}
	if(strlen(trim($facture_libelle_prix_total_ht[0]))==0){
		$erreur_message .= "- le prix total HT du libellé n°1 est manquant<br>";
	}
	if(strlen(trim($facture_prix_ht))==0){
		$erreur_message .= "- le montant total HT est manquant<br>";
	}
	if(strlen(trim($facture_prix_tva))==0){
		$erreur_message .= "- le montant de la TVA est manquante<br>";
	}
	if(strlen(trim($facture_prix_ttc))==0){
		$erreur_message .= "- le montant total TTC est manquant<br>";
	}*/

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$facture_entreprise_nom = htmlentities(strtoupper_max($facture_entreprise_nom), ENT_QUOTES);
	$facture_entreprise_adresse_1 = htmlentities(ucfirst($facture_entreprise_adresse_1), ENT_QUOTES);
	$facture_entreprise_adresse_2 = htmlentities(ucfirst($facture_entreprise_adresse_2), ENT_QUOTES);
	$facture_entreprise_code_postal = enregistrement_telephone($facture_entreprise_code_postal);
	$facture_entreprise_ville = htmlentities(strtoupper_max($facture_entreprise_ville), ENT_QUOTES);
	if($facture_tva_appliquee==0){ $facture_prix_tva = '0.00'; $facture_prix_ttc = $facture_prix_ht; }
	$facture_prix_ht = traitement_prix($facture_prix_ht);
	$facture_prix_tva = traitement_prix($facture_prix_tva);
	$facture_prix_ttc = traitement_prix($facture_prix_ttc);
	$facture_message_joueur = htmlentities(ucfirst($facture_message_joueur), ENT_QUOTES);
	$facture_notes = htmlentities(ucfirst($facture_notes), ENT_QUOTES);
	if(!isset($facture_payee)){ $facture_payee = 0; $facture_mode_paiement = ''; }

	$prix_forfait = traitement_prix($prix_forfait);
	$prix_option = traitement_prix($prix_option);
	$prix_heb = traitement_prix($prix_heb);

	$libelle_forfait = htmlentities(ucfirst($libelle_forfait), ENT_QUOTES);
	$libelle_option = htmlentities(ucfirst($libelle_option), ENT_QUOTES);
	$libelle_heb = htmlentities(ucfirst($libelle_heb), ENT_QUOTES);

	/*// Traitement des libellés de la facture
	foreach($facture_libelle_description as $facture_libelle_cle=>$facture_libelle_description_item){
		if(strlen(trim($facture_libelle_description_item))!=0){
			$facture_libelle_description[$facture_libelle_cle] = htmlentities(ucfirst($facture_libelle_description_item), ENT_QUOTES);
			$facture_libelle_prix_unitaire_ht[$facture_libelle_cle] = traitement_prix($facture_libelle_prix_unitaire_ht[$facture_libelle_cle]);
			$facture_libelle_prix_total_ht[$facture_libelle_cle] = traitement_prix($facture_libelle_prix_total_ht[$facture_libelle_cle]);
			$facture_prix_ttc = traitement_prix($facture_prix_ttc);
		}else{
			// Suppression des éléments du tableau
			unset($facture_libelle_description[$facture_libelle_cle], $facture_libelle_prix_unitaire_ht[$facture_libelle_cle], $facture_libelle_quantite[$facture_libelle_cle], $facture_libelle_prix_total_ht[$facture_libelle_cle]);
		}
	}*/

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){


		echo "FACTURE ID ";
		echo $facture_id;

		// Requête de mise à jour de la facture
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE factures SET joueur_id="'.$facture_destinataire.'", facture_numero="'.$facture_numero.'", facture_package="'.$facture_package.'", facture_entreprise_nom="'.$facture_entreprise_nom.'", facture_entreprise_adresse_1="'.$facture_entreprise_adresse_1.'", facture_entreprise_adresse_2="'.$facture_entreprise_adresse_2.'", facture_entreprise_code_postal="'.$facture_entreprise_code_postal.'", facture_entreprise_ville="'.$facture_entreprise_ville.'", facture_entreprise_pays="'.$facture_entreprise_pays.'", facture_tva_appliquee="'.$facture_tva_appliquee.'", facture_prix_ht="'.$facture_prix_ht.'", facture_prix_tva="'.$facture_prix_tva.'", facture_prix_ttc="'.$facture_prix_ttc.'", facture_message_joueur="'.$facture_message_joueur.'", facture_notes="'.$facture_notes.'", facture_date=STR_TO_DATE("'.$facture_date.'", "%d/%m/%Y"), facture_payee="'.$facture_payee.'", facture_mode_paiement="'.$facture_mode_paiement.'", prix_forfait="'.$prix_forfait.'", prix_option="'.$prix_option.'", prix_heb="'.$prix_heb.'" WHERE facture_id="'.$facture_id.'"');

			//echo "ICI\n";


			// check if line exist in factures_libelles

			$requete_update_libelles_0 = mysqli_query($connexion_mysql, 'SELECT * FROM factures_libelles WHERE facture_id="'.$facture_id.'"');

			if(mysqli_num_rows($requete_update_libelles_0) == 0) {

				//echo "ici ";


				$facture_libelle_id=uniqid();

				$requete_insertion_libelles = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_libelle_id, facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht, libelle_forfait, libelle_option, libelle_heb) VALUES("'.$facture_libelle_id.'", "'.$facture_id.'", "'.$facture_libelle_description_item.'", "'.$facture_libelle_prix_unitaire_ht[$facture_libelle_cle].'", "'.$facture_libelle_quantite[$facture_libelle_cle].'", "'.$facture_libelle_prix_total_ht[$facture_libelle_cle].'", "'.$libelle_forfait.'", "'.$libelle_option.'", "'.$libelle_heb.'")') or die(mysqli_error($connexion_mysql));

				//print_r(mysqli_num_rows($requete_insertion_libelles));


			} else {

				//echo " la ";

				// Requête d'insertion d'un libellé de facture
				$requete_update_libelles = mysqli_query($connexion_mysql, 'UPDATE factures_libelles SET facture_libelle_id="'.$facture_libelle_id.'", facture_id="'.$facture_id.'", facture_libelle_description="'.$facture_libelle_description_item.'", facture_libelle_prix_unitaire_ht="'.$facture_prix_ht.'", facture_libelle_quantite=1, facture_libelle_prix_total_ht="'.$facture_prix_ht.'", libelle_forfait="'.$libelle_forfait.'", libelle_option="'.$libelle_option.'", libelle_heb="'.$libelle_heb.'" WHERE facture_id="'.$facture_id.'"') or die(mysqli_error($connexion_mysql));

				//print_r(mysqli_num_rows($requete_update_libelles));

			}

		// Requête de suppression des libellés de facture
		//$requete_suppression_libelles = mysqli_query($connexion_mysql, 'DELETE FROM factures_libelles WHERE facture_id="'.$facture_id.'"');

/*		foreach($facture_libelle_description as $facture_libelle_cle=>$facture_libelle_description_item){
			$facture_libelle_id = uniqid();

			// Requête d'insertion d'un libellé de facture
			$requete_insertion_libelles = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_libelle_id, facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht) VALUES("'.$facture_libelle_id.'", "'.$facture_id.'", "'.$facture_libelle_description_item.'", "'.$facture_libelle_prix_unitaire_ht[$facture_libelle_cle].'", "'.$facture_libelle_quantite[$facture_libelle_cle].'", "'.$facture_libelle_prix_total_ht[$facture_libelle_cle].'")');

		}*/

		//header('Location: ./');
		//exit;

	}else{
		$facture_date = stripslashes($facture_date);
		if(strlen(trim($facture_date))!=0){ $facture_annee = substr($facture_date, -4); }else{ $facture_annee = '[année]'; }
		$facture_message_joueur = stripslashes($facture_message_joueur);
		$facture_notes = stripslashes($facture_notes);
		foreach($facture_libelle_description as $facture_libelle_cle=>$facture_libelle_description_item){
			$facture_libelle_description[$facture_libelle_cle] = stripslashes($facture_libelle_description[$facture_libelle_cle]);
			$facture_libelle_prix_unitaire_ht[$facture_libelle_cle] = stripslashes($facture_libelle_prix_unitaire_ht[$facture_libelle_cle]);
			$facture_libelle_prix_total_ht[$facture_libelle_cle] = stripslashes($facture_libelle_prix_total_ht[$facture_libelle_cle]);
		}
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Sélection de la facture
	$requete_facture = mysqli_query($connexion_mysql, 'SELECT joueur_id, facture_numero, facture_package, facture_entreprise_nom, facture_entreprise_adresse_1, facture_entreprise_adresse_2, facture_entreprise_code_postal, facture_entreprise_ville, facture_entreprise_pays, facture_tva_appliquee, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_message_joueur, facture_notes,  DATE_FORMAT(facture_date, "%d/%m/%Y"), facture_payee, facture_mode_paiement, prix_forfait, prix_option, prix_heb FROM factures WHERE facture_id="'.$facture_id.'"');
	$resultat_facture = mysqli_fetch_array($requete_facture);
	$facture_joueur = $resultat_facture[0];
	$facture_numero = $resultat_facture[1];
	$facture_package = $resultat_facture[2];

	$facture_entreprise_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[3])));
	$facture_entreprise_adresse_1 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[4])));
	$facture_entreprise_adresse_2 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[5])));
	$facture_entreprise_code_postal = $resultat_facture[6];
	$facture_entreprise_ville = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[7])));
	$facture_entreprise_pays = $resultat_facture[8];

	$facture_tva_appliquee = $resultat_facture[9];
	$facture_prix_ht = number_format($resultat_facture[10], 2, ',', ' ');
	$facture_prix_tva = number_format($resultat_facture[11], 2, ',', ' ');
	$facture_prix_ttc = number_format($resultat_facture[12], 2, ',', ' ');
	$facture_message_joueur = $resultat_facture[13];
	$facture_notes = $resultat_facture[14];
	$facture_date = $resultat_facture[15];
	$facture_payee = $resultat_facture[16];
	$facture_mode_paiement = $resultat_facture[17];

	$prix_forfait = $resultat_facture[18];
	$prix_option = $resultat_facture[19];
	$prix_heb = $resultat_facture[20];


	$facture_destinataire = $facture_joueur;
	$facture_annee = substr($facture_date, -4);
	while(strlen(trim($facture_numero)) < 3){ $facture_numero = '0'.$facture_numero; }

	// Sélection des libellés de la facture
	$requete_facture_libelles = mysqli_query($connexion_mysql, 'SELECT facture_libelle_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht, libelle_forfait, libelle_option, libelle_heb FROM factures_libelles WHERE facture_id="'.$facture_id.'"');
	$nb_facture_libelles = mysqli_num_rows($requete_facture_libelles);

	$resultat_facture_libelle = mysqli_fetch_array($requete_facture_libelles);


	$facture_libelle_id = $resultat_facture_libelle[0];

	$libelle_forfait = $resultat_facture_libelle[5];
	$libelle_option = $resultat_facture_libelle[6];
	$libelle_heb = $resultat_facture_libelle[7];



}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototype.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/scriptaculous.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>scriptaculous/prototip.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery-ui-personalized-1.6rc6.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
	<script language="Javascript">
		function bascule_tva(){
			if(document.getElementById('facture_tva_appliquee_oui').checked==true){
				document.getElementById('calque_montants_tva').style.display = 'block';
			}else{
				document.getElementById('calque_montants_tva').style.display = 'none';
			}
		}
	</script>
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Facturation</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">
				<input type="hidden" name="facture_id" value="<?=$facture_id?>">
				<input type="hidden" name="facture_joueur" value="<?=$facture_joueur?>">

				<div id="formulaire_ligne_intertitre">FACTURE</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date</div>
					<div id="formulaire_champ" style="width: 195px;"><input type="text" name="facture_date" value="<?=$facture_date?>" class="input" style="width: 80px;"></div>
					<div id="formulaire_libelle" style="width: 90px;">Package</div>
					<div id="formulaire_champ" style="width: 195px;">
						<select id="facture_package_selection" name="facture_package" size="1" class="select">
							<option value="" <?php if($facture_package==''){ echo 'selected'; } ?>>-</option>
							<option value="golfeur" <?php if($facture_package=='golfeur'){ echo 'selected'; } ?>>Golfeur</option>
							<option value="entreprise" <?php if($facture_package=='entreprise'){ echo 'selected'; } ?>>Entreprise</option>
							<option value="accompagnateur" <?php if($facture_package=='accompagnateur'){ echo 'selected'; } ?>>Accompagnateur</option>
						</select>
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Numéro</div>
					<div id="formulaire_champ" style="width: 195px;">PAB - <?=$facture_annee?> - <input type="text" name="facture_numero" value="<?=$facture_numero?>" class="input" style="width: 85px;"></div>
					<div id="formulaire_libelle" style="width: 90px;">Avec TVA</div>
					<div id="formulaire_champ" style="width: 195px;">
						<input type="radio" id="facture_tva_appliquee_oui" name="facture_tva_appliquee" value="1" <?php if($facture_tva_appliquee==1){ echo 'checked'; } ?> onclick="bascule_tva();">&nbsp; <label for="facture_tva_appliquee_oui">Oui</label>&nbsp;&nbsp;&nbsp;&nbsp; 
						<input type="radio" id="facture_tva_appliquee_non" name="facture_tva_appliquee" value="0" <?php if($facture_tva_appliquee==0){ echo 'checked'; } ?> onclick="bascule_tva();">&nbsp; <label for="facture_tva_appliquee_non">Non</label>
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Paiement</div>
					<div id="formulaire_champ" style="width: 195px;"><input type="checkbox" id="facture_payee_selection" name="facture_payee" value="1" <?php if($facture_payee==1){ echo 'checked'; } ?>>&nbsp; <label for="facture_payee_selection">Facture payée</label></div>
					<div id="formulaire_libelle" style="width: 90px;">Mode</div>
					<div id="formulaire_champ" style="width: 195px;">
						<select name="facture_mode_paiement" size="1" class="select" style="min-width: 180px;">
							<option value="-"<?php if($facture_payee==0){ echo ' selected'; } ?>>-</option>
							<option value="CHQ"<?php if($facture_payee==1 AND $facture_mode_paiement=='CHQ'){ echo ' selected'; } ?>>Chèque</option>
							<option value="VIR"<?php if($facture_payee==1 AND $facture_mode_paiement=='VIR'){ echo ' selected'; } ?>>Virement</option>
							<option value="ESP"<?php if($facture_payee==1 AND $facture_mode_paiement=='ESP'){ echo ' selected'; } ?>>Espèces</option>
							<option value="CB"<?php if($facture_payee==1 AND $facture_mode_paiement=='CB'){ echo ' selected'; } ?>>Carte bancaire</option>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_separateur"></div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Destinataire</div>
					<div id="formulaire_champ" style="width: 500px;">
						<select name="facture_destinataire" size="1" class="select" style="min-width: 300px;">
							<option value="-">-</option>
							<?php 
							// Sélection de l'ID de l'équipe
							$requete_facture_joueur_equipe = mysqli_query($connexion_mysql, 'SELECT ej_equipe FROM equipes_joueurs WHERE ej_joueur="'.$facture_joueur.'"');
							$resultat_facture_joueur_equipe = mysqli_fetch_array($requete_facture_joueur_equipe);
							$facture_joueur_equipe_id = $resultat_facture_joueur_equipe[0];

							// Sélection des joueurs de l'équipe
							$requete_facture_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$facture_joueur_equipe_id.'") ORDER BY joueur_nom, joueur_prenom');
							$nb_facture_joueurs = mysqli_num_rows($requete_facture_joueurs);
							if($nb_facture_joueurs!=0){
								for($facture_joueur_boucle=0; $facture_joueur_boucle<$nb_facture_joueurs; $facture_joueur_boucle++){
									$resultat_facture_joueur = mysqli_fetch_array($requete_facture_joueurs);
									$facture_joueur_id = $resultat_facture_joueur[0];
									$facture_joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture_joueur[1])));
									$facture_joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture_joueur[2])));

									if($facture_joueur_id==$facture_destinataire){ $facture_joueur_selection = ' selected'; }else{ $facture_joueur_selection = ''; }

									echo '<option value="'.$facture_joueur_id.'"'.$facture_joueur_selection.'>'.$facture_joueur_nom.' '.$facture_joueur_prenom.'</option>'."\n";
								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_separateur"></div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Société</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="facture_entreprise_nom" value="<?=$facture_entreprise_nom?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Adresse</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="facture_entreprise_adresse_1" value="<?=$facture_entreprise_adresse_1?>" class="input" style="width: 470px; margin-bottom: 5px;"><br>
						<input type="text" name="facture_entreprise_adresse_2" value="<?=$facture_entreprise_adresse_2?>" class="input" style="width: 470px;">
					</div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Code postal</div>
					<div id="formulaire_champ" style="width: 195px;"><input type="text" name="facture_entreprise_code_postal" value="<?=$facture_entreprise_code_postal?>" class="input" style="width: 164px;"></div>
					<div id="formulaire_libelle" style="width: 90px;">Ville</div>
					<div id="formulaire_champ" style="width: 195px;"><input type="text" name="facture_entreprise_ville" value="<?=$facture_entreprise_ville?>" class="input" style="width: 164px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Pays</div>
					<div id="formulaire_champ" style="width: 500px;">
						<select name="facture_entreprise_pays" size="1" class="select">
							<option value="-">-</option>
							<?php 
							// Sélection des pays
							$requete_pays = mysqli_query($connexion_mysql, 'SELECT pays_code, pays_libelle_FR FROM pays ORDER BY pays_libelle_FR');
							$nb_pays = mysqli_num_rows($requete_pays);
							if($nb_pays!=0){
								for($pays_boucle=0; $pays_boucle<$nb_pays; $pays_boucle++){
									$resultat_pays = mysqli_fetch_array($requete_pays);
									$pays_code = $resultat_pays[0];
									$pays_libelle = $resultat_pays[1];

									if($pays_code==$facture_entreprise_pays){ $pays_selection = ' selected'; }else{ $pays_selection = ''; }

									echo '<option value="'.$pays_code.'"'.$pays_selection.'>'.$pays_libelle.'</option>'."\n";

								}
							}
							?>
						</select>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">LIGNES / LIBELL&Eacute;S</div>


					<input type="text" name="facture_libelle_id" value="<?=$facture_libelle_id;?>" hidden>
			

					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Libelle forfait</div>
						<div id="formulaire_champ" style="width: 500px;"><textarea name="libelle_forfait" class="textarea" style="width: 470px; height: 90px; overflow: auto;"><?=$libelle_forfait;?></textarea></div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Unitaire HT</div>
						<div id="formulaire_champ" style="width: 100px;"><input type="text" name="prix_forfait" value="<?=$prix_forfait?>" class="input" style="width: 50px;">&nbsp;&nbsp; &euro;</div>
					
						<div id="formulaire_libelle_obligatoire" style="width: 90px;">Total HT</div>
						<div id="formulaire_champ" style="width: 100px;"><input type="text" name="prix_forfait" value="<?=$prix_forfait?>" class="input" style="width: 50px;">&nbsp;&nbsp; &euro;</div>
						<br clear="all">
					</div>


					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Libelle option</div>
						<div id="formulaire_champ" style="width: 500px;"><textarea name="libelle_option" class="textarea" style="width: 470px; height: 90px; overflow: auto;"><?=$libelle_option;?></textarea></div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Unitaire HT</div>
						<div id="formulaire_champ" style="width: 100px;"><input type="text" name="prix_option" value="<?=$prix_option?>" class="input" style="width: 50px;">&nbsp;&nbsp; &euro;</div>
					
						<div id="formulaire_libelle_obligatoire" style="width: 90px;">Total HT</div>
						<div id="formulaire_champ" style="width: 100px;"><input type="text" name="prix_option" value="<?=$prix_option?>" class="input" style="width: 50px;">&nbsp;&nbsp; &euro;</div>
						<br clear="all">
					</div>



					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Libelle hébergement</div>
						<div id="formulaire_champ" style="width: 500px;"><textarea name="libelle_heb" class="textarea" style="width: 470px; height: 90px; overflow: auto;"><?=$libelle_heb;?></textarea></div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Unitaire HT</div>
						<div id="formulaire_champ" style="width: 100px;"><input type="text" name="prix_heb" value="<?=$prix_heb?>" class="input" style="width: 50px;">&nbsp;&nbsp; &euro;</div>
					
						<div id="formulaire_libelle_obligatoire" style="width: 90px;">Total HT</div>
						<div id="formulaire_champ" style="width: 100px;"><input type="text" name="prix_heb" value="<?=$prix_heb?>" class="input" style="width: 50px;">&nbsp;&nbsp; &euro;</div>
						<br clear="all">
					</div>




				<div id="formulaire_ligne_intertitre">MONTANTS TOTAUX</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Total HT</div>
					<div id="formulaire_champ" style="width: 100px;"><input type="text" name="facture_prix_ht" value="<?=$facture_prix_ht?>" class="input" style="width: 60px;">&nbsp;&nbsp; &euro;</div>
					<div id="calque_montants_tva"<?php if($facture_tva_appliquee==0){ echo ' style="display: none;"'; } ?>>
						<div id="formulaire_libelle_obligatoire" style="width: 80px;">TVA 20%</div>
						<div id="formulaire_champ" style="width: 100px;"><input type="text" name="facture_prix_tva" value="<?=$facture_prix_tva?>" class="input" style="width: 60px;">&nbsp;&nbsp; &euro;</div>
						<div id="formulaire_libelle_obligatoire" style="width: 80px;">Total TTC</div>
						<div id="formulaire_champ" style="width: 100px;"><input type="text" name="facture_prix_ttc" value="<?=$facture_prix_ttc?>" class="input" style="width: 60px;">&nbsp;&nbsp; &euro;</div>
					</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">INFORMATIONS</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Message<br>du joueur</div>
					<div id="formulaire_champ" style="width: 500px;"><textarea name="facture_message_joueur" class="textarea" style="width: 470px; height: 100px; overflow: auto;"><?=$facture_message_joueur?></textarea></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Notes<br>Golf First</div>
					<div id="formulaire_champ" style="width: 500px;"><textarea name="facture_notes" class="textarea" style="width: 470px; height: 100px; overflow: auto;"><?=$facture_notes?></textarea></div>
					<br clear="all">
				</div>



				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.modifier.facture_date.focus();
	//-->
</script>

</body>
</html>
