<?php 
require_once '../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND in_array(7, $_SESSION['SessionADMIN_compte_acces_modules'])==false){
	header('Location: ../../');
	exit;
}


// Sélection de la dernière compétition enregistrée
$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_id, competition_date_debut, competition_heure_debut, competition_intervalle_departs FROM competitions ORDER BY competition_annee DESC LIMIT 1');
$resultat_competition = mysqli_fetch_array($requete_competition);
$competition_id = $resultat_competition[0];
$competition_date_debut = $resultat_competition[1];
$competition_heure_debut = $resultat_competition[2];
$competition_intervalle_departs = $resultat_competition[3];

$tab_competition_heure_debut = explode(':', $competition_heure_debut);

// Sélection du planning de la dernière compétition
$requete_planning = mysqli_query($connexion_mysql, 'SELECT planning_id, planning_groupe, golf_id, equipe_id, planning_depart_date FROM planning WHERE competition_id="'.$competition_id.'"');
$nb_planning = mysqli_num_rows($requete_planning);

// Sélection des groupes
$requete_groupes = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_groupe) FROM planning WHERE competition_id="'.$competition_id.'"');
$nb_groupes = mysqli_num_rows($requete_groupes);

/**********************************************************************************************************/

for($groupe_boucle=0; $groupe_boucle<$nb_groupes; $groupe_boucle++){
	$resultat_groupe = mysqli_fetch_array($requete_groupes);
	$groupe_lettre = $resultat_groupe[0];

	// Sélection des dates
	$requete_dates = mysqli_query($connexion_mysql, 'SELECT DISTINCT(planning_depart_date) FROM planning WHERE competition_id="'.$competition_id.'" AND planning_groupe="'.$groupe_lettre.'"');
	$nb_dates = mysqli_num_rows($requete_dates);

	for($date_boucle=0; $date_boucle<$nb_groupes; $date_boucle++){
		$resultat_date = mysqli_fetch_array($requete_dates);
		$planning_date = $resultat_date[0];

		// Initialisations
		$tab_equipes[$groupe_lettre][$planning_date] = array();

		// Sélection des équipes suivants le groupe et la date
		$requete_equipes = mysqli_query($connexion_mysql, 'SELECT planning_id, equipe_id FROM planning WHERE competition_id="'.$competition_id.'" AND planning_groupe="'.$groupe_lettre.'" AND planning_depart_date="'.$planning_date.'"');
		$nb_equipes = mysqli_num_rows($requete_equipes);

		for($equipe_boucle=0; $equipe_boucle<$nb_equipes; $equipe_boucle++){
			$resultat_equipe = mysqli_fetch_array($requete_equipes);
			$planning_id = $resultat_equipe[0];
			$equipe_id = $resultat_equipe[1];

			$tab = array($planning_id, $equipe_id);

			array_push($tab_equipes[$groupe_lettre][$planning_date], $tab);

		}

		/*
		echo '<pre>';

		print_r($tab_equipes[$groupe_lettre][$planning_date]);

		echo '<br><hr><br>';
		*/

		shuffle($tab_equipes[$groupe_lettre][$planning_date]);

		// print_r($tab_equipes[$groupe_lettre][$planning_date]);

		$depart_heures = $tab_competition_heure_debut[0];
		$depart_minutes = $tab_competition_heure_debut[1];

		foreach($tab_equipes[$groupe_lettre][$planning_date] as $tab){

			// echo $tab[0]."\t".$tab[1]."\t".$depart_heures.':'.$depart_minutes."\n";

			// Requête de mise à jour
			$requete_maj = mysqli_query($connexion_mysql, 'UPDATE planning SET planning_depart_heure="'.$depart_heures.':'.$depart_minutes.'" WHERE planning_id='.$tab[0]);

			if($depart_minutes>=50){
				$depart_heures++;
				$depart_minutes = '00';

				if($depart_heures=='10' AND ($depart_minutes=='00' OR $depart_minutes=='10')){ $depart_minutes = '20'; }
				if(strlen($depart_heures)==1){ $depart_heures = '0'.$depart_heures; }
			}else{
				$depart_minutes = $depart_minutes + $competition_intervalle_departs;
			}

		}

		/*
		echo '<br><hr><hr>';
		echo '</pre>';
		*/

	}

}

/**********************************************************************************************************/

header('Location: ./');
exit;

?>
