<?php 
include '../lib/configuration.inc';

if(!isset($_SESSION['SessionWeb_joueur_id'])){
	header('Location: ./compte_deconnexion.php');
	exit;
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_espace_equipe_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php $espace='equipe'; include './commun/entete.inc'; ?>

		<div id="contenu_bis">

			<div id="menu">

				<?php include './commun/menu.inc'; ?>

			</div>

			<div id="formulaire_bis">

				<h1><?=$txt_espace_equipe_factures_titre?></h1>

				<div class="separateur"></div>

				<?php 
				// Sélection des factures du joueur
				$requete_factures = mysqli_query($connexion_mysql, 'SELECT facture_id, facture_numero, facture_package, facture_entreprise_nom, facture_entreprise_adresse_1, facture_entreprise_adresse_2, facture_entreprise_code_postal, facture_entreprise_ville, (SELECT pays_libelle_FR FROM pays WHERE pays_code=facture_entreprise_pays), facture_prix_ht, facture_prix_tva, facture_prix_ttc, DATE_FORMAT(facture_date, "%d/%m/%Y"), facture_payee, facture_mode_paiement FROM factures WHERE joueur_id="'.$_SESSION['SessionWeb_joueur_id'].'"');
				$nb_factures = mysqli_num_rows($requete_factures);
				if($nb_factures!=0){
					for($facture_boucle=0; $facture_boucle<$nb_factures; $facture_boucle++){
						$resultat_facture = mysqli_fetch_array($requete_factures);
						$facture_id = $resultat_facture[0];
						$facture_numero = $resultat_facture[1];
						$facture_package = ucfirst($resultat_facture[2]);
						$facture_entreprise_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[3])));
						$facture_entreprise_adresse_1 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[4])));
						$facture_entreprise_adresse_2 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[5])));
						$facture_entreprise_code_postal = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[6])));
						$facture_entreprise_ville = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[7])));
						$facture_entreprise_pays = decodage_apostrophe(html_entity_decode(stripslashes($resultat_facture[8])));
						$facture_prix_ht = number_format($resultat_facture[9], 2, $txt_montant_separateur, $txt_montant_millier);
						$facture_prix_tva = number_format($resultat_facture[10], 2, $txt_montant_separateur, $txt_montant_millier);
						$facture_prix_ttc = number_format($resultat_facture[11], 2, $txt_montant_separateur, $txt_montant_millier);
						$facture_date = $resultat_facture[12];
						$facture_payee = $resultat_facture[13];
						$facture_mode_paiement = $resultat_facture[14];

						while(strlen(trim($facture_numero)) < 3){ $facture_numero = '0'.$facture_numero; }
						if($facture_payee==1){
							$facture_statut = '<span style="color: green; font-weight: bold;">PAYÉE</span>';
							if($facture_mode_paiement=='VIR'){
								$facture_statut_mode = '<span style="color: green; font-weight: bold;">'.$txt_espace_equipe_factures_paiement_virement.'</span>';
							}elseif($facture_mode_paiement=='CHQ'){
								$facture_statut_mode = '<span style="color: green; font-weight: bold;">'.$txt_espace_equipe_factures_paiement_cheque.'</span>';
							}elseif($facture_mode_paiement=='CB'){
								$facture_statut_mode = '<span style="color: green; font-weight: bold;">'.$txt_espace_equipe_factures_paiement_cb.'</span>';
							}else{
								$facture_statut_mode = '<span style="color: green; font-weight: bold;">'.$txt_espace_equipe_factures_paiement_especes.'</span>';
							}
						}else{
							$facture_statut = '<span style="color: red; font-weight: bold;">'.$txt_espace_equipe_factures_impaye.'</span>';
						}
				?>

						<div style="float: left; width: 400px;">

							<div class="colonne_gauche_obligatoire" style="width: 120px; height: 25px;"><?=$txt_espace_equipe_factures_facture?> n° :</div>
							<div class="colonne_droite" style="width: 200px; padding-top: 5px; height: 25px;">PAB - <?=substr($facture_date, -4)?> - <?=$facture_numero?></div>
							<br clear="all">

							<div class="colonne_gauche_obligatoire" style="width: 120px; height: 25px;">Date :</div>
							<div class="colonne_droite" style="width: 200px; padding-top: 5px; height: 25px;"><?=$facture_date?></div>
							<br clear="all">

							<div class="colonne_gauche_obligatoire" style="width: 120px; height: 25px;"><?=$txt_espace_equipe_factures_package?> :</div>
							<div class="colonne_droite" style="width: 200px; padding-top: 5px; height: 25px;"><?=$facture_package?></div>
							<br clear="all">

							<div class="colonne_gauche_obligatoire" style="width: 120px;"><?=$txt_espace_equipe_factures_destinataire?> :</div>
							<div class="colonne_droite" style="width: 280px; min-height: 80px; padding-top: 5px;">
								<?php 
								echo $facture_entreprise_nom.'<br>';
								echo $facture_entreprise_adresse_1.'<br>';
								if(strlen(trim($facture_entreprise_adresse_2))!=0){ echo $facture_entreprise_adresse_2.'<br>'; }
								echo $facture_entreprise_code_postal.' '.$facture_entreprise_ville.'<br>';
								echo $facture_entreprise_pays.'<br>';
								?>
							</div>
							<br clear="all">

							<div class="colonne_gauche_obligatoire" style="width: 120px;"><?=$txt_espace_equipe_factures_facture?> PDF :</div>
							<div class="colonne_droite" style="width: 200px; padding-top: 5px; height: 25px;"><a href="<?=$admin_domaine?>modules/joueurs_equipes/facturation/facture.php?facture_id=<?=$facture_id?>" target="_blank" style="color: #071E39;"><?=$txt_espace_equipe_factures_telechargez?></a></div>


						</div>
						<div style="float: left; width: 200px;">

							<div class="colonne_gauche_obligatoire" style="width: 60px; height: 25px;"><?=$txt_espace_equipe_factures_prix_ht?> :</div>
							<div class="colonne_droite" align="right" style="width: 100px; padding-top: 5px; height: 25px;"><?=$facture_prix_ht?> &euro;</div>
							<br clear="all">

							<div class="colonne_gauche_obligatoire" style="width: 60px; height: 25px;"><?=$txt_espace_equipe_factures_tva?> :</div>
							<div class="colonne_droite" align="right" style="width: 100px; padding-top: 5px; height: 25px;"><?=$facture_prix_tva?> &euro;</div>
							<br clear="all">

							<div class="colonne_gauche_obligatoire" style="width: 60px; height: 25px;"><?=$txt_espace_equipe_factures_prix_ttc?> :</div>
							<div class="colonne_droite" align="right" style="width: 100px; padding-top: 5px; height: 25px;"><b><?=$facture_prix_ttc?> &euro;</b></div>
							<br clear="all"><br>

							<div class="colonne_gauche_obligatoire" style="width: 100px; height: 20px;"><?=$txt_espace_equipe_factures_statut?> :</div>
							<div class="colonne_droite" style="width: 100px; padding-top: 5px; height: 20px;"><?=$facture_statut?></div>
							<div class="colonne_gauche_obligatoire" style="width: 100px; height: 20px;">&nbsp;</div>
							<div class="colonne_droite" style="width: 100px; padding-top: 0px; height: 20px;"><?php if($facture_payee==1){ echo $facture_statut_mode; } ?></div>
							<br clear="all">


					</div>
					<br clear="all">

				<?php 
					}

					echo '<div class="separateur"></div>'."\n";

				}else{

					echo $txt_espace_equipe_factures_aucune.'<br><br>';

					echo '<div class="separateur"></div>'."\n";

				}
				?>

			</div>
			<br clear="all">

		</div>

	</div>

</div>

</body>
</html>
