<?php 
include '../lib/configuration.inc';


// Si le nom du joueur pro n'est pas connu, alors retour à l'inscription
if(!isset($_SESSION['SessionWeb_joueur_pro_nom'])){
	header('Location: ./inscription_1.php');
	exit;
}


if(isset($autorisation) AND $autorisation=='facturation'){

	if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am'])!=0){
		if(!isset($joueur_package)){
			$formulaire_erreur[] = 'joueur_package';
		}elseif($joueur_package=='entreprise'){
			if($joueur_entreprise_representant=='0'){
				$formulaire_erreur[] = 'joueur_entreprise_representant';
			}
			if(strlen(trim($joueur_entreprise_nom))==0){
				$formulaire_erreur[] = 'joueur_entreprise_nom';
			}
			if(strlen(trim($joueur_entreprise_adresse_1))==0){
				$formulaire_erreur[] = 'joueur_entreprise_adresse_1';
			}
			if(strlen(trim($joueur_entreprise_code_postal))==0){
				$formulaire_erreur[] = 'joueur_entreprise_code_postal';
			}
			if(strlen(trim($joueur_entreprise_ville))==0){
				$formulaire_erreur[] = 'joueur_entreprise_ville';
			}
			if($joueur_entreprise_pays=='0'){
				$formulaire_erreur[] = 'joueur_entreprise_pays';
			}
		}
	}

	if(count($formulaire_erreur)==0){

		/*******************/
		/**  INSCRIPTION  **/
		/*******************/

		$equipe_id = uniqid();
		$equipe_nom = $_SESSION['SessionWeb_joueur_pro_nom'];
		if($_SESSION['SessionWeb_joueur_pro_handicap']==NULL){ $requete_pro_handicap = 'NULL'; }else{ $requete_pro_handicap = '"'.$_SESSION['SessionWeb_joueur_pro_handicap'].'"'; }

		// Création de l'équipe en base de données
		$requete_creation_equipe = mysqli_query($connexion_mysql, 'INSERT INTO equipes (equipe_id, competition_id, equipe_nom, equipe_motdepasse) VALUES("'.$equipe_id.'", "'.$_SESSION['SessionWeb_competition_id'].'", "'.$equipe_nom.'", "'.$_SESSION['SessionWeb_joueur_pro_motdepasse'].'")');


		$joueur_id = $joueur_pro_id = uniqid();
		$ej_id = uniqid();

		// Création du joueur pro en base de données
		$requete_creation_joueur_pro = mysqli_query($connexion_mysql, 'INSERT INTO joueurs (joueur_id, competition_id, joueur_profil, joueur_club, joueur_licence, joueur_handicap, joueur_membre_club_competition, joueur_sexe, joueur_nom, joueur_prenom, joueur_date_naissance, joueur_taille_polo, joueur_adresse_1, joueur_adresse_2, joueur_code_postal, joueur_ville, joueur_pays, joueur_email, joueur_mobile, joueur_telephone, joueur_langue, joueur_datetime_creation) VALUES("'.$joueur_id.'", "'.$_SESSION['SessionWeb_competition_id'].'", "'.$_SESSION['SessionWeb_joueur_profil'].'", "'.$_SESSION['SessionWeb_joueur_pro_club'].'", "'.$_SESSION['SessionWeb_joueur_pro_licence'].'", '.$requete_pro_handicap.', "'.$_SESSION['SessionWeb_joueur_pro_membre_club_competition'].'", "'.$_SESSION['SessionWeb_joueur_pro_sexe'].'", "'.$_SESSION['SessionWeb_joueur_pro_nom'].'", "'.$_SESSION['SessionWeb_joueur_pro_prenom'].'", STR_TO_DATE("'.$_SESSION['SessionWeb_joueur_pro_date_naissance'].'", "%d/%m/%Y"), "'.$_SESSION['SessionWeb_joueur_pro_taille_polo'].'", "'.$_SESSION['SessionWeb_joueur_pro_adresse_1'].'", "'.$_SESSION['SessionWeb_joueur_pro_adresse_2'].'", "'.$_SESSION['SessionWeb_joueur_pro_code_postal'].'", "'.$_SESSION['SessionWeb_joueur_pro_ville'].'", "'.$_SESSION['SessionWeb_joueur_pro_pays'].'", "'.$_SESSION['SessionWeb_joueur_pro_email'].'", "'.$_SESSION['SessionWeb_joueur_pro_mobile'].'", "'.$_SESSION['SessionWeb_joueur_pro_telephone'].'", "'.$_SESSION['SessionWeb_langue'].'", "'.date('Y-m-d H:i:s').'")');

		// Ajout du joueur professionnel dans l'équipe en base de données
		$requete_equipe_joueur_pro = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_id.'")');


		// Ajout des amateurs
		if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am'])!=0){
			foreach($_SESSION['SessionWeb_joueurs_am'] as $joueur_am_cle=>$joueur_am){

				$joueur_id = $_SESSION['SessionWeb_joueurs_am'][$joueur_am_cle]['id'] = uniqid();
				$ej_id = uniqid();
				if($joueur_am['handicap']==NULL){ $requete_am_handicap = 'NULL'; }else{ $requete_am_handicap = '"'.$joueur_am['handicap'].'"'; }

				// Création du joueur amateur en base de données
				$requete_creation_joueur_am = mysqli_query($connexion_mysql, 'INSERT INTO joueurs (joueur_id, competition_id, joueur_profil, joueur_club, joueur_licence, joueur_handicap, joueur_membre_club_competition, joueur_sexe, joueur_nom, joueur_prenom, joueur_date_naissance, joueur_taille_polo, joueur_adresse_1, joueur_adresse_2, joueur_code_postal, joueur_ville, joueur_pays, joueur_email, joueur_mobile, joueur_telephone, joueur_langue, joueur_datetime_creation) VALUES("'.$joueur_id.'", "'.$_SESSION['SessionWeb_competition_id'].'", "am", "'.$joueur_am['club'].'", "'.$joueur_am['licence'].'", '.$requete_am_handicap.', "'.$joueur_am['membre_club_competition'].'", "'.$joueur_am['sexe'].'", "'.$joueur_am['nom'].'", "'.$joueur_am['prenom'].'", STR_TO_DATE("'.$joueur_am['date_naissance'].'", "%d/%m/%Y"), "'.$joueur_am['taille_polo'].'", "'.$joueur_am['adresse_1'].'", "'.$joueur_am['adresse_2'].'", "'.$joueur_am['code_postal'].'", "'.$joueur_am['ville'].'", "'.$joueur_am['pays'].'", "'.$joueur_am['email'].'", "'.$joueur_am['mobile'].'", "'.$joueur_am['telephone'].'", "'.$_SESSION['SessionWeb_langue'].'", "'.date('Y-m-d H:i:s').'")');

				// Ajout des joueurs amateurs dans l'équipe en base de données
				$requete_equipe_joueur_am = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_id.'")');

			}
		}

		// Ajout des amateurs
		if(isset($_SESSION['SessionWeb_joueurs_am_temp']) AND count($_SESSION['SessionWeb_joueurs_am_temp'])!=0){
			foreach($_SESSION['SessionWeb_joueurs_am_temp'] as $joueur_am_inscrit_cle=>$joueur_am_inscrit){

				// Récupération de l'ID de l'équipe temporaire
				$requete_equipe_temp = mysqli_query($connexion_mysql, 'SELECT ej_equipe FROM equipes_joueurs WHERE ej_joueur="'.$joueur_am_inscrit['id'].'"');
				$resultat_equipe_temp = mysqli_fetch_array($requete_equipe_temp);
				$equipe_temp_id = $resultat_equipe_temp[0];

				// Suppression du rattachement du joueur amateur à son équipe temporaire, celle-ci devient vide
				$requete_equipe_temp_am = mysqli_query($connexion_mysql, 'DELETE FROM equipes WHERE equipe_id="'.$equipe_temp_id.'"');

				// Suppression du rattachement du joueur amateur à son équipe temporaire, celle-ci devient vide
				$requete_equipe_temp_am = mysqli_query($connexion_mysql, 'DELETE FROM equipes_joueurs WHERE ej_equipe="'.$equipe_temp_id.'"');


				$ej_id = $_SESSION['SessionWeb_joueurs_am_temp'][$joueur_am_inscrit_cle]['id'] = uniqid();

				// Ajout des joueurs amateurs dans l'équipe en base de données
				$requete_equipe_joueur_am = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_am_inscrit['id'].'")');

			}
		}

		// Ajout des accompagnateurs
		if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0){
			foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc){

				$joueur_id = uniqid();
				$ej_id = uniqid();

				// Création de l'accompagnateur en base de données
				$requete_creation_joueur_acc = mysqli_query($connexion_mysql, 'INSERT INTO joueurs (joueur_id, competition_id, joueur_profil, joueur_sexe, joueur_nom, joueur_prenom, joueur_langue, joueur_datetime_creation) VALUES("'.$joueur_id.'", "'.$_SESSION['SessionWeb_competition_id'].'", "acc", "'.$joueur_acc['sexe'].'", "'.$joueur_acc['nom'].'", "'.$joueur_acc['prenom'].'", "'.$_SESSION['SessionWeb_langue'].'", "'.date('Y-m-d H:i:s').'")');

				// Ajout des joueurs amateurs dans l'équipe en base de données
				$requete_equipe_joueur_acc = mysqli_query($connexion_mysql, 'INSERT INTO equipes_joueurs (ej_id, ej_equipe, ej_joueur, ej_joueur_accompagnant) VALUES("'.$ej_id.'", "'.$equipe_id.'", "'.$joueur_id.'", "'.$joueur_pro_id.'")');

			}
		}


		/*****************************************/
		/**  ENVOI DE L'E-MAIL DE CONFIRMATION  **/
		/*****************************************/

		// Récupération des infos sur la compétition
		$requete_competition = mysqli_query($connexion_mysql, 'SELECT competition_annee, DATE_FORMAT(competition_date_debut, "%d/%m/%Y"), DATE_FORMAT(competition_date_fin, "%d/%m/%Y") FROM competitions WHERE competition_id="'.$_SESSION['SessionWeb_competition_id'].'"');
		$resultat_competition = mysqli_fetch_array($requete_competition);
		$competition_annee = $resultat_competition[0];
		$competition_date_debut = $resultat_competition[1];
		$competition_date_fin = $resultat_competition[2];

		// Construction de l'e-mail de confirmation d'inscription au client
		$emailing_sujet = $txt_pro_etape6_email_sujet.' '.$competition_annee;
		$emailing_titre = $txt_pro_etape6_email_titre;

		if($_SESSION['SessionWeb_joueur_pro_sexe']=='H'){ $txt_pro_etape6_email_1_message_civilite = $txt_monsieur; }else{ $txt_pro_etape6_email_1_message_civilite = $txt_madame; }

		$emailing_pro_message  = $txt_pro_etape6_email_1_message_1." ".$txt_pro_etape6_email_1_message_civilite." ".$_SESSION['SessionWeb_joueur_pro_nom'].",<br><br>\n";
		$emailing_pro_message .= $txt_pro_etape6_email_1_message_2." ".$competition_date_debut." ".$txt_pro_etape6_email_1_message_3." ".$competition_date_fin.".<br><br>\n";
		$emailing_pro_message .= $txt_pro_etape6_email_1_message_4."<br><br><br>\n";

		// Envoi de l'e-mail de confirmation d'inscription au joueur pro
		emailing_envoi($web_email_alerte, $_SESSION['SessionWeb_joueur_pro_email'], "laetitia@makilas-golftour.com", '', $emailing_sujet, $emailing_titre, $emailing_pro_message, $web_url.'/emailing.htm', $web_url, $_SESSION['SessionWeb_langue']);

		// S'il y a des joueurs amateurs, alors on leur envoie un e-mail
		if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am']!=0)){
			foreach($_SESSION['SessionWeb_joueurs_am'] as $joueur_am){

				if($joueur_am['sexe']=='H'){ $txt_pro_etape6_email_2_message_civilite = $txt_monsieur; }else{ $txt_pro_etape6_email_2_message_civilite = $txt_madame; }

				$emailing_am_message  = $txt_pro_etape6_email_2_message_1." ".$txt_pro_etape6_email_2_message_civilite." ".$joueur_am['nom'].",<br><br>\n";
				$emailing_am_message .= $txt_pro_etape6_email_2_message_2." ".$_SESSION['SessionWeb_joueur_pro_prenom']." ".$_SESSION['SessionWeb_joueur_pro_nom'].$txt_pro_etape6_email_2_message_3." ".$competition_date_debut." ".$txt_pro_etape6_email_2_message_4." ".$competition_date_fin.".<br><br>\n";
				$emailing_am_message .= $txt_pro_etape6_email_2_message_5."<br><br><br>\n";

				// Envoi de l'e-mail de confirmation d'inscription
				emailing_envoi($web_email_alerte, $joueur_am['email'], '', '', $emailing_sujet, $emailing_titre, $emailing_am_message, $web_url.'/emailing.htm', $web_url, $_SESSION['SessionWeb_langue']);

			}
		}


		/********************/
		/**  EMAIL ALERTE  **/
		/********************/

		$alerte_titre  = 'NOUVEAUX INSCRITS AU PRO-AM BIARRITZ '.$competition_annee.'<br><br>';
		if(isset($joueur_package) AND strlen(trim($joueur_package))!=0){
			$alerte_titre .= 'PACKAGE '.strtoupper($joueur_package);
		}

		$alerte_message = '<br><b><u>PROFESSIONNEL</u> :</b><br><br>';
		if($_SESSION['SessionWeb_joueur_pro_sexe']=='H'){ $professionnel_civilite = 'M.'; }else{ $professionnel_civilite = 'Mme'; }
		$alerte_message .= $professionnel_civilite.' '.$_SESSION['SessionWeb_joueur_pro_nom'].' '.$_SESSION['SessionWeb_joueur_pro_prenom'].'<br><br>';

		if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am']!=0)){
			$alerte_message .= '<br><b><u>AMATEUR(S)</u> :</b><br><br>';
			foreach($_SESSION['SessionWeb_joueurs_am'] as $joueur_am_cle=>$joueur_am){
				if($joueur_am['sexe']=='H'){ $amateur_civilite = 'M.'; }else{ $amateur_civilite = 'Mme'; }
				$alerte_message .= $amateur_civilite.' '.$joueur_am['nom'].' '.$joueur_am['prenom'].'<br><br>';
			}
		}

		if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc']!=0)){
			$alerte_message .= '<br><b><u>ACCOMPAGNATEUR(S)</u> :</b><br><br>';
			foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc_cle=>$joueur_acc){
				if($joueur_acc['sexe']=='H'){ $accompagnateur_civilite = 'M.'; }else{ $accompagnateur_civilite = 'Mme'; }
				$alerte_message .= $accompagnateur_civilite.' '.$joueur_acc['nom'].' '.$joueur_acc['prenom'].'<br><br>';
			}
		}

		if(strlen(trim($facture_message_joueur))!=0){
			$facture_message_joueur_bis = preg_replace('/\n/', '<br>', $facture_message_joueur);
			$alerte_message .= '<br><hr><br><br>';
			$alerte_message .= '<b><u>MESSAGE POUR L\'INSCRIPTION / FACTURATION</u> :</b><br><br>';
			$alerte_message .= stripslashes($facture_message_joueur_bis).'<br><br>';
		}

		// Envoi de l'e-mail d'alerte
		emailing_envoi($web_email_alerte, $web_email_alerte, '', '', '[ alerte ] Nouveaux inscrits au Pro-Am Biarritz '.$competition_annee, $alerte_titre, $alerte_message, $web_url.'/emailing_alerte.htm', $web_url, $_SESSION['SessionWeb_langue']);


		/****************************************/
		/**  ENREGISTREMENT DE LA FACTURATION  **/
		/****************************************/

		if($joueur_package=='entreprise'){
			if($joueur_entreprise_representant=='pro'){
				$joueur_entreprise_representant_id = $joueur_pro_id;
			}else{
				$joueur_entreprise_representant_tab = explode('_', $joueur_entreprise_representant);
				$joueur_entreprise_representant_cle = $joueur_entreprise_representant_tab[1];
				if($joueur_entreprise_representant_tab[0]=='am'){
					$joueur_entreprise_representant_id = $_SESSION['SessionWeb_joueurs_am'][$joueur_entreprise_representant_cle]['id'];
				}else{
					$joueur_entreprise_representant_id = $_SESSION['SessionWeb_joueurs_am_temp'][$joueur_entreprise_representant_cle]['id'];
				}
			}
			$joueur_entreprise_nom = htmlentities(strtoupper_max(stripslashes($joueur_entreprise_nom)), ENT_QUOTES);
			$joueur_entreprise_adresse_1 = htmlentities(ucfirst(stripslashes($joueur_entreprise_adresse_1)), ENT_QUOTES);
			$joueur_entreprise_adresse_2 = htmlentities(ucfirst(stripslashes($joueur_entreprise_adresse_2)), ENT_QUOTES);
			$joueur_entreprise_code_postal = htmlentities(ucfirst(stripslashes($joueur_entreprise_code_postal)), ENT_QUOTES);
			$joueur_entreprise_ville = htmlentities(strtoupper_max(stripslashes($joueur_entreprise_ville)), ENT_QUOTES);
			$joueur_entreprise_pays = $joueur_entreprise_pays;
		}
		$facture_message_joueur = htmlentities(ucfirst(stripslashes($facture_message_joueur)), ENT_QUOTES);

		if($joueur_package=='golfeur'){

			/****  AMATEUR(S)  ****/

			foreach($_SESSION['SessionWeb_joueurs_am'] as $joueur_am_cle=>$joueur_am){

				$facture_id = uniqid();

				// Création du numéro de facture
				$requete_facture_numero_max = mysqli_query($connexion_mysql, 'SELECT MAX(facture_numero) FROM factures');
				$resultat_facture_numero_max = mysqli_fetch_array($requete_facture_numero_max);
				$facture_numero = $resultat_facture_numero_max[0] + 1;

				if($joueur_am['membre_club_competition']==1){

					$facture_libelle_joueurs = $txt_pro_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_pro_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_pro_etape6_libelle_facture_3."\n".$joueur_am['nom'].' '.$joueur_am['prenom']."\n";

					$facture_prix_golfeur_ht = $facture_prix_golfeur_membre_ht;
					$facture_prix_golfeur_tva = $facture_prix_golfeur_membre_tva;
					$facture_prix_golfeur_ttc = $facture_prix_golfeur_membre_ttc;

				}else{

					$facture_libelle_joueurs = $txt_pro_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_pro_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_pro_etape6_libelle_facture_4."\n".$joueur_am['nom'].' '.$joueur_am['prenom']."\n";

					$facture_prix_golfeur_ht = $facture_prix_golfeur_pasmembre_ht;
					$facture_prix_golfeur_tva = $facture_prix_golfeur_pasmembre_tva;
					$facture_prix_golfeur_ttc = $facture_prix_golfeur_pasmembre_ttc;

				}

				if($joueur_am_cle!=0){ $facture_message_joueur = ''; }		// Le message doit être enregistré uniquement pour le joueur amateur qui créé l'inscription

				// Création du libellé de la facture en base de données
				$requete_creation_libelle = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_libelle_id, facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht) VALUES("'.uniqid().'", "'.$facture_id.'", "'.$facture_libelle_joueurs.'", "'.$facture_prix_golfeur_ht.'", "1", "'.$facture_prix_golfeur_ht.'")');

				// Création de la facture en base de données
				$requete_creation_facture = mysqli_query($connexion_mysql, 'INSERT INTO factures (facture_id, joueur_id, facture_numero, facture_package, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_message_joueur, facture_date) VALUES("'.$facture_id.'", "'.$joueur_am['id'].'", "'.$facture_numero.'", "'.$joueur_package.'", "'.$facture_prix_golfeur_ht.'", "'.$facture_prix_golfeur_tva.'", "'.$facture_prix_golfeur_ttc.'", "'.$facture_message_joueur.'", "'.date('Y-m-d').'")');

			}

			/****  ACCOMPAGNATEUR(S)  ****/

			if(count($_SESSION['SessionWeb_joueurs_acc'])!=0){

				$facture_id = uniqid();

				// Création du numéro de facture
				$requete_facture_numero_max = mysqli_query($connexion_mysql, 'SELECT MAX(facture_numero) FROM factures');
				$resultat_facture_numero_max = mysqli_fetch_array($requete_facture_numero_max);
				$facture_numero = $resultat_facture_numero_max[0] + 1;

				$facture_libelle_accompagnateurs = $txt_pro_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_pro_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_pro_etape6_libelle_facture_5;

				foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc){
					$facture_libelle_accompagnateurs .= "\n".$joueur_acc['nom']." ".$joueur_acc['prenom'];
				}

				// Calculs
				$facture_prix_accompagnateur_total_ht = $facture_prix_accompagnateur_ht * count($_SESSION['SessionWeb_joueurs_acc']);
				$facture_prix_accompagnateur_tva = ($facture_prix_accompagnateur_total_ht * $facture_tva) / 100;
				$facture_prix_accompagnateur_total_ttc = $facture_prix_accompagnateur_total_ht + $facture_prix_accompagnateur_tva;

				// Création du libellé de la facture en base de données
				$requete_creation_libelle = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_libelle_id, facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht) VALUES("'.uniqid().'", "'.$facture_id.'", "'.$facture_libelle_accompagnateurs.'", "'.$facture_prix_accompagnateur_ht.'", "'.count($_SESSION['SessionWeb_joueurs_acc']).'", "'.$facture_prix_accompagnateur_total_ht.'")');

				// Création de la facture en base de données
				$requete_creation_facture = mysqli_query($connexion_mysql, 'INSERT INTO factures (facture_id, joueur_id, facture_numero, facture_package, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_message_joueur, facture_date) VALUES("'.$facture_id.'", "'.$joueur_pro_id.'", "'.$facture_numero.'", "accompagnateur", "'.$facture_prix_accompagnateur_total_ht.'", "'.$facture_prix_accompagnateur_tva.'", "'.$facture_prix_accompagnateur_total_ttc.'", "'.$facture_message_joueur.'", "'.date('Y-m-d').'")');

			}

		}elseif($joueur_package=='entreprise'){

			$facture_id = uniqid();

			// Création du numéro de facture
			$requete_facture_numero_max = mysqli_query($connexion_mysql, 'SELECT MAX(facture_numero) FROM factures');
			$resultat_facture_numero_max = mysqli_fetch_array($requete_facture_numero_max);
			$facture_numero = $resultat_facture_numero_max[0] + 1;

			$facture_libelle = $txt_pro_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_pro_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_pro_etape6_libelle_facture_6;

			// Création du libellé pour le package Entreprise en base de données
			$requete_creation_libelle_4 = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_libelle_id, facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht) VALUES("'.uniqid().'", "'.$facture_id.'", "'.$facture_libelle.'", "'.$facture_prix_entreprise_ht.'", "1", "'.$facture_prix_entreprise_ht.'")');


			$facture_libelle_accompagnateurs = $txt_pro_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_pro_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_pro_etape6_libelle_facture_5;

			foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc){
				$facture_libelle_accompagnateurs .= "\n".$joueur_acc['nom']." ".$joueur_acc['prenom'];
			}

			// Calculs
			$facture_prix_accompagnateur_total_ht = $facture_prix_accompagnateur_ht * count($_SESSION['SessionWeb_joueurs_acc']);

			// Création du libellé de la facture en base de données
			$requete_creation_libelle = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_libelle_id, facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht) VALUES("'.uniqid().'", "'.$facture_id.'", "'.$facture_libelle_accompagnateurs.'", "'.$facture_prix_accompagnateur_ht.'", "'.count($_SESSION['SessionWeb_joueurs_acc']).'", "'.$facture_prix_accompagnateur_total_ht.'")');


			// Calculs pour la facture
			$facture_prix_total_ht = $facture_prix_entreprise_ht + $facture_prix_accompagnateur_total_ht;
			$facture_prix_tva = ($facture_prix_total_ht * $facture_tva) / 100;
			$facture_prix_total_ttc = $facture_prix_total_ht + $facture_prix_tva;

			// Création de la facture en base de données
			$requete_creation_facture = mysqli_query($connexion_mysql, 'INSERT INTO factures (facture_id, joueur_id, facture_numero, facture_package, facture_entreprise_nom, facture_entreprise_adresse_1, facture_entreprise_adresse_2, facture_entreprise_code_postal, facture_entreprise_ville, facture_entreprise_pays, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_message_joueur, facture_date) VALUES("'.$facture_id.'", "'.$joueur_entreprise_representant_id.'", "'.$facture_numero.'", "'.$joueur_package.'", "'.$joueur_entreprise_nom.'", "'.$joueur_entreprise_adresse_1.'", "'.$joueur_entreprise_adresse_2.'", "'.$joueur_entreprise_code_postal.'", "'.$joueur_entreprise_ville.'", "'.$joueur_entreprise_pays.'", "'.$facture_prix_total_ht.'", "'.$facture_prix_tva.'", "'.$facture_prix_total_ttc.'", "'.$facture_message_joueur.'", "'.date('Y-m-d').'")');

		// Pour accompagnateurs uniquement
		}elseif(count($_SESSION['SessionWeb_joueurs_acc'])!=0){

			$facture_id = uniqid();

			// Création du numéro de facture
			$requete_facture_numero_max = mysqli_query($connexion_mysql, 'SELECT MAX(facture_numero) FROM factures');
			$resultat_facture_numero_max = mysqli_fetch_array($requete_facture_numero_max);
			$facture_numero = $resultat_facture_numero_max[0] + 1;

			$facture_libelle_accompagnateurs = $txt_pro_etape6_libelle_facture_1." ".$competition_date_debut." ".$txt_pro_etape6_libelle_facture_2." ".$competition_date_fin."\n".$txt_pro_etape6_libelle_facture_5;

			foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc){
				$facture_libelle_accompagnateurs .= "\n".$joueur_acc['nom']." ".$joueur_acc['prenom'];
			}

			// Calculs
			$facture_prix_accompagnateur_total_ht = $facture_prix_accompagnateur_ht * count($_SESSION['SessionWeb_joueurs_acc']);
			$facture_prix_accompagnateur_tva = ($facture_prix_accompagnateur_total_ht * $facture_tva) / 100;
			$facture_prix_accompagnateur_total_ttc = $facture_prix_accompagnateur_total_ht + $facture_prix_accompagnateur_tva;

			// Création du libellé de la facture en base de données
			$requete_creation_libelle = mysqli_query($connexion_mysql, 'INSERT INTO factures_libelles (facture_libelle_id, facture_id, facture_libelle_description, facture_libelle_prix_unitaire_ht, facture_libelle_quantite, facture_libelle_prix_total_ht) VALUES("'.uniqid().'", "'.$facture_id.'", "'.$facture_libelle_accompagnateurs.'", "'.$facture_prix_accompagnateur_ht.'", "'.count($_SESSION['SessionWeb_joueurs_acc']).'", "'.$facture_prix_accompagnateur_total_ht.'")');

			// Création de la facture en base de données
			$requete_creation_facture = mysqli_query($connexion_mysql, 'INSERT INTO factures (facture_id, joueur_id, facture_numero, facture_package, facture_prix_ht, facture_prix_tva, facture_prix_ttc, facture_message_joueur, facture_date) VALUES("'.$facture_id.'", "'.$joueur_pro_id.'", "'.$facture_numero.'", "accompagnateur", "'.$facture_prix_accompagnateur_total_ht.'", "'.$facture_prix_accompagnateur_tva.'", "'.$facture_prix_accompagnateur_total_ttc.'", "'.$facture_message_joueur.'", "'.date('Y-m-d').'")');

		}


		/********************************************/
		/**  SUPPRESSION DES VARIABLES DE SESSION  **/
		/********************************************/

		// Suppression des variables de session de l'inscription du joueur pro
		unset($_SESSION['SessionWeb_joueur_profil'], $_SESSION['SessionWeb_joueur_pro_club'], $_SESSION['SessionWeb_joueur_pro_licence'], $_SESSION['SessionWeb_joueur_pro_handicap'], $_SESSION['SessionWeb_joueur_pro_membre_club_competition'], $_SESSION['SessionWeb_joueur_pro_sexe'], $_SESSION['SessionWeb_joueur_pro_nom'], $_SESSION['SessionWeb_joueur_pro_prenom'], $_SESSION['SessionWeb_joueur_pro_date_naissance'], $_SESSION['SessionWeb_joueur_pro_adresse_1'], $_SESSION['SessionWeb_joueur_pro_adresse_2'], $_SESSION['SessionWeb_joueur_pro_code_postal'], $_SESSION['SessionWeb_joueur_pro_ville'], $_SESSION['SessionWeb_joueur_pro_pays'], $_SESSION['SessionWeb_joueur_pro_email'], $_SESSION['SessionWeb_joueur_pro_mobile'], $_SESSION['SessionWeb_joueur_pro_telephone'], $_SESSION['SessionWeb_joueur_pro_motdepasse']);

		// Suppression des variables de session de l'inscription des autres joueurs
		unset($_SESSION['SessionWeb_joueurs_am_temp'], $_SESSION['SessionWeb_joueurs_am'], $_SESSION['SessionWeb_joueurs_acc']);


		header('Location: ./inscription_7.php');	// Redirection vers la page de confirmation
		exit;

	}else{
		// Traitement d'affichage en cas d'erreur dans le formulaire
		$joueur_entreprise_nom = stripslashes($joueur_entreprise_nom);
		$joueur_entreprise_adresse_1 = stripslashes($joueur_entreprise_adresse_1);
		$joueur_entreprise_adresse_2 = stripslashes($joueur_entreprise_adresse_2);
		$joueur_entreprise_code_postal = stripslashes($joueur_entreprise_code_postal);
		$joueur_entreprise_ville = stripslashes($joueur_entreprise_ville);
		$facture_message_joueur = stripslashes($facture_message_joueur);
	}

}


if(!isset($autorisation) OR (isset($autorisation) AND $autorisation!='facturation')){

	// Valeurs par défaut lorsque le formulaire est vierge
	$joueur_entreprise_representant = '0';
	$joueur_entreprise_nom = '';
	$joueur_entreprise_adresse_1 = '';
	$joueur_entreprise_adresse_2 = '';
	$joueur_entreprise_code_postale = '';
	$joueur_entreprise_ville = '';
	$joueur_entreprise_pays = 'FR';	$facture_message_joueur = '';

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_page_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
	<script language="Javascript">
		function change_package(package){
			if(document.getElementById('joueur_package_golfeur').checked==true){
				document.getElementById('calque_package_golfeur').className = 'inscription_radio_checked';
				document.getElementById('calque_package_entreprise').className = 'inscription_radio';

				document.getElementById('calque_package_golfeur_2').style.display = 'block';
				document.getElementById('calque_package_golfeur_3').style.display = 'none';

				document.getElementById('calque_package_golfeur_infos').style.display = 'block';
				document.getElementById('calque_package_entreprise_infos').style.display = 'none';
			}else if(document.getElementById('joueur_package_entreprise').checked==true){
				document.getElementById('calque_package_golfeur').className = 'inscription_radio';
				document.getElementById('calque_package_entreprise').className = 'inscription_radio_checked';

				document.getElementById('calque_package_golfeur_2').style.display = 'none';
				document.getElementById('calque_package_golfeur_3').style.display = 'block';

				document.getElementById('calque_package_golfeur_infos').style.display = 'none';
				document.getElementById('calque_package_entreprise_infos').style.display = 'block';
			}else{
				document.getElementById('calque_package_golfeur').className = 'inscription_radio';
				document.getElementById('calque_package_entreprise').className = 'inscription_radio';

				document.getElementById('calque_package_golfeur_2').style.display = 'none';
				document.getElementById('calque_package_golfeur_3').style.display = 'none';

				document.getElementById('calque_package_golfeur_infos').style.display = 'none';
				document.getElementById('calque_package_entreprise_infos').style.display = 'none';
			}
		}
	</script>
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php include './commun/entete.inc'; ?>

		<div id="formulaire">

			<form action="<?=$REQUEST_URI?>" method="post">

				<input type="hidden" name="autorisation" value="facturation">

				<?php if((isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am'])!=0) OR (isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0)){ ?>

					<h1><?=$txt_pro_etape6_titre?></h1>

					<div class="separateur"></div>

					<?php if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am'])!=0){ ?>

						<?=$txt_pro_etape6_selectionnez_pack?><?php if(count($formulaire_erreur)!=0 AND in_array('joueur_package', $formulaire_erreur)==true){ echo '<span class="erreur_bis">'.$txt_obligatoire.'</span>'; } ?><br>

						<label for="joueur_package_golfeur">
							<div id="calque_package_golfeur" align="center" class="inscription_radio" style="margin-left: 180px;">
								<b><?=$txt_pro_etape6_package?><br><img src="<?=$web_commun?>p.gif" width="1" height="5"><br><?=$txt_pro_etape6_golfeur?></b><br><br>
								<input id="joueur_package_golfeur" type="radio" name="joueur_package" value="golfeur" style="margin: 0px;" onclick="change_package()"<?php if(isset($joueur_package) AND $joueur_package=='golfeur'){ echo ' checked'; } ?>>
							</div>
						</label>
						<label for="joueur_package_entreprise">
							<div id="calque_package_entreprise" align="center" class="inscription_radio">
								<b><?=$txt_pro_etape6_package?><br><img src="<?=$web_commun?>p.gif" width="1" height="5"><br><?=$txt_pro_etape6_entreprise?></b><br><br>
								<input id="joueur_package_entreprise" type="radio" name="joueur_package" value="entreprise" style="margin: 0px;" onclick="change_package()"<?php if(isset($joueur_package) AND $joueur_package=='entreprise'){ echo ' checked'; } ?>>
							</div>
						</label>
						<br clear="all"><br><br>

						<div id="calque_package_golfeur_2"<?php if(!isset($joueur_package) OR (isset($joueur_package) AND $joueur_package!='golfeur')){ echo ' style="display: none;"'; } ?>>

							<div class="separateur_ter"></div>

							<div id="package_facture">

								<b><u><?=$txt_pro_etape6_soustitre_recapitulatif?></u></b><br><br>

								<table width="660" border="0" cellapdding="0" cellspacing="0">
									<tr>
										<td style="width: 320px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_description?></td>
										<td style="width: 120px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_prix_ht?></td>
										<td style="width: 100px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_tva?> (<?=$facture_tva?>%)</td>
										<td style="width: 120px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_prix_ttc?></td>
									</tr>

									<?php 
									foreach($_SESSION['SessionWeb_joueurs_am'] as $joueur_am){
										if($joueur_am['membre_club_competition']==1){
									?>
											<tr style="height: 30px;">
												<td>&nbsp;&nbsp;&nbsp;<?=$txt_pro_etape6_ligne_golfeur_membre?><br>&nbsp;&nbsp;&nbsp;<?=$joueur_am['nom'].' '.$joueur_am['prenom']?><br></td>
												<td align="right"><?=number_format($facture_prix_golfeur_membre_ht, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
												<td align="right"><?=number_format($facture_prix_golfeur_membre_tva, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
												<td align="right"><?=number_format($facture_prix_golfeur_membre_ttc, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
											</tr>
										<?php }else{ ?>
											<tr style="height: 30px;">
												<td>&nbsp;&nbsp;&nbsp;<?=$txt_pro_etape6_ligne_golfeur?><br>&nbsp;&nbsp;&nbsp;<?=$joueur_am['nom'].' '.$joueur_am['prenom']?><br></td>
												<td align="right"><?=number_format($facture_prix_golfeur_pasmembre_ht, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
												<td align="right"><?=number_format($facture_prix_golfeur_pasmembre_tva, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
												<td align="right"><?=number_format($facture_prix_golfeur_pasmembre_ttc, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
											</tr>
									<?php 
										}
									}

									if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0){
										foreach($_SESSION['SessionWeb_joueurs_acc'] as $joueur_acc){
									?>
											<tr style="height: 30px;">
												<td>&nbsp;&nbsp;&nbsp;<?=$txt_pro_etape6_ligne_accompagnateur?><br>&nbsp;&nbsp;&nbsp;<?=$joueur_acc['nom'].' '.$joueur_acc['prenom']?></td>
												<td align="right"><?=number_format($facture_prix_accompagnateur_ht, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
												<td align="right"><?=number_format($facture_prix_accompagnateur_tva, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
												<td align="right"><?=number_format($facture_prix_accompagnateur_ttc, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
											</tr>
									<?php 
										}
									}
									?>
								</table>
								<br>

							</div>

						</div>

						<div id="calque_package_golfeur_3"<?php if(!isset($joueur_package) OR (isset($joueur_package) AND $joueur_package!='entreprise')){ echo ' style="display: none;"'; } ?>>

							<div class="separateur_ter"></div>

							<div class="colonne_gauche_obligatoire" style="padding-top: 0px;"><?=$txt_pro_etape6_entreprise_joueur_representant?></div>
							<div class="colonne_droite">
								<select name="joueur_entreprise_representant" size="1" class="select">
									<option value="0"><?=$txt_selectionnez?></option>
									<?php 
									$joueur_pro_cle = 'pro';
									if(isset($joueur_entreprise_representant) AND 'pro'==$joueur_entreprise_representant){ $joueur_entreprise_joueur_selection = ' selected'; }else{ $joueur_entreprise_joueur_selection = ''; }
									echo '<option value="'.$joueur_pro_cle.'"'.$joueur_entreprise_joueur_selection.'>'.$_SESSION['SessionWeb_joueur_pro_nom'].' '.$_SESSION['SessionWeb_joueur_pro_prenom'].'</option>'."\n";
	
									// Sélection des joueurs amateurs déjà inscrits
									if(isset($_SESSION['SessionWeb_joueurs_am_temp']) AND count($_SESSION['SessionWeb_joueurs_am_temp'])!=0){
										foreach($_SESSION['SessionWeb_joueurs_am_temp'] as $joueur_amtemp_cle=>$joueur_amtemp){
											$joueur_amtemp_cle = 'amtemp_'.$joueur_am_cle;
											if($joueur_amtemp_cle==$joueur_entreprise_representant){ $joueur_entreprise_joueur_selection = ' selected'; }else{ $joueur_entreprise_joueur_selection = ''; }
											echo '<option value="'.$joueur_amtemp_cle.'"'.$joueur_entreprise_joueur_selection.'>'.$joueur_amtemp['nom'].' '.$joueur_amtemp['prenom'].'</option>'."\n";
										}
									}

									// Sélection des joueurs amateurs
									if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am'])!=0){
										foreach($_SESSION['SessionWeb_joueurs_am'] as $joueur_am_cle=>$joueur_am){
											$joueur_am_cle = 'am_'.$joueur_am_cle;
											if($joueur_am_cle==$joueur_entreprise_representant){ $joueur_entreprise_joueur_selection = ' selected'; }else{ $joueur_entreprise_joueur_selection = ''; }
											echo '<option value="'.$joueur_am_cle.'"'.$joueur_entreprise_joueur_selection.'>'.$joueur_am['nom'].' '.$joueur_am['prenom'].'</option>'."\n";
										}
									}
									?>
								</select>
							</div>
							<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_entreprise_representant', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
							<br clear="all">

							<div class="colonne_gauche_obligatoire"><?=$txt_pro_etape6_entreprise_nom?></div>
							<div class="colonne_droite"><input type="text" name="joueur_entreprise_nom" value="<?=$joueur_entreprise_nom?>"></div>
							<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_entreprise_nom', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
							<br clear="all">

							<div class="colonne_gauche_obligatoire"><?=$txt_pro_etape6_entreprise_adresse_postale?></div>
							<div class="colonne_droite"><input type="text" name="joueur_entreprise_adresse_1" value="<?=$joueur_entreprise_adresse_1?>"></div>
							<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_entreprise_adresse_1', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
							<br clear="all">

							<div class="colonne_gauche">&nbsp;</div>
							<div class="colonne_droite"><input type="text" name="joueur_entreprise_adresse_2" value="<?=$joueur_entreprise_adresse_2?>"></div>
							<br clear="all">

							<div class="colonne_gauche_obligatoire"><?=$txt_pro_etape6_entreprise_code_postal?></div>
							<div class="colonne_droite"><input type="text" name="joueur_entreprise_code_postal" value="<?=$joueur_entreprise_code_postal?>" style="width: 100px;"></div>
							<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_entreprise_code_postal', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
							<br clear="all">

							<div class="colonne_gauche_obligatoire"><?=$txt_pro_etape6_entreprise_ville?></div>
							<div class="colonne_droite"><input type="text" name="joueur_entreprise_ville" value="<?=$joueur_entreprise_ville?>"></div>
							<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_entreprise_ville', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
							<br clear="all">

							<div class="colonne_gauche_obligatoire"><?=$txt_pro_etape6_entreprise_pays?></div>
							<div class="colonne_droite">
								<select name="joueur_entreprise_pays" size="1" class="select">
									<option value="0"><?=$txt_selectionnez?></option>
									<?php 
									// Sélection des pays
									$requete_pays = mysqli_query($connexion_mysql, 'SELECT pays_code, pays_libelle_'.$_SESSION['SessionWeb_langue'].' FROM pays ORDER BY pays_libelle_'.$_SESSION['SessionWeb_langue']);
									$nb_pays = mysqli_num_rows($requete_pays);
									if($nb_pays!=0){
										for($pays_boucle=0; $pays_boucle<$nb_pays; $pays_boucle++){
											$resultat_pays = mysqli_fetch_array($requete_pays);
											$pays_code = $resultat_pays[0];
											$pays_libelle = $resultat_pays[1];

											if($pays_code==$joueur_entreprise_pays){ $pays_selection = ' selected'; }else{ $pays_selection = ''; }

											echo '<option value="'.$pays_code.'"'.$pays_selection.'>'.$pays_libelle.'</option>'."\n";

										}
									}
									?>
								</select>
							</div>
							<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_entreprise_pays', $formulaire_erreur)==true){ echo '<div class="erreur" style="margin-top: 6px;">'.$txt_obligatoire.'</div>'; } ?>
							<br clear="all">

							<div class="separateur_ter"></div>

							<div id="package_facture">

								<b><u><?=$txt_pro_etape6_soustitre_recapitulatif?></u></b><br><br>

								<table width="660" border="0" cellapdding="0" cellspacing="0">
									<tr>
										<td style="width: 280px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_description?></td>
										<td style="width: 150px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_prix_unitaire_ht?></td>
										<td style="width: 80px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_quantite?></td>
										<td style="width: 150px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_prix_total_ht?></td>
									</tr>
									<tr style="height: 30px;">
										<td>&nbsp;&nbsp;&nbsp;<?=$txt_pro_etape6_ligne_entreprise?></td>
										<td align="right"><?=number_format($facture_prix_entreprise_ht, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
										<td align="right">1&nbsp;&nbsp;&nbsp;</td>
										<td align="right"><?=number_format($facture_prix_entreprise_ht, 2, $txt_montant_separateur, $txt_montant_millier)?> &euro;&nbsp;&nbsp;&nbsp;</td>
									</tr>
									<?php 
									if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0){
										$facture_prix_total_ht_accompagnateurs = $facture_prix_accompagnateur_ht * count($_SESSION['SessionWeb_joueurs_acc']);
										echo '<tr style="height: 30px;">'."\n";
											echo '<td>&nbsp;&nbsp;&nbsp;'.$txt_pro_etape6_ligne_accompagnateur.'</td>'."\n";
											echo '<td align="right">'.number_format($facture_prix_accompagnateur_ht, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;</td>'."\n";
											echo '<td align="right">'.count($_SESSION['SessionWeb_joueurs_acc']).'&nbsp;&nbsp;&nbsp;</td>'."\n";
											echo '<td align="right">'.number_format($facture_prix_total_ht_accompagnateurs, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;</td>'."\n";
										echo '</tr>'."\n";

										$facture_prix_total_ht = $facture_prix_entreprise_ht + $facture_prix_total_ht_accompagnateurs;
										$facture_prix_tva = ($facture_prix_total_ht * $facture_tva) / 100;
										$facture_prix_total_ttc = $facture_prix_total_ht + $facture_prix_tva;
									}else{
										$facture_prix_total_ht = $facture_prix_entreprise_ht;
										$facture_prix_tva = $facture_prix_entreprise_tva;
										$facture_prix_total_ttc = $facture_prix_total_ht + $facture_prix_tva;
									}
									?>
									<tr>
										<td class="ligne_vide">&nbsp;</td>
										<td colspan="2" class="entete_ligne"><?=$txt_pro_etape6_colonne_sous_total_ht?>&nbsp;&nbsp;&nbsp;</td>
										<td align="right"><?=number_format($facture_prix_total_ht, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;'?></td>
									</tr>
									<tr>
										<td class="ligne_vide">&nbsp;</td>
										<td colspan="2" class="entete_ligne"><?=$txt_pro_etape6_colonne_tva?> (<?=number_format($facture_tva, 0, $txt_montant_separateur, $txt_montant_millier)?>%)&nbsp;&nbsp;&nbsp;</td>
										<td align="right"><?=number_format($facture_prix_tva, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;'?></td>
									</tr>
									<tr>
										<td class="ligne_vide">&nbsp;</td>
										<td colspan="2" class="entete_ligne"><?=$txt_pro_etape6_colonne_total_ttc?>&nbsp;&nbsp;&nbsp;</td>
										<td align="right" style="background-color: #EFEFEF; font-weight: bold;"><?=number_format($facture_prix_total_ttc, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;'?></td>
									</tr>
								</table>
								<br>

							</div>

						</div>

						<div class="separateur_ter"></div>

						<?=$txt_pro_etape6_laisser_message_facturation?><br>
						<textarea name="facture_message_joueur" style="width: 645px; height: 100px; margin-top: 5px; resize: vertical;"><?=$facture_message_joueur?></textarea>

					<?php }else{ ?>

						<div id="package_facture">

							<b><u><?=$txt_pro_etape6_soustitre_recapitulatif?></u></b><br><br>

							<table width="660" border="0" cellapdding="0" cellspacing="0">
								<tr>
									<td style="width: 280px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_description?></td>
									<td style="width: 150px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_prix_unitaire_ht?></td>
									<td style="width: 80px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_quantite?></td>
									<td style="width: 150px;" class="entete_colonne"><?=$txt_pro_etape6_colonne_prix_total_ht?></td>
								</tr>
								<?php 
								if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0){

									$facture_prix_total_ht = $facture_prix_accompagnateur_ht * count($_SESSION['SessionWeb_joueurs_acc']);
									$facture_prix_tva = ($facture_prix_total_ht * $facture_tva) / 100;
									$facture_prix_total_ttc = $facture_prix_total_ht + $facture_prix_tva;

									echo '<tr style="height: 30px;">'."\n";
										echo '<td>&nbsp;&nbsp;&nbsp;'.$txt_pro_etape6_ligne_accompagnateur.'</td>'."\n";
										echo '<td align="right">'.number_format($facture_prix_accompagnateur_ht, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;</td>'."\n";
										echo '<td align="right">'.count($_SESSION['SessionWeb_joueurs_acc']).'&nbsp;&nbsp;&nbsp;</td>'."\n";
										echo '<td align="right">'.number_format($facture_prix_total_ht, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;</td>'."\n";
									echo '</tr>'."\n";
								}
								?>
								<tr>
									<td class="ligne_vide">&nbsp;</td>
									<td colspan="2" class="entete_ligne"><?=$txt_pro_etape6_colonne_sous_total_ht?>&nbsp;&nbsp;&nbsp;</td>
									<td align="right"><?=number_format($facture_prix_total_ht, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;'?></td>
								</tr>
								<tr>
									<td class="ligne_vide">&nbsp;</td>
									<td colspan="2" class="entete_ligne"><?=$txt_pro_etape6_colonne_tva?> (<?=number_format($facture_tva, 0, $txt_montant_separateur, $txt_montant_millier)?>%)&nbsp;&nbsp;&nbsp;</td>
									<td align="right"><?=number_format($facture_prix_tva, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;'?></td>
								</tr>
								<tr>
									<td class="ligne_vide">&nbsp;</td>
									<td colspan="2" class="entete_ligne"><?=$txt_pro_etape6_colonne_total_ttc?>&nbsp;&nbsp;&nbsp;</td>
									<td align="right" style="background-color: #EFEFEF; font-weight: bold;"><?=number_format($facture_prix_total_ttc, 2, $txt_montant_separateur, $txt_montant_millier).' &euro;&nbsp;&nbsp;&nbsp;'?></td>
								</tr>
							</table>
							<br>

						</div>

						<div class="separateur_ter"></div>

						<?=$txt_pro_etape6_laisser_message_facturation?><br>
						<textarea name="facture_message_joueur" style="width: 645px; height: 100px; margin-top: 5px; resize: vertical;"><?=$facture_message_joueur?></textarea>

					<?php } ?>

				<?php }else{ ?>

					<h1><?=$txt_pro_etape6_validation_titre?></h1>

					<div class="separateur_ter"></div>

					<?=$txt_pro_etape6_validation_texte_1?><br><br>

					<?=$txt_pro_etape6_validation_texte_2?><br><br>

				<?php } ?>

				<div style="float: left; width: 120px; margin: 40px 0px 20px 0px;"><input type="button" value="<?=$txt_bouton_retour?>" onclick="window.location='./inscription_3_<?=$_SESSION['SessionWeb_joueur_profil']?>.php';" class="bouton_annuler"></div>
				<div align="right" style="margin: 40px 71px 20px 0px;"><input type="submit" value="<?=$txt_bouton_je_valide_inscription?>"></div><br clear="all">

			</form>

			<?php if((isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am'])!=0) OR (isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0)){ ?>

				<div class="separateur_ter"></div>

				<div id="texte">

					<?php if(isset($_SESSION['SessionWeb_joueurs_am']) AND count($_SESSION['SessionWeb_joueurs_am'])!=0){ ?>

						<div id="calque_package_golfeur_infos">

							<h2><?=$txt_package_golfeur_nom?></h2><br>

							<?=$txt_package_golfeur_texte?>

							<div class="separateur_ter"></div>

						</div>

						<div id="calque_package_entreprise_infos">

							<h2><?=$txt_package_entreprise_nom?></h2><br>

							<?=$txt_package_entreprise_texte?>

							<div class="separateur_ter"></div>

						</div>

					<?php } ?>

					<?php if(isset($_SESSION['SessionWeb_joueurs_acc']) AND count($_SESSION['SessionWeb_joueurs_acc'])!=0){ ?>

						<h2><?=$txt_package_accompagnateur_nom?></h2><br>

						<?=$txt_package_accompagnateur_texte?>

						<div class="separateur_ter"></div>

					<?php } ?>

				</div>

			<?php } ?>

		</div>

	</div>

</div>

<?php if(isset($joueur_package) AND strlen(trim($joueur_package))!=0){ ?>
	<script language="Javascript">
		change_package('<?=$joueur_package?>');
	</script>
<?php } ?>

</body>
</html>
