<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(8, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(12, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($golf_nom))==0){
		$erreur_message .= "- le nom est manquant<br>";
	}
	if(strlen(trim($golf_par))==0){
		$erreur_message .= "- le par est manquant<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$golf_nom = htmlentities(ucfirst($golf_nom), ENT_QUOTES);
	$golf_adresse_1 = htmlentities(ucfirst($golf_adresse_1), ENT_QUOTES);
	$golf_adresse_2 = htmlentities(ucfirst($golf_adresse_2), ENT_QUOTES);
	$golf_ville = htmlentities(strtoupper($golf_ville), ENT_QUOTES);

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		// Requête de mise à jour du golf
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE golfs SET golf_nom="'.$golf_nom.'", golf_adresse_1="'.$golf_adresse_1.'", golf_adresse_2="'.$golf_adresse_2.'", golf_code_postal="'.$golf_code_postal.'", golf_ville="'.$golf_ville.'", golf_telephone="'.$golf_telephone.'", golf_fax="'.$golf_fax.'", golf_email="'.$golf_email.'", golf_siteweb="'.$golf_siteweb.'", golf_par="'.$golf_par.'" WHERE golf_id='.$golf_id);

		header('Location: ./');
		exit;

	}else{
		$golf_nom = stripslashes($golf_nom);
		$golf_adresse_1 = stripslashes($golf_adresse_1);
		$golf_adresse_2 = stripslashes($golf_adresse_2);
		$golf_ville = stripslashes($golf_ville);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Sélection du golf
	$requete_golf = mysqli_query($connexion_mysql, 'SELECT golf_nom, golf_adresse_1, golf_adresse_2, golf_code_postal, golf_ville, golf_telephone, golf_fax, golf_email, golf_siteweb, golf_par FROM golfs WHERE golf_id='.$golf_id);
	$resultat_golf = mysqli_fetch_array($requete_golf);
	$golf_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_golf[0])));
	$golf_adresse_1 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_golf[1])));
	$golf_adresse_2 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_golf[2])));
	$golf_code_postal = $resultat_golf[3];
	$golf_ville = decodage_apostrophe(html_entity_decode(stripslashes($resultat_golf[4])));
	$golf_telephone = $resultat_golf[5];
	$golf_fax = $resultat_golf[6];
	$golf_email = $resultat_golf[7];
	$golf_siteweb = $resultat_golf[8];
	$golf_par = $resultat_golf[9];

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Golfs</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="modifier">
				<input type="hidden" name="golf_id" value="<?=$golf_id?>">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Nom</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_nom" value="<?=$golf_nom?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Par</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_par" value="<?=$golf_par?>" class="input" style="width: 50px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">INFORMATIONS FACULTATIVES</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Adresse</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_adresse_1" value="<?=$golf_adresse_1?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">&nbsp;</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_adresse_2" value="<?=$golf_adresse_2?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Code postal</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_code_postal" value="<?=$golf_code_postal?>" class="input" style="width: 80px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Ville</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_ville" value="<?=$golf_ville?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Téléphone</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_telephone" value="<?=$golf_telephone?>" class="input" style="width: 120px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Fax</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_fax" value="<?=$golf_fax?>" class="input" style="width: 120px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">E-mail</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_email" value="<?=$golf_email?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Site web</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="golf_siteweb" value="<?=$golf_siteweb?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.modifier.golf_nom.focus();
	//-->
</script>

</body>
</html>
