<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(8, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(12, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


// Sélection des golfs enregistrés
$requete_golfs = mysqli_query($connexion_mysql, 'SELECT golf_id, golf_nom, golf_ville, golf_par FROM golfs ORDER BY golf_id');
$nb_golfs = mysqli_num_rows($requete_golfs);
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 520px;">

		<div id="titres">
			<span class="titre_1">Golfs</span>
		</div>
		<br clear="all">

		<?php 
		if($nb_golfs==1){
			echo '<div id="ligne_compteur"><b>1</b> golf sélectionné</div>';
		}elseif($nb_golfs>1){
			echo '<div id="ligne_compteur"><b>'.$nb_golfs.'</b> golfs sélectionnés</div>';
		}
		?>

		<div id="bloc" style="width: 490px;">

			<?php if($nb_golfs!=0){ ?>

				<div id="ligne_entete">
					<div style="float: left; width: 200px;" title="Année">NOM</div>
					<div align="center" style="float: left; width: 160px; border-left: 1px solid #CCCCCC;" title="Date de début">VILLE</div>
					<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Date de fin">PAR</div>
				</div>

			<?php 
				for($golf_boucle=0; $golf_boucle<$nb_golfs; $golf_boucle++){
					$resultat_golf = mysqli_fetch_array($requete_golfs);
					$golf_id = $resultat_golf[0];
					$golf_nom = $resultat_golf[1];
					$golf_ville = $resultat_golf[2];
					$golf_par = $resultat_golf[3];
			?>

					<div id="ligne">
						<div style="float: left; width: 200px;" title="Nom"><a href="./modifier.php? golf_id=<?=$golf_id?>"><?=$golf_nom?></a></div>
						<div style="float: left; width: 150px; padding-left: 10px; border-left: 1px solid #CCCCCC;" title="Ville"><?=$golf_ville?></div>
						<div align="center" style="float: left; width: 80px; border-left: 1px solid #CCCCCC;" title="Par"><?=$golf_par?></div>
						<div id="ligne_icone"><a href="./modifier.php?golf_id=<?=$golf_id?>" title="Modifier"><img src="<?=$admin_img?>picto_modifier.png" width="10" height="10"></a></div>
					</div>

			<?php 
				}
			}else{
				echo '<div id="ligne">aucun golf enregistré</div>'."\n";
			}
			?>

		</div>

	</div>
	<br clear="all">

</div></div>


<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

</body>
</html>
