<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(6, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(3, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='modifier'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if($joueur_profil!='acc' AND $joueur_taille_polo=='0'){
		$erreur_message .= "- la taille du polo est manquante<br>";
	}
	if($joueur_equipe_id=='0'){
		$erreur_message .= "- le nom de l'équipe est manquant<br>";
	}
	if(!isset($joueur_sexe)){
		$erreur_message .= "- le sexe est manquant<br>";
	}
	if(strlen(trim($joueur_nom))==0){
		$erreur_message .= "- le nom est manquant<br>";
	}
	if(strlen(trim($joueur_prenom))==0){
		$erreur_message .= "- le prénom est manquant<br>";
	}
	if($joueur_profil!='acc'){
		if(strlen(trim($joueur_adresse_1))==0){
			$erreur_message .= "- l'adresse est manquante<br>";
		}
		if(strlen(trim($joueur_code_postal))==0){
			$erreur_message .= "- le code postal est manquant<br>";
		}
		if(strlen(trim($joueur_ville))==0){
			$erreur_message .= "- la ville est manquante<br>";
		}
		if($joueur_pays=='0'){
			$erreur_message .= "- le pays est manquant<br>";
		}
		if(strlen(trim($joueur_email))==0){
			$erreur_message .= "- l'adresse e-mail est manquante<br>";
		}
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$joueur_prenom = preg_replace('/-/', ' ', $joueur_prenom);

	if($joueur_profil!='acc'){

		$joueur_telephone = enregistrement_telephone($joueur_telephone);
		$joueur_mobile = enregistrement_telephone($joueur_mobile);
		$joueur_code_postal = enregistrement_telephone($joueur_code_postal);

		$joueur_licence = htmlentities(strtoupper_max($joueur_licence), ENT_QUOTES);
		$joueur_club = htmlentities(ucfirst($joueur_club), ENT_QUOTES);
		if(!isset($joueur_membre_club_competition)){ $joueur_membre_club_competition = 0; }
		if(preg_match('/,/', $joueur_handicap)==true){ $joueur_handicap = preg_replace('/,/', '.', $joueur_handicap); }
		if(!isset($joueur_handicap_validation)){ $joueur_handicap_validation = 0; }
		$joueur_nom = htmlentities(strtoupper_max($joueur_nom), ENT_QUOTES);
		$joueur_prenom = htmlentities(ucwords(strtolower_max($joueur_prenom)), ENT_QUOTES);
		$joueur_adresse_1 = htmlentities(ucfirst($joueur_adresse_1), ENT_QUOTES);
		$joueur_adresse_2 = htmlentities(ucfirst($joueur_adresse_2), ENT_QUOTES);
		$joueur_code_postal = htmlentities(strtolower_max($joueur_code_postal), ENT_QUOTES);
		$joueur_ville = htmlentities(strtoupper_max($joueur_ville), ENT_QUOTES);
		$joueur_email = htmlentities(strtolower_max($joueur_email), ENT_QUOTES);
		$joueur_mobile = htmlentities(strtolower_max($joueur_mobile), ENT_QUOTES);
		$joueur_telephone = htmlentities(strtolower_max($joueur_telephone), ENT_QUOTES);

	}else{
		$joueur_licence = $joueur_club = $joueur_handicap = '';
		$joueur_membre_club_competition = $joueur_handicap_validation = 0;
		$joueur_date_naissance = $joueur_adresse_1 = $joueur_adresse_2 = $joueur_code_postal = $joueur_ville = $joueur_email = $joueur_mobile = $joueur_telephone = '';
	}

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		if($joueur_handicap!=''){ $requete_handicap = '"'.$joueur_handicap.'"'; }else{ $requete_handicap = 'NULL'; }
		if($joueur_profil!='acc'){ $requete_taille_polo = '"'.$joueur_taille_polo.'"'; }else{ $requete_taille_polo = 'NULL'; }

		// Requête de mise à jour du joueur
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE joueurs SET joueur_club="'.$joueur_club.'", joueur_licence="'.$joueur_licence.'", joueur_handicap='.$requete_handicap.', joueur_handicap_validation="'.$joueur_handicap_validation.'", joueur_membre_club_competition="'.$joueur_membre_club_competition.'", joueur_taille_polo='.$requete_taille_polo.', joueur_sexe="'.$joueur_sexe.'", joueur_nom="'.$joueur_nom.'", joueur_prenom="'.$joueur_prenom.'", joueur_date_naissance=STR_TO_DATE("'.$joueur_date_naissance.'", "%d/%m/%Y"), joueur_adresse_1="'.$joueur_adresse_1.'", joueur_adresse_2="'.$joueur_adresse_2.'", joueur_code_postal="'.$joueur_code_postal.'", joueur_ville="'.$joueur_ville.'", joueur_pays="'.$joueur_pays.'", joueur_email="'.$joueur_email.'", joueur_mobile="'.$joueur_mobile.'", joueur_telephone="'.$joueur_telephone.'", joueur_langue="'.$joueur_langue.'", joueur_actif="'.$joueur_actif.'" WHERE joueur_id="'.$joueur_id.'"');

		header('Location: ./');
		exit;

	}else{
		$joueur_licence = stripslashes($joueur_licence);
		$joueur_club = stripslashes($joueur_club);
		$joueur_nom = stripslashes($joueur_nom);
		$joueur_prenom = stripslashes($joueur_prenom);
		$joueur_adresse_1 = stripslashes($joueur_adresse_1);
		$joueur_adresse_2 = stripslashes($joueur_adresse_2);
		$joueur_code_postal = stripslashes($joueur_code_postal);
		$joueur_ville = stripslashes($joueur_ville);
		$joueur_email = stripslashes($joueur_email);
		$joueur_mobile = stripslashes($joueur_mobile);
		$joueur_telephone = stripslashes($joueur_telephone);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Sélection du joueur
	$requete_equipes_joueur = mysqli_query($connexion_mysql, 'SELECT ej_id FROM equipes_joueurs WHERE ej_joueur="'.$joueur_id.'"');
	$nb_equipes_joueur = mysqli_num_rows($requete_equipes_joueur);

	if($nb_equipes_joueur==1){

		// Sélection du joueur
		$requete_joueur = mysqli_query($connexion_mysql, 'SELECT joueur_profil, joueur_club, joueur_licence, joueur_handicap, joueur_handicap_validation, joueur_taille_polo, joueur_membre_club_competition, joueur_sexe, joueur_nom, joueur_prenom, DATE_FORMAT(joueur_date_naissance, "%d/%m/%Y"), joueur_adresse_1, joueur_adresse_2, joueur_code_postal, joueur_ville, joueur_pays, joueur_email, joueur_mobile, joueur_telephone, joueur_langue, DATE_FORMAT(joueur_datetime_creation, "%d/%m/%Y à %Hh%i"), joueur_actif, (SELECT equipe_nom FROM equipes A INNER JOIN equipes_joueurs B ON A.equipe_id=B.ej_equipe WHERE ej_joueur=joueur_id), (SELECT ej_joueur_accompagnant FROM equipes_joueurs WHERE ej_joueur=joueur_id) FROM joueurs WHERE joueur_id="'.$joueur_id.'"');
		$resultat_joueur = mysqli_fetch_array($requete_joueur);

		$joueur_profil = $resultat_joueur[0];
		$joueur_club = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
		$joueur_licence = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2])));
		$joueur_handicap = $resultat_joueur[3];
		$joueur_handicap_validation = $resultat_joueur[4];
		$joueur_taille_polo = $resultat_joueur[5];
		$joueur_membre_club_competition = $resultat_joueur[6];
		$joueur_sexe = $resultat_joueur[7];
		$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[8])));
		$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[9])));
		$joueur_date_naissance = $resultat_joueur[10];
		$joueur_adresse_1 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[11])));
		$joueur_adresse_2 = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[12])));
		$joueur_code_postal = $resultat_joueur[13];
		$joueur_ville = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[14])));
		$joueur_pays = $resultat_joueur[15];
		$joueur_email = $resultat_joueur[16];
		$joueur_mobile = $resultat_joueur[17];
		$joueur_telephone = $resultat_joueur[18];
		$joueur_langue = strtoupper($resultat_joueur[19]);
		$joueur_datetime_creation = $resultat_joueur[20];
		$joueur_actif = $resultat_joueur[21];
		$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[22])));
		$joueur_accompagnant = $resultat_joueur[23];

		if($joueur_handicap==NULL){ $joueur_handicap = ''; }
		if($joueur_date_naissance=='00/00/0000'){ $joueur_date_naissance = ''; }

		if($joueur_profil=='pro'){
			$joueur_profil_nom = 'Professionnel';
		}elseif($joueur_profil=='am'){
			$joueur_profil_nom = 'Amateur';
		}else{
			$joueur_profil_nom = 'Accompagnateur';
		}

		if($joueur_profil!='am'){
			$joueur_handicap = '';
		}elseif(strlen(trim($joueur_handicap))!=0){
			if(substr($joueur_handicap, -2)!='.0'){
				$joueur_handicap = number_format($joueur_handicap, 1, ',', '');
			}elseif(substr($joueur_handicap, -2)=='.0'){
				$joueur_handicap = number_format($joueur_handicap, 0);
			}
		}

	}else{

		// Sélection du joueur
		$requete_joueur = mysqli_query($connexion_mysql, 'SELECT joueur_nom, joueur_prenom FROM joueurs WHERE joueur_id="'.$joueur_id.'"');
		$resultat_joueur = mysqli_fetch_array($requete_joueur);
		$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[0])));
		$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));

	}

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
	<script type="text/javascript">
		function joueur_profil_details(profil){
			if(profil=='pro' || profil=='am'){
				document.getElementById('calque_joueur_pro_am').style.display = 'block';
				document.getElementById('calque_joueur_acc').style.display = 'none';
				if(profil=='pro'){
					document.getElementById('calque_pro_profil_handicap').style.display = 'none';
				}else{
					document.getElementById('calque_pro_profil_handicap').style.display = 'block';
				}
			}else{
				document.getElementById('calque_joueur_pro_am').style.display = 'none';
				document.getElementById('calque_joueur_acc').style.display = 'block';
			}
		}
	</script>
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<?php if($nb_equipes_joueur>1){ ?>

			<div id="titres">
				<span class="titre_1" style="width: 368px;"><a href="./">Joueurs</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
			</div>
			<br clear="all">

			<div id="bloc_bis">

				<div align="center" style="margin: 20px 0px 40px 0px;"><div id="message_erreur" align="left">
					<b><u>AVERTISSSEMENT</u></b><br>
					<img src="<?=$adm_img?>p.gif" width="1" height="10"><br>
					Le joueur « <b><?=$joueur_prenom.' '.$joueur_nom?></b> » est présent dans plusieurs équipes.<br>
					<img src="<?=$adm_img?>p.gif" width="1" height="5"><br>
					Pour afficher la fiche de ce joueur, merci de garder ce joueur que dans une seule équipe.
				</div></div>

			</div>

		<?php }else{ ?>

			<div id="titres">
				<span class="titre_1" style="width: 368px;"><a href="./">Joueurs</a> <span class="separateur">/</span> <span class="titre_2">Modifier</span></span>
				<span class="ajouter" style="width: 270px;"><a href="./envoyer_confirmation.php?joueur_id=<?=$joueur_id?>">Envoyer un e-mail de confirmation</a></span>
			</div>
			<br clear="all">

			<div id="bloc_bis">

				<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
					<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
				<?php } ?>

				<form name="modifier" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

					<input type="hidden" name="action" value="modifier">
					<input type="hidden" name="joueur_id" value="<?=$joueur_id?>">
					<input type="hidden" name="joueur_profil" value="<?=$joueur_profil?>">
					<input type="hidden" name="joueur_profil_nom" value="<?=$joueur_profil_nom?>">
					<input type="hidden" name="equipe_nom" value="<?=$equipe_nom?>">
					<input type="hidden" name="joueur_accompagnant" value="<?=$joueur_accompagnant?>">
					<input type="hidden" name="nb_equipes_joueur" value="<?=$nb_equipes_joueur?>">
					<input type="hidden" name="joueur_equipe_id" value="<?=$joueur_equipe_id?>">

					<div id="formulaire_ligne_intertitre">COMPTE</div>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle">Statut</div>
						<div id="formulaire_champ" style="width: 195px;">
							<input type="radio" id="joueur_actif_1" name="joueur_actif" value="1" <?php if($joueur_actif==1){ echo 'checked'; } ?> class="radio"> <label for="joueur_actif_1">Actif</label>
							<input type="radio" id="joueur_actif_0" name="joueur_actif" value="0" <?php if($joueur_actif==0){ echo 'checked'; } ?> class="radio" style="margin-left: 20px;"> <label for="joueur_actif_0">Inactif</label>
						</div>
						<div id="formulaire_libelle" style="width: 90px;">Langue</div>
						<div id="formulaire_champ" style="width: 195px;">
							<select name="joueur_langue" size="1" class="select" style="width: 150px;">
								<option value="FR" <?php if($joueur_langue=='FR'){ echo 'selected'; } ?>>Français</option>
								<option value="EN" <?php if($joueur_langue=='EN'){ echo 'selected'; } ?>>Anglais</option>
							</select>
						</div>
						<br clear="all">
					</div>

					<div id="formulaire_ligne_intertitre">PROFIL</div>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle">Profil</div>
						<div id="formulaire_champ" style="width: 500px;"><?=$joueur_profil_nom?></div>
						<br clear="all">
					</div>
					<div id="calque_joueur_pro_am"<?php if(!isset($joueur_profil) OR (isset($joueur_profil) AND $joueur_profil=='acc')){ echo ' style="display: none;"'; } ?>>
						<div id="formulaire_ligne">
							<div id="formulaire_libelle">N° licence</div>
							<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_licence" value="<?=$joueur_licence?>" class="input" style="width: 164px;"></div>
							<?php if($joueur_profil=='am'){ ?>
								<div id="formulaire_libelle" style="width: 145px;">Handicap</div>
								<div id="formulaire_champ" style="width: 140px;"><input type="text" name="joueur_handicap" value="<?=$joueur_handicap?>" class="input" style="width: 60px;"></div>
							<?php } ?>
							<br clear="all">
						</div>
						<div id="formulaire_ligne">
							<div id="formulaire_libelle">Club</div>
							<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_club" value="<?=$joueur_club?>" class="input" style="width: 164px;"></div>
							<div id="formulaire_libelle" style="width: 145px;">Validation du HDCP</div>
							<div id="formulaire_champ" style="width: 140px;"><input type="checkbox" name="joueur_handicap_validation" value="1" <?php if($joueur_handicap_validation==1){ echo 'checked'; } ?>></div>
							<br clear="all">
						</div>
						<div id="formulaire_ligne">
							<div id="formulaire_libelle" style="padding-top: 0px; padding-bottom: 0px;">&nbsp;</div>
							<div id="formulaire_champ" style="width: 195px; color: #666666;"><input type="checkbox" name="joueur_membre_club_competition" value="1" <?php if($joueur_membre_club_competition==1){ echo 'checked'; } ?>> Membre de l'un des 4 clubs</div>
							<div id="formulaire_libelle_obligatoire" style="width: 145px;">Taille du polo</div>
							<div id="formulaire_champ" style="width: 140px;">
								<select name="joueur_taille_polo" size="1" class="select" style="width: 100px;">
									<option value="0">-</option>
									<option value="NC"<?php if($joueur_taille_polo=='NC'){ echo ' selected'; } ?>>NC</option>
									<option value="S"<?php if($joueur_taille_polo=='S'){ echo ' selected'; } ?>>S</option>
									<option value="M"<?php if($joueur_taille_polo=='M'){ echo ' selected'; } ?>>M</option>
									<option value="L"<?php if($joueur_taille_polo=='L'){ echo ' selected'; } ?>>L</option>
									<option value="XL"<?php if($joueur_taille_polo=='XL'){ echo ' selected'; } ?>>XL</option>
									<option value="XXL"<?php if($joueur_taille_polo=='XXL'){ echo ' selected'; } ?>>XXL</option>
								</select>
							</div>
							<br clear="all">
						</div>

						<div id="formulaire_ligne_separateur"></div>

						<div id="formulaire_ligne">
							<div id="formulaire_libelle">&Eacute;quipe</div>
							<div id="formulaire_champ" style="width: 500px;"><?=$equipe_nom?></div>
							<br clear="all">
						</div>

					</div>

					<?php if($joueur_profil=='acc'){ ?>

						<div id="formulaire_ligne">
							<div id="formulaire_libelle">Joueur</div>
							<div id="formulaire_champ" style="width: 500px;">
								<?php 
								// Sélection du joueur accompagnant
								$requete_joueur_accompagnant = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom FROM joueurs WHERE joueur_id="'.$joueur_accompagnant.'"');
								$resultat_joueur_accompagnant = mysqli_fetch_array($requete_joueur_accompagnant);
								$joueur_accompagnant_nom = $resultat_joueur_accompagnant[1];
								$joueur_accompagnant_prenom = $resultat_joueur_accompagnant[2];

								echo $joueur_accompagnant_nom.' '.$joueur_accompagnant_prenom;
								?>
							</div>
							<br clear="all">
						</div>

					<?php } ?>

					<div id="formulaire_ligne_intertitre">INFORMATIONS</div>

					<div id="formulaire_ligne">
						<div id="formulaire_libelle">Sexe</div>
						<div id="formulaire_champ" style="width: 500px;">
							<input type="radio" id="joueur_sexe_homme" name="joueur_sexe" value="H" <?php if($joueur_sexe=='H'){ echo 'checked'; } ?>> <label for="joueur_sexe_homme">Homme</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
							<input type="radio" id="joueur_sexe_femme" name="joueur_sexe" value="F" <?php if($joueur_sexe=='F'){ echo 'checked'; } ?>> <label for="joueur_sexe_femme">Femme</label>
						</div>
						<br clear="all">
					</div>
					<div id="formulaire_ligne">
						<div id="formulaire_libelle_obligatoire">Nom</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_nom" value="<?=$joueur_nom?>" class="input" style="width: 164px;"></div>
						<div id="formulaire_libelle_obligatoire" style="width: 90px;">Prénom</div>
						<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_prenom" value="<?=$joueur_prenom?>" class="input" style="width: 164px;"></div>
						<br clear="all">
					</div>

					<?php if($joueur_profil!='acc'){ ?>

						<div id="formulaire_ligne">
							<div id="formulaire_libelle">Né(e) le</div>
							<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_date_naissance" value="<?=$joueur_date_naissance?>" class="input" style="width: 164px;"></div>
							<br clear="all">
						</div>

						<div id="formulaire_ligne_separateur"></div>

						<div id="formulaire_ligne">
							<div id="formulaire_libelle_obligatoire">Adresse</div>
							<div id="formulaire_champ" style="width: 500px;">
								<input type="text" name="joueur_adresse_1" value="<?=$joueur_adresse_1?>" class="input" style="width: 470px; margin-bottom: 5px;"><br>
								<input type="text" name="joueur_adresse_2" value="<?=$joueur_adresse_2?>" class="input" style="width: 470px;">
							</div>
							<br clear="all">
						</div>
						<div id="formulaire_ligne">
							<div id="formulaire_libelle_obligatoire">Code postal</div>
							<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_code_postal" value="<?=$joueur_code_postal?>" class="input" style="width: 164px;"></div>
							<div id="formulaire_libelle_obligatoire" style="width: 90px;">Ville</div>
							<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_ville" value="<?=$joueur_ville?>" class="input" style="width: 164px;"></div>
							<br clear="all">
						</div>
						<div id="formulaire_ligne">
							<div id="formulaire_libelle_obligatoire">Pays</div>
							<div id="formulaire_champ" style="width: 500px;">
								<select name="joueur_pays" size="1" class="select">
									<option value="0">-</option>
									<?php 
									// Sélection des pays
									$requete_pays = mysqli_query($connexion_mysql, 'SELECT pays_code, pays_libelle_FR FROM pays ORDER BY pays_libelle_FR');
									$nb_pays = mysqli_num_rows($requete_pays);
									if($nb_pays!=0){
										for($pays_boucle=0; $pays_boucle<$nb_pays; $pays_boucle++){
											$resultat_pays = mysqli_fetch_array($requete_pays);
											$pays_code = $resultat_pays[0];
											$pays_libelle = $resultat_pays[1];

											if($pays_code==$joueur_pays){ $pays_selection = ' selected'; }else{ $pays_selection = ''; }

											echo '<option value="'.$pays_code.'"'.$pays_selection.'>'.$pays_libelle.'</option>'."\n";

										}
									}
									?>
								</select>
							</div>
							<br clear="all">
						</div>

						<div id="formulaire_ligne_separateur"></div>

						<div id="formulaire_ligne">
							<div id="formulaire_libelle_obligatoire">E-mail</div>
							<div id="formulaire_champ" style="width: 500px;"><input type="text" name="joueur_email" value="<?=$joueur_email?>" class="input" style="width: 470px;"></div>
							<br clear="all">
						</div>
						<div id="formulaire_ligne">
							<div id="formulaire_libelle">Mobile</div>
							<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_mobile" value="<?=$joueur_mobile?>" class="input" style="width: 164px;"></div>
							<div id="formulaire_libelle" style="width: 90px;">Téléphone</div>
							<div id="formulaire_champ" style="width: 195px;"><input type="text" name="joueur_telephone" value="<?=$joueur_telephone?>" class="input" style="width: 164px;"></div>
							<br clear="all">
						</div>

					<?php } ?>

					<div id="formulaire_ligne_intertitre">FACTURATION</div>

					<?php 
					// Sélection des factures
					$requete_factures = mysqli_query($connexion_mysql, 'SELECT facture_id, facture_numero, facture_package, DATE_FORMAT(facture_date, "%d/%m/%Y"), facture_prix_ht, facture_prix_ttc, facture_payee, facture_mode_paiement FROM factures WHERE joueur_id="'.$joueur_id.'"');
					$nb_factures = mysqli_num_rows($requete_factures);
					if($nb_factures!=0){
						for($facture_boucle=0; $facture_boucle<$nb_factures; $facture_boucle++){
							$resultat_facture = mysqli_fetch_array($requete_factures);
							$facture_id = $resultat_facture[0];
							$facture_numero = $resultat_facture[1];
							$facture_package = ucfirst($resultat_facture[2]);
							$facture_date = $resultat_facture[3];
							$facture_prix_ht = number_format($resultat_facture[4], 2, ',', ' ');
							$facture_prix_ttc = number_format($resultat_facture[5], 2, ',', ' ');
							$facture_payee = $resultat_facture[6];
							$facture_mode_paiement = strtolower($resultat_facture[7]).'.';

							while(strlen(trim($facture_numero)) < 3){
								$facture_numero = '0'.$facture_numero;
							}
							$facture_numero = 'PACO-'.substr($facture_date, 6, 10).'-'.$facture_numero;
							if($facture_payee==1){ $facture_statut = 'Payé par '.$facture_mode_paiement; }else{ $facture_statut = 'Impayé'; }
					?>

							<div id="formulaire_ligne">
								<div id="formulaire_libelle">Facture N°</div>
								<div id="formulaire_champ" style="width: 110px;"><?=$facture_numero?></div>
								<div id="formulaire_libelle" style="width: 70px;">Date</div>
								<div id="formulaire_champ" style="width: 80px;"><?=$facture_date?></div>
								<div id="formulaire_libelle" style="width: 80px;">Package</div>
								<div id="formulaire_champ" style="width: 120px;"><?=$facture_package?></div>
								<br clear="all">
							</div>
							<div id="formulaire_ligne">
								<div id="formulaire_libelle">Prix HT</div>
								<div id="formulaire_champ" style="width: 110px;"><?=$facture_prix_ht?> &euro;</div>
								<div id="formulaire_libelle" style="width: 70px;">Prix TTC</div>
								<div id="formulaire_champ" style="width: 80px;"><?=$facture_prix_ttc?> &euro;</div>
								<div id="formulaire_libelle" style="width: 80px;">Statut</div>
								<div id="formulaire_champ" style="width: 120px;"><?=$facture_statut?></div>
								<br clear="all">
							</div>
							<div id="formulaire_ligne">
								<div id="formulaire_libelle">&nbsp;</div>
								<div id="formulaire_libelle" style="width: 300px; text-align: left;"><a href="../facturation/modifier.php?facture_id=<?=$facture_id?>" target="_blank" style="color: #007FBF;">modifier</a> &nbsp;|&nbsp; <a href="../facturation/facture.php?facture_id=<?=$facture_id?>" target="_blank" style="color: #007FBF;">facture PDF</a></div>
								<br clear="all">
							</div>

					<?php 
							if($nb_factures>1){ echo '<div id="formulaire_ligne_separateur"></div>'."\n"; }

						}
					}else{

						echo '<div id="formulaire_ligne">'."\n";
							echo '<div id="formulaire_libelle" style="width: 200px; color: #AAAAAA;">aucune facture enregistré.</div>'."\n";
							echo '<br clear="all">'."\n";
						echo '</div>'."\n";

					}
					?>

					<br>

					<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

				</form>

			</div>

		<?php } ?>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<?php if($nb_equipes_joueur==1){ ?>

	<script language="Javascript">
		<!-- 
		document.modifier.joueur_nom.focus();
		//-->
	</script>

<?php } ?>

</body>
</html>
