<?php 

/*****************/
/**  FONCTIONS  **/
/*****************/

// FORMATAGE DU MESSAGE D'ERREUR
function message_erreur($texte){
	echo '<div style="font-family: Verdana; font-size:12px; color: #FF0000; padding: 20px;"><b>ERREUR BLOQUANTE !</b><br><hr width="100%" size="1" color="#FF0000"><br>'.$texte.'<br><br>Merci de nous en informer :&nbsp; <a href="mailto:proam@golf-first.fr">proam@golf-first.fr</a></div>';
}


// CONNEXION A LA BASE DE DONNEES
function connexion_database($db_serveur, $db_nom_utilisateur, $db_mot_passe, $db_base){
	$connexion_database = mysqli_connect($db_serveur, $db_nom_utilisateur, $db_mot_passe, $db_base);
	if(!$connexion_database){
		message_erreur('Impossible de se connecter à la base de données.');
		exit;
	}

	return $connexion_database;
/*
	$requete_comptes = mysqli_query($connexion_mysql, 'SELECT compte_id, compte_nom_utilisateur, compte_mot_passe, compte_type, compte_acces_modules, compte_acces_rubriques FROM admin_comptes');
	$nb_comptes = mysqli_num_rows($requete_comptes);
	// $resultat_compte = mysqli_fetch_array($requete_comptes);
	// $mot_passe_md5 = $resultat_compte['compte_mot_passe']){
	// echo $mot_passe_md5;

	echo $nb_comptes;
	exit;
*/
}




/**************************************/
/**  POUR LE REGISTER_GLOBALS = OFF  **/
/**************************************/

// DEFINITION DES VARIABLES GLOBALES
$PHP_SELF = $_SERVER['PHP_SELF'];
$HTTP_HOST = $_SERVER['HTTP_HOST'];
$HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
$REQUEST_URI = $_SERVER['REQUEST_URI'];
if(isset($_SERVER['SCRIPT_URI'])){ $SCRIPT_URI = $_SERVER['SCRIPT_URI']; }
if(isset($_SERVER['HTTP_REFERER'])){ $HTTP_REFERER = $_SERVER['HTTP_REFERER']; }

// RECUPERATION DES VARIABLES PASSEES EN POST ET EN GET
while(list($key, $val) = each($_POST)){ $$key = $val; }
while(list($key, $val) = each($_GET)){ $$key = $val; }


/*****************/
/**  REPERAGES  **/
/*****************/

if(preg_match('/admin/', $HTTP_HOST)==true){

	$espace = 'admin';
	preg_match_all('/\//', $PHP_SELF, $arborescence_niveaux);
	$arborescence_niveaux = count($arborescence_niveaux[0]);

	if(preg_match('/\/modules/', $PHP_SELF)==false AND (preg_match('/\/index.php/', $PHP_SELF)==true OR preg_match('/\/auth.php/', $PHP_SELF)==true OR preg_match('/\/motdepasse_oublie.php/', $PHP_SELF)==true)){
		$general_path_relatif = './';
	}elseif(preg_match('/\/sources/', $PHP_SELF)==true OR preg_match('/\/batchs/', $PHP_SELF)==true){
		$general_path_relatif = '../';
	}elseif(preg_match('/\/modules/', $PHP_SELF)==true AND $arborescence_niveaux==4){
		$general_path_relatif = '../../../';
	}elseif(preg_match('/\/modules/', $PHP_SELF)==true AND $arborescence_niveaux==3){
		$general_path_relatif = '../../';
	}else{
		$general_path_relatif = '../';
	}

}elseif(preg_match('/scores/', $HTTP_HOST)==true){

	$espace = 'scores';
	$general_path_relatif = '../web/';

}elseif(preg_match('/mobile/', $HTTP_HOST)==true){

	$espace = 'mobile';
	$general_path_relatif = '../mobile/';

}else{

	$espace = 'web';
	$general_path_relatif = './';

}


/******************/
/**  PARAMETRES  **/
/******************/

// SELECTION DU FICHIER DU CONFIGURATION CONTENANT LES PARAMETRES (FICHIER DE DEVELOPPEMENT OU DE PRODUCTION)
if(preg_match('/dev./', $HTTP_HOST)==true){
	$fichier_configuration = implode('', file('/Applications/MAMP/htdocs/wwwduosbiarritz/lib/configuration_developpement.json'));
}else{
	$fichier_configuration = implode('', file('/home/proamcotty/wwwduosbiarritz/lib/configuration_production.json'));
}

// TRANSFORMATION DU FORMAT JSON EN TABLEAU
$tab_parametres = json_decode($fichier_configuration, true);

// AFFECTATION DES PARAMETRES EN VARIABLE PHP
foreach($tab_parametres as $parametre_nom=>$parametre_valeur){
	$$parametre_nom = $parametre_valeur;
}


/*******************/
/****  ACTIONS  ****/
/*******************/

$connexion_mysql = connexion_database($db_serveur, $db_nom_utilisateur, $db_mot_passe, $db_base);		// Connexion a la base de donnees

session_start();																						// Declenchement de la session PHP


// LIBRAIRIES
if($espace=='admin'){

	// AJUSTEMENT DES VARIABLES EN FONCTION DU REPERAGE
	$admin_css_authentification = $general_path_relatif.$admin_css_authentification.'?URL='.$PHP_SELF;
	$admin_css_page = $general_path_relatif.$admin_css_page.'?URL='.$PHP_SELF;
	$admin_img = $general_path_relatif.$admin_img;
	$admin_js = $general_path_relatif.$admin_js;

	require $general_path_relatif.'libs/fonctions_admin.inc';																// Fonctions servant uniquement l administration
	require $general_path_relatif.'libs/fonctions_standards.inc';															// Fonctions standards servant a tous types de script
	require $general_path_relatif.'libs/class.image.php';																	// Librairie de redimensionnement des images
	require $general_path_relatif.'libs/divers.inc';																		// Variables disponibles pour tous types de script

}elseif($espace!='admin'){

	$web_commun_path = $general_path_relatif.$web_commun;
	$web_commun = $web_url.'/'.$web_commun;

	require $web_commun_path.'fonctions.inc';																				// Fonctions disponibles pour tous types de script

}


// SI LA SESSION A EXPIRE, ALORS DECONNEXION TOTALE
if($espace=='admin' AND strlen(trim($general_path_relatif))!=0 AND !isset($_SESSION['SessionADMIN_compte_id'])){
}elseif($espace=='admin' AND $PHP_SELF!='/sources/deconnexion.php'){
	// DEMANDE DE PRISE EN COMPTE DES NOUVELLES IMAGES PAR LE NAVIGATEUR
	header("Expires: Mon, 17 Jul 1979 05:00:00 GMT");
	header('Last-Modified: '.gmdate('D, d M Y H:i:s',time()).' GMT');
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Cache-Control: post-check=0, pre-check=0", false);
	header("Pragma: no-cache");
}

// Sélection des tarifs pour l'inscription à la compétition
$requete_competition_tarifs = mysqli_query($connexion_mysql, 'SELECT prix_tva, prix_golfeur_nonmembre_ht, prix_golfeur_nonmembre_tva, prix_golfeur_nonmembre_ttc, prix_golfeur_membre_ht, prix_golfeur_membre_tva, prix_golfeur_membre_ttc, prix_entreprise_ht, prix_entreprise_tva, prix_entreprise_ttc, prix_entreprise_accompagnateur_ht, prix_entreprise_accompagnateur_tva, prix_entreprise_accompagnateur_ttc, prix_accompagnateur_ht, prix_accompagnateur_tva, prix_accompagnateur_ttc, param_site_affichage_planning, param_site_affichage_cartes_score FROM parametres WHERE parametre_id=1');
$resultat_competition_tarif = mysqli_fetch_array($requete_competition_tarifs);
$facture_tva = $resultat_competition_tarif[0];
$facture_prix_golfeur_pasmembre_ht = $resultat_competition_tarif[1];
$facture_prix_golfeur_pasmembre_tva = $resultat_competition_tarif[2];
$facture_prix_golfeur_pasmembre_ttc = $resultat_competition_tarif[3];
$facture_prix_golfeur_membre_ht = $resultat_competition_tarif[4];
$facture_prix_golfeur_membre_tva = $resultat_competition_tarif[5];
$facture_prix_golfeur_membre_ttc = $resultat_competition_tarif[6];
$facture_prix_entreprise_ht = $resultat_competition_tarif[7];
$facture_prix_entreprise_tva = $resultat_competition_tarif[8];
$facture_prix_entreprise_ttc = $resultat_competition_tarif[9];
$facture_prix_entreprise_accompagnateur_ht = $resultat_competition_tarif[10];
$facture_prix_entreprise_accompagnateur_tva = $resultat_competition_tarif[11];
$facture_prix_entreprise_accompagnateur_ttc = $resultat_competition_tarif[12];
$facture_prix_accompagnateur_ht = $resultat_competition_tarif[13];
$facture_prix_accompagnateur_tva = $resultat_competition_tarif[14];
$facture_prix_accompagnateur_ttc = $resultat_competition_tarif[15];
$parametre_site_affichage_planning = $resultat_competition_tarif[16];
$parametre_site_affichage_cartes_score = $resultat_competition_tarif[17];

if($espace=='web' OR $espace=='mobile'){

	if(!isset($langue) AND !isset($_SESSION['SessionWeb_langue'])){
		$_SESSION['SessionWeb_langue'] = 'FR';
	}elseif(isset($langue) AND isset($_SESSION['SessionWeb_langue']) AND strtoupper($langue)!=$_SESSION['SessionWeb_langue']){
		if($langue=='en'){
			$_SESSION['SessionWeb_langue'] = 'EN';
		}elseif($langue=='fr'){
			$_SESSION['SessionWeb_langue'] = 'FR';
		}
	}

	// Sélection de la compétition en cours
	$requete_web_competition = mysqli_query($connexion_mysql, 'SELECT competition_id, DATE_FORMAT(competition_date_debut, "%Y") FROM competitions WHERE competition_active=1 AND competition_archive=0 ORDER BY competition_annee DESC');
	$resultat_web_competition = mysqli_fetch_array($requete_web_competition);
	$_SESSION['SessionWeb_competition_id'] = $resultat_web_competition[0];
	$competition_active_annee = $resultat_web_competition[1];

	if($espace=='mobile'){

		$espace = 'equipe';

		if(file_exists($general_path_relatif.'commun/traductions_'.strtoupper($_SESSION['SessionWeb_langue']).'.inc')==true){
			require $general_path_relatif.'commun/traductions_'.strtoupper($_SESSION['SessionWeb_langue']).'.inc';						// Elements divers disponibles pour tous types de script
		}

	}else{

		if(file_exists($general_path_relatif.'commun/traductions_'.strtoupper($_SESSION['SessionWeb_langue']).'.inc')==true){
			require $general_path_relatif.'commun/traductions_'.strtoupper($_SESSION['SessionWeb_langue']).'.inc';						// Elements divers disponibles pour tous types de script
		}

	}

}
?>