<?php 
include '../lib/configuration.inc';


// Si le profil du joueur am n'est pas connu, alors retour à l'inscription
if(!isset($_SESSION['SessionWeb_joueur_profil'])){
	header('Location: ./inscription_1.php');
	exit;
}


if(isset($autorisation) AND $autorisation=='inscription'){

	if(strlen(trim($joueur_email))!=0){
		// Vérification si l'adresse e-mail existe
		$requete_verification_email = mysqli_query($connexion_mysql, 'SELECT joueur_id FROM joueurs WHERE joueur_email="'.$joueur_email.'"');
		$nb_verification_email = mysqli_num_rows($requete_verification_email);
	}

	if(isset($nb_verification_email) AND $nb_verification_email!=0){
		$formulaire_erreur[] = 'joueur_email_inscrit';
	}else{

		if(!isset($joueur_membre_club_competition)){
			$formulaire_erreur[] = 'joueur_membre_club_competition';
		}

		if(strlen(trim($joueur_sexe))==0){
			$formulaire_erreur[] = 'joueur_sexe';
		}
		if(strlen(trim($joueur_nom))==0){
			$formulaire_erreur[] = 'joueur_nom';
		}
		if(strlen(trim($joueur_prenom))==0){
			$formulaire_erreur[] = 'joueur_prenom';
		}
		if(strlen(trim($joueur_date_naissance))!=0 AND preg_match('/\//', $joueur_date_naissance)==true){
			$joueur_date_naissance_tab = explode('/', $joueur_date_naissance);
			if(count($joueur_date_naissance_tab)!=3 OR strlen($joueur_date_naissance_tab[0])!=2 OR strlen($joueur_date_naissance_tab[1])!=2 OR strlen($joueur_date_naissance_tab[2])!=4){
				$formulaire_erreur[] = 'joueur_date_naissance_incorrecte';
			}
		}elseif(strlen(trim($joueur_date_naissance))!=0 AND preg_match('/\//', $joueur_date_naissance)==false){
			$formulaire_erreur[] = 'joueur_date_naissance_incorrecte';
		}
		if($joueur_taille_polo=='0'){
			$formulaire_erreur[] = 'joueur_taille_polo';
		}
		if(strlen(trim($joueur_adresse_1))==0){
			$formulaire_erreur[] = 'joueur_adresse_1';
		}
		if(strlen(trim($joueur_code_postal))==0){
			$formulaire_erreur[] = 'joueur_code_postal';
		}
		if(strlen(trim($joueur_ville))==0){
			$formulaire_erreur[] = 'joueur_ville';
		}
		if($joueur_pays=='0'){
			$formulaire_erreur[] = 'joueur_pays';
		}
		if(strlen(trim($joueur_email))==0){
			$formulaire_erreur[] = 'joueur_email';
		}elseif(preg_match('/@/', $joueur_email)==false OR preg_match('/\./', $joueur_email)==false){
			$formulaire_erreur[] = 'joueur_email_incorrect';
		}

	}

	if(count($formulaire_erreur)==0){

		// Traitement des informations pour enregistrement en base de données
		$joueur_prenom = preg_replace('/-/', ' ', $joueur_prenom);
		$joueur_code_postal = enregistrement_chiffres($joueur_code_postal);
		$joueur_telephone = enregistrement_chiffres($joueur_telephone);
		$joueur_mobile = enregistrement_chiffres($joueur_mobile);

		$joueur_club = htmlentities(ucfirst(stripslashes($joueur_club)), ENT_QUOTES);
		$joueur_licence = htmlentities(strtoupper_max(stripslashes($joueur_licence)), ENT_QUOTES);
		if(preg_match('/./', $joueur_handicap)==true){ $joueur_handicap = preg_replace('/,/', '.', $joueur_handicap); }
		$joueur_nom = htmlentities(strtoupper_max(stripslashes($joueur_nom)), ENT_QUOTES);
		$joueur_prenom = htmlentities(ucwords(strtolower_max(stripslashes($joueur_prenom))), ENT_QUOTES);
		$joueur_email = strtolower_max(stripslashes(stripslashes($joueur_email)));
		$joueur_adresse_1 = htmlentities(ucfirst(stripslashes($joueur_adresse_1)), ENT_QUOTES);
		$joueur_adresse_2 = htmlentities(ucfirst(stripslashes($joueur_adresse_2)), ENT_QUOTES);
		$joueur_code_postal = strtolower_max(stripslashes($joueur_code_postal));
		$joueur_ville = htmlentities(strtoupper_max(stripslashes($joueur_ville)), ENT_QUOTES);
		$joueur_mobile = strtolower_max(stripslashes($joueur_mobile));
		$joueur_telephone = strtolower_max(stripslashes($joueur_telephone));
		$joueur_accompagnant_prenom = strtolower_max(stripslashes($joueur_accompagnant_prenom));
		$joueur_accompagnant_nom = strtolower_max(stripslashes($joueur_accompagnant_nom));

		// Enregistrement en session du joueur
		$_SESSION['SessionWeb_joueurs_am'][0]['club'] = $joueur_club;
		$_SESSION['SessionWeb_joueurs_am'][0]['licence'] = $joueur_licence;
		$_SESSION['SessionWeb_joueurs_am'][0]['handicap'] = $joueur_handicap;
		$_SESSION['SessionWeb_joueurs_am'][0]['membre_club_competition'] = $joueur_membre_club_competition;
		$_SESSION['SessionWeb_joueurs_am'][0]['sexe'] = $joueur_sexe;
		$_SESSION['SessionWeb_joueurs_am'][0]['nom'] = $joueur_nom;
		$_SESSION['SessionWeb_joueurs_am'][0]['prenom'] = $joueur_prenom;
		$_SESSION['SessionWeb_joueurs_am'][0]['date_naissance'] = $joueur_date_naissance;
		$_SESSION['SessionWeb_joueurs_am'][0]['taille_polo'] = $joueur_taille_polo;
		$_SESSION['SessionWeb_joueurs_am'][0]['adresse_1'] = $joueur_adresse_1;
		$_SESSION['SessionWeb_joueurs_am'][0]['adresse_2'] = $joueur_adresse_2;
		$_SESSION['SessionWeb_joueurs_am'][0]['code_postal'] = $joueur_code_postal;
		$_SESSION['SessionWeb_joueurs_am'][0]['ville'] = $joueur_ville;
		$_SESSION['SessionWeb_joueurs_am'][0]['pays'] = $joueur_pays;
		$_SESSION['SessionWeb_joueurs_am'][0]['email'] = $joueur_email;
		$_SESSION['SessionWeb_joueurs_am'][0]['mobile'] = $joueur_mobile;
		$_SESSION['SessionWeb_joueurs_am'][0]['telephone'] = $joueur_telephone;
		$_SESSION['SessionWeb_joueurs_am'][0]['joueur_accompagnant_prenom'] = $joueur_accompagnant_prenom;
		$_SESSION['SessionWeb_joueurs_am'][0]['joueur_accompagnant_nom'] = $joueur_accompagnant_nom;

		header('Location: ./inscription_hebergement.php');		// Redirection vers la 3e page d'inscription (composition de l'équipe)
		exit;

	}else{
		// Traitement d'affichage en cas d'erreur dans le formulaire
		$joueur_club = stripslashes($joueur_club);
		$joueur_licence = stripslashes($joueur_licence);
		$joueur_nom = stripslashes($joueur_nom);
		$joueur_prenom = stripslashes($joueur_prenom);
		$joueur_date_naissance = stripslashes($joueur_date_naissance);
		$joueur_adresse_1 = stripslashes($joueur_adresse_1);
		$joueur_adresse_2 = stripslashes($joueur_adresse_2);
		$joueur_code_postal = stripslashes($joueur_code_postal);
		$joueur_ville = stripslashes($joueur_ville);
		$joueur_email = stripslashes($joueur_email);
		$joueur_mobile = stripslashes($joueur_mobile);
		$joueur_telephone = stripslashes($joueur_telephone);
		$joueur_accompagnant_prenom = stripslashes($joueur_accompagnant_prenom);
		$joueur_accompagnant_nom = stripslashes($joueur_accompagnant_nom);
	}

}


if(!isset($autorisation) OR (isset($autorisation) AND $autorisation!='inscription')){

	if(isset($_SESSION['SessionWeb_joueurs_am'][0]['nom']) AND strlen(trim($_SESSION['SessionWeb_joueurs_am'][0]['nom']))!=0){

		$joueur_club = $_SESSION['SessionWeb_joueurs_am'][0]['club'];
		$joueur_licence = $_SESSION['SessionWeb_joueurs_am'][0]['licence'];
		$joueur_handicap = $_SESSION['SessionWeb_joueurs_am'][0]['handicap'];
		$joueur_membre_club_competition = $_SESSION['SessionWeb_joueurs_am'][0]['membre_club_competition'];
		$joueur_sexe = $_SESSION['SessionWeb_joueurs_am'][0]['sexe'];
		$joueur_nom = $_SESSION['SessionWeb_joueurs_am'][0]['nom'];
		$joueur_prenom = $_SESSION['SessionWeb_joueurs_am'][0]['prenom'];
		$joueur_date_naissance = $_SESSION['SessionWeb_joueurs_am'][0]['date_naissance'];
		$joueur_taille_polo = $_SESSION['SessionWeb_joueurs_am'][0]['taille_polo'];
		$joueur_adresse_1 = $_SESSION['SessionWeb_joueurs_am'][0]['adresse_1'];
		$joueur_adresse_2 = $_SESSION['SessionWeb_joueurs_am'][0]['adresse_2'];
		$joueur_code_postal = $_SESSION['SessionWeb_joueurs_am'][0]['code_postal'];
		$joueur_ville = $_SESSION['SessionWeb_joueurs_am'][0]['ville'];
		$joueur_pays = $_SESSION['SessionWeb_joueurs_am'][0]['pays'];
		$joueur_email = $_SESSION['SessionWeb_joueurs_am'][0]['email'];
		$joueur_mobile = $_SESSION['SessionWeb_joueurs_am'][0]['mobile'];
		$joueur_telephone = $_SESSION['SessionWeb_joueurs_am'][0]['telephone'];
		$joueur_accompagnant_prenom = $_SESSION['SessionWeb_joueurs_am'][0]['joueur_accompagnant_prenom'];
		$joueur_accompagnant_nom = $_SESSION['SessionWeb_joueurs_am'][0]['joueur_accompagnant_nom'];
	}else{

		// Valeurs par défaut lorsque le formulaire est vierge
		$joueur_club = '';
		$joueur_licence = '';
		$joueur_handicap = '';
		$joueur_membre_club_competition_non = '';
		$joueur_sexe = '';
		$joueur_nom = '';
		$joueur_prenom = '';
		$joueur_date_naissance = '';
		$joueur_adresse_1 = '';
		$joueur_adresse_2 = '';
		$joueur_code_postal = '';
		$joueur_ville = '';
		$joueur_pays = 'FR';
		$joueur_email = '';
		$joueur_mobile = '';
		$joueur_telephone = '';
		$joueur_accompagnant_prenom = '';
		$joueur_accompagnant_nom = '';
	}

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_page_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php include './commun/entete.inc'; ?>

		<div id="formulaire">

			<?php 
			if(count($formulaire_erreur)!=0 AND in_array('joueur_email_inscrit', $formulaire_erreur)==true){
				echo '<div class="erreur" style="padding-left: 0px; text-align: center;">'.$txt_adresse_email_existe.'</div>';
			}
		
			?>



			<form action="<?=$REQUEST_URI?>" method="post">

				<input type="hidden" name="autorisation" value="inscription">

				<h1><?=$txt_am_etape2_titre?></h1>

				<div class="separateur"></div>

				<div class="colonne_gauche"><?=$txt_am_etape2_champ_club?></div>
				<div class="colonne_droite"><input type="text" name="joueur_club" value="<?=$joueur_club?>"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_club', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche"><?=$txt_am_etape2_champ_licence?></div>
				<div class="colonne_droite"><input type="text" name="joueur_licence" value="<?=$joueur_licence?>"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_licence', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche"><?=$txt_am_etape2_champ_handicap?></div>
				<div class="colonne_droite"><input type="text" name="joueur_handicap" value="<?=$joueur_handicap?>" style="width: 60px;"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_handicap', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire" style="height: 33px; padding-top: 0px;"><?=$txt_am_etape2_champ_membre_clubs_competition?></div>
				<div class="colonne_droite" style="height: 33px;">
					<input type="radio" id="joueur_membre_club_competition_oui" name="joueur_membre_club_competition" value="1"<?php if($joueur_membre_club_competition=='1'){ echo ' checked'; } ?>> <label for="joueur_membre_club_competition_oui"><?=$txt_am_etape2_champ_membre_clubs_competition_oui?></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
					<input type="radio" id="joueur_membre_club_competition_non" name="joueur_membre_club_competition" value="0"<?php if($joueur_membre_club_competition=='0'){ echo ' checked'; } ?>> <label for="joueur_membre_club_competition_non"><?=$txt_am_etape2_champ_membre_clubs_competition_non?></label>
				</div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_membre_club_competition', $formulaire_erreur)==true){ echo '<div class="erreur" style="margin-top: 0px;">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="separateur"></div>

				<div class="colonne_gauche_obligatoire" style="height: 33px; padding-top: 0px;"><?=$txt_am_etape2_champ_sexe?></div>
				<div class="colonne_droite" style="height: 33px;">
					<input type="radio" id="joueur_sexe_homme" name="joueur_sexe" value="H"<?php if($joueur_sexe=='H'){ echo ' checked'; } ?>> <label for="joueur_sexe_homme"><?=$txt_am_etape2_champ_sexe_homme?></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
					<input type="radio" id="joueur_sexe_femme" name="joueur_sexe" value="F"<?php if($joueur_sexe=='F'){ echo ' checked'; } ?>> <label for="joueur_sexe_femme"><?=$txt_am_etape2_champ_sexe_femme?></label>
				</div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_sexe', $formulaire_erreur)==true){ echo '<div class="erreur" style="margin-top: 0px;">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire"><?=$txt_am_etape2_champ_nom?></div>
				<div class="colonne_droite"><input type="text" name="joueur_nom" value="<?=$joueur_nom?>"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_nom', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire"><?=$txt_am_etape2_champ_prenom?></div>
				<div class="colonne_droite"><input type="text" name="joueur_prenom" value="<?=$joueur_prenom?>"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_prenom', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche"><?=$txt_am_etape2_champ_date_naissance?></div>
				<div class="colonne_droite"><input type="text" name="joueur_date_naissance" value="<?=$joueur_date_naissance?>" style="width: 80px;"><span class="indication"><?=$txt_date_format?></span></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_date_naissance_incorrecte', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_incorrecte.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire"><?=$txt_am_etape2_champ_taille_polo?></div>
				<div class="colonne_droite">
					<select name="joueur_taille_polo" size="1" style="width: 180px;">
						<option value="0">-</option>
						<option value="NC"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='NC'){ echo ' selected'; } ?>><?=$txt_am_etape2_champ_taille_polo_nc?></option>
						<option value="S"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='S'){ echo ' selected'; } ?>>S (small)</option>
						<option value="M"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='M'){ echo ' selected'; } ?>>M (medium)</option>
						<option value="L"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='L'){ echo ' selected'; } ?>>L (large)</option>
						<option value="XL"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='XL'){ echo ' selected'; } ?>>XL (extra large)</option>
						<option value="XXL"<?php if(isset($joueur_taille_polo) AND $joueur_taille_polo=='XXL'){ echo ' selected'; } ?>>XXL (extra extra large)</option>
					</select>
				</div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_taille_polo', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire"><?=$txt_am_etape2_champ_adresse_postale?></div>
				<div class="colonne_droite"><input type="text" name="joueur_adresse_1" value="<?=$joueur_adresse_1?>"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_adresse_1', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche">&nbsp;</div>
				<div class="colonne_droite"><input type="text" name="joueur_adresse_2" value="<?=$joueur_adresse_2?>"></div>
				<br clear="all">

				<div class="colonne_gauche_obligatoire"><?=$txt_am_etape2_champ_code_postal?></div>
				<div class="colonne_droite"><input type="text" name="joueur_code_postal" value="<?=$joueur_code_postal?>" style="width: 100px;"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_code_postal', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire"><?=$txt_am_etape2_champ_ville?></div>
				<div class="colonne_droite"><input type="text" name="joueur_ville" value="<?=$joueur_ville?>"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_ville', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche_obligatoire"><?=$txt_am_etape2_champ_pays?></div>
				<div class="colonne_droite">
					<select name="joueur_pays" size="1" class="select">
						<option value="0"><?=$txt_selectionnez?></option>
						<?php 
						// Sélection des pays
						$requete_pays = mysqli_query($connexion_mysql, 'SELECT pays_code, pays_libelle_'.$_SESSION['SessionWeb_langue'].' FROM pays ORDER BY pays_libelle_'.$_SESSION['SessionWeb_langue']);
						$nb_pays = mysqli_num_rows($requete_pays);
						if($nb_pays!=0){
							for($pays_boucle=0; $pays_boucle<$nb_pays; $pays_boucle++){
								$resultat_pays = mysqli_fetch_array($requete_pays);
								$pays_code = $resultat_pays[0];
								$pays_libelle = $resultat_pays[1];

								if($pays_code==$joueur_pays){ $pays_selection = ' selected'; }else{ $pays_selection = ''; }

								echo '<option value="'.$pays_code.'"'.$pays_selection.'>'.$pays_libelle.'</option>'."\n";

							}
						}
						?>
					</select>
				</div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_pays', $formulaire_erreur)==true){ echo '<div class="erreur" style="margin-top: 6px;">'.$txt_obligatoire.'</div>'; } ?>
				<br clear="all">

				<div class="separateur"></div>

				<div class="colonne_gauche_obligatoire"><?=$txt_am_etape2_champ_email?></div>
				<div class="colonne_droite"><input type="text" name="joueur_email" value="<?=$joueur_email?>"></div>
				<?php if(count($formulaire_erreur)!=0 AND in_array('joueur_email', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_obligatoire.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('joueur_email_incorrect', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_incorrect.'</div>'; }elseif(count($formulaire_erreur)!=0 AND in_array('joueur_email_existant', $formulaire_erreur)==true){ echo '<div class="erreur">'.$txt_deja_inscrit.'</div>'; } ?>
				<br clear="all">

				<div class="colonne_gauche"><?=$txt_am_etape2_champ_mobile?></div>
				<div class="colonne_droite"><input type="text" name="joueur_mobile" value="<?=$joueur_mobile?>"></div>
				<br clear="all">

				<div class="colonne_gauche"><?=$txt_am_etape2_champ_telephone?></div>
				<div class="colonne_droite"><input type="text" name="joueur_telephone" value="<?=$joueur_telephone?>"></div>
				<br clear="all">

				<div class="separateur"></div>

				<b><?=$txt_am_etape2_champ_autre?></b><br><br>

				<div class="colonne_gauche" style="width: 110px; color: #1EA2B7;"><?=$txt_am_etape2_prenom?></div>
				<div class="colonne_droite" style="width: 220px;"><input type="text" name="joueur_accompagnant_prenom" value="<?=$joueur_accompagnant_prenom?>" style="width: 170px;"></div>
				<div class="colonne_gauche" style="width: 60px; color: #1EA2B7;"><?=$txt_am_etape2_nom?></div>
				<div class="colonne_droite" style="width: 200px;"><input type="text" name="joueur_accompagnant_nom" value="<?=$joueur_accompagnant_nom?>" style="width: 170px;">
				</div>


				<br clear="all">
				<br clear="all">


				<?php if(!isset($_SESSION['SessionWeb_joueurs_am'][0]['nom'])){ ?>
					<div style="float: left; width: 200px;"><input type="button" value="<?=$txt_bouton_retour?>" onclick="window.location='./inscription_annulation.php';" class="bouton_annuler"></div>
				<?php } ?>
				<div align="right" style="margin-right: 130px;"><input type="submit" value="<?=$txt_bouton_etape_suivante?>"></div>

			</form>

			<br><br><br>
			<?=$txt_champs_obligatoires_vert?><br>

		</div>

	</div>

</div>

</body>
</html>
