<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(5, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(6, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}




// Sélection des scores
$requete_scores = mysqli_query($connexion_mysql, 'SELECT score_id, planning_id FROM scores');
$nb_scores = mysqli_num_rows($requete_scores);
if($nb_scores!=0){
	for($score_boucle=0; $score_boucle<$nb_scores; $score_boucle++){
		$resultat_score = mysqli_fetch_array($requete_scores);
		$score_id = $resultat_score[0];
		$planning_id = $resultat_score[1];


		// Sélection du départ
		$requete_planning = mysqli_query($connexion_mysql, 'SELECT planning_groupe, A.equipe_id, planning_depart_date FROM (planning A INNER JOIN golfs B ON A.golf_id=B.golf_id) INNER JOIN equipes C ON A.equipe_id=C.equipe_id WHERE planning_id='.$planning_id);
		$resultat_planning = mysqli_fetch_array($requete_planning);
		$planning_groupe = $resultat_planning[0];
		$planning_equipe = $resultat_planning[1];
		$planning_depart_date_brut = $resultat_planning[2];


		/******************************/
		/**  Traitement des données  **/
		/******************************/

		// Sélection du par du golf
		$requete_golfs_par_total = mysqli_query($connexion_mysql, 'SELECT golf_par FROM golfs WHERE golf_id=(SELECT DISTINCT(A.golf_id) FROM planning A INNER JOIN golfs B ON A.golf_id=B.golf_id WHERE planning_groupe="'.$planning_groupe.'" AND planning_depart_date="'.$planning_depart_date_brut.'")');
		$resultat_golfs_par_total = mysqli_fetch_array($requete_golfs_par_total);
		$golfs_par_total = $resultat_golfs_par_total[0];

		// Sélection du joueur pro
		$requete_joueur_pro_score = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_resultats_total FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$planning_equipe.'" AND planning_depart_date="'.$planning_depart_date_brut.'"');
		$resultat_joueur_pro_score = mysqli_fetch_array($requete_joueur_pro_score);
		$joueur_pro_score = $resultat_joueur_pro_score[0];

		// Sélection du score total brut
		$requete_joueur_brut_score = mysqli_query($connexion_mysql, 'SELECT score_joueur_brut_total FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$planning_equipe.'" AND planning_depart_date="'.$planning_depart_date_brut.'"');
		$resultat_joueur_brut_score = mysqli_fetch_array($requete_joueur_brut_score);
		$joueur_brut_score = $resultat_joueur_brut_score[0];

		// Sélection du score total net
		$requete_joueur_net_score = mysqli_query($connexion_mysql, 'SELECT score_joueur_net_total FROM scores A INNER JOIN planning B ON A.planning_id=B.planning_id WHERE A.equipe_id="'.$planning_equipe.'" AND planning_depart_date="'.$planning_depart_date_brut.'"');
		$resultat_joueur_net_score = mysqli_fetch_array($requete_joueur_net_score);
		$joueur_net_score = $resultat_joueur_net_score[0];

		echo $golfs_par_total.' / '.$joueur_pro_score.' - '.$joueur_brut_score.' - '.$joueur_net_score.'<br>';

		// Calcul du score de référence

		$score_joueur_pro_reference = $joueur_pro_score- $golfs_par_total;
		$score_joueur_brut_reference = $joueur_brut_score - $golfs_par_total;
		$score_joueur_net_reference = $joueur_net_score - $golfs_par_total;

/*
		$score_joueur_pro_reference = ($joueur_pro_score - $golfs_par_total) - $golfs_par_total;
		$score_joueur_brut_reference = ($joueur_brut_score - $golfs_par_total) - $golfs_par_total;
		$score_joueur_net_reference = ($joueur_net_score - $golfs_par_total) - $golfs_par_total;
*/


		/****************************************/
		/**  Enregistrement des modifications  **/
		/****************************************/

		echo 'UPDATE scores SET score_joueur_pro_reference='.$score_joueur_pro_reference.', score_joueur_brut_reference='.$score_joueur_brut_reference.', score_joueur_net_reference='.$score_joueur_net_reference.' WHERE score_id='.$score_id.'<br><br>';

		// Requête de mise à jour des résultats
		$requete_maj = mysqli_query($connexion_mysql, 'UPDATE scores SET score_joueur_pro_reference='.$score_joueur_pro_reference.', score_joueur_brut_reference='.$score_joueur_brut_reference.', score_joueur_net_reference='.$score_joueur_net_reference.' WHERE score_id='.$score_id);

	}
}
?>