<?php 
include '../lib/configuration.inc';

if(!isset($_SESSION['SessionWeb_joueur_id'])){
	header('Location: ./compte_deconnexion.php');
	exit;
}


// Initialisation des tableaux
$tab_roadbook[1] = $tab_roadbook[2] = $tab_roadbook[3] = $tab_roadbook[4] = $tab_roadbook_par = $tab_golf_hcp_coups_recus[1] = $tab_golf_hcp_coups_recus[2] = $tab_golf_hcp_coups_recus[3] = $tab_golf_hcp_coups_recus[4] = array();

// Sélection du roadbook
$requete_roadbook = mysqli_query($connexion_mysql, 'SELECT roadbook_golf, roadbook_trou, roadbook_par, roadbook_hcp, roadbook_blanche, roadbook_jaune, roadbook_rouge FROM golfs_roadbook ORDER BY roadbook_golf, roadbook_trou');
$nb_roadbook = mysqli_num_rows($requete_roadbook);
if($nb_roadbook!=0){
	for($roadbook_boucle=0; $roadbook_boucle<$nb_roadbook; $roadbook_boucle++){
		$resultat_roadbook = mysqli_fetch_array($requete_roadbook);
		$roadbook_golf = $resultat_roadbook[0];
		$roadbook_trou = $resultat_roadbook[1];
		$roadbook_par = $resultat_roadbook[2];
		$roadbook_hcp = $resultat_roadbook[3];
		$roadbook_blanche = $resultat_roadbook[4];
		$roadbook_jaune = $resultat_roadbook[5];
		$roadbook_rouge = $resultat_roadbook[6];

		array_push($tab_golf_hcp_coups_recus[$roadbook_golf], $roadbook_hcp);

		array_push($tab_roadbook[$roadbook_golf], array($roadbook_trou, $roadbook_par, $roadbook_hcp, $roadbook_blanche, $roadbook_jaune, $roadbook_rouge));
	}

	for($num_golf=0; $num_golf<=3; $num_golf++){

		$golf_numero = $num_golf + 1;

		// Cacul de la somme des PAR pour le parcours aller
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou<=9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_aller = $resultat_roadbook_par[0];

		// Cacul de la somme des PAR pour le parcours retour
		$requete_roadbook_par = mysqli_query($connexion_mysql, 'SELECT SUM(roadbook_par) AS total FROM golfs_roadbook WHERE roadbook_trou>9 AND roadbook_golf='.$golf_numero);
		$resultat_roadbook_par = mysqli_fetch_array($requete_roadbook_par);
		$roadbook_golf_par_retour = $resultat_roadbook_par[0];

		// Cacul du total des PAR (aller + retour)
		$roadbook_golf_par_total = $roadbook_golf_par_aller + $roadbook_golf_par_retour;

		array_push($tab_roadbook_par, array($golf_numero, $roadbook_golf_par_retour, $roadbook_golf_par_aller, $roadbook_golf_par_total));

	}

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_espace_equipe_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php $espace='equipe'; include './commun/entete.inc'; ?>

		<div id="contenu_bis" style="padding-left: 20px;">

			<h1><?=$txt_espace_equipe_cartes_score_titre?></h1>

			<div class="separateur" style="width: 920px;"></div>

			<?php 
			if($parametre_site_affichage_cartes_score==1){

				// Sélection des départs
				$requete_planning = mysqli_query($connexion_mysql, 'SELECT planning_id, planning_groupe, A.equipe_id, equipe_nom, A.golf_id, golf_nom, DATE_FORMAT(planning_depart_date, "'.$txt_espace_equipe_cartes_score_date.'"), DATE_FORMAT(planning_depart_heure, "'.$txt_espace_equipe_cartes_score_heure.'") FROM (planning A INNER JOIN golfs B ON A.golf_id=B.golf_id) INNER JOIN equipes C ON A.equipe_id=C.equipe_id WHERE planning_id<>"" AND A.equipe_id="'.$_SESSION['SessionWeb_equipe_id'].'" ORDER BY planning_depart_date, planning_depart_heure, planning_groupe, equipe_nom');
				$nb_planning = mysqli_num_rows($requete_planning);
				if($nb_planning!=0){
					for($planning_boucle=0; $planning_boucle<$nb_planning; $planning_boucle++){
						$resultat_planning = mysqli_fetch_array($requete_planning);
						$planning_id = $resultat_planning[0];
						$planning_groupe = $resultat_planning[1];
						$planning_equipe = $resultat_planning[2];
						$planning_equipe_nom = $resultat_planning[3];
						$planning_golf_id = $resultat_planning[4];
						$planning_golf_nom = strtoupper_max($resultat_planning[5]);
						$planning_depart_date = $resultat_planning[6];
						$planning_depart_heure = $resultat_planning[7];

						// Sélection de la carte de score
						$requete_carte = mysqli_query($connexion_mysql, 'SELECT score_joueur_pro_id, score_joueur_pro_resultats, score_joueur_pro_resultats_aller, score_joueur_pro_resultats_retour, score_joueur_pro_resultats_total, score_joueur_pro_abandon, score_joueur_am1_id, score_joueur_am1_resultats, score_joueur_am1_coupsrecus, score_joueur_am2_id, score_joueur_am2_resultats, score_joueur_am2_coupsrecus, score_joueur_am3_id, score_joueur_am3_resultats, score_joueur_am3_coupsrecus, score_joueur_brut, score_joueur_net, score_joueur_brut_retour, score_joueur_brut_aller, score_joueur_brut_total, score_joueur_net_retour, score_joueur_net_aller, score_joueur_net_total FROM scores WHERE planning_id='.$planning_id);
						$nb_carte = mysqli_num_rows($requete_carte);
						if($nb_carte!=0){

							$resultat_carte = mysqli_fetch_array($requete_carte);
							$score_joueur_pro_id = $resultat_carte[0];
							$score_joueur_pro_resultats = explode(',', $resultat_carte[1]);
							$score_aller = $resultat_carte[2];
							$score_retour = $resultat_carte[3];
							$score_total = $resultat_carte[4];
							$score_joueur_pro_abandon = $resultat_carte[5];
							$score_joueur_am1_id = $resultat_carte[6];
							$score_joueur_am1_resultats = explode(',', $resultat_carte[7]);
							$score_joueur_am1_coupsrecus = explode(',', $resultat_carte[8]);
							$score_joueur_am2_id = $resultat_carte[9];
							$score_joueur_am2_resultats = explode(',', $resultat_carte[10]);
							$score_joueur_am2_coupsrecus = explode(',', $resultat_carte[11]);
							$score_joueur_am3_id = $resultat_carte[12];
							$score_joueur_am3_resultats = explode(',', $resultat_carte[13]);
							$score_joueur_am3_coupsrecus = explode(',', $resultat_carte[14]);
							$resultat_brut = explode(',', $resultat_carte[15]);
							$resultat_net = explode(',', $resultat_carte[16]);
							$resultat_brut_retour = $resultat_carte[17];
							$resultat_brut_aller = $resultat_carte[18];
							$resultat_brut_total = $resultat_carte[19];
							$resultat_net_retour = $resultat_carte[20];
							$resultat_net_aller = $resultat_carte[21];
							$resultat_net_total = $resultat_carte[22];

							$score = array($score_joueur_pro_id=>$score_joueur_pro_resultats, $score_joueur_am1_id=>$score_joueur_am1_resultats, $score_joueur_am2_id=>$score_joueur_am2_resultats, $score_joueur_am3_id=>$score_joueur_am3_resultats);

						}else{

							// Suppression des variables pour les résultats
							unset($score);
							unset($score_aller);
							unset($score_retour);
							unset($score_total);
							unset($resultat_brut);
							unset($resultat_net);
							unset($resultat_brut_retour);
							unset($resultat_brut_aller);
							unset($resultat_brut_total);
							unset($resultat_net_retour);
							unset($resultat_net_aller);
							unset($resultat_net_total);

						}
				?>

						<span class="texte_vert" style="font-size: 15px;"><?=$txt_espace_equipe_cartes_score_groupe?>&nbsp; <b><?=$planning_groupe?></b> &nbsp;&nbsp;-&nbsp;&nbsp; <?=$txt_espace_equipe_cartes_score_equipe?>&nbsp; <b><?=$planning_equipe_nom?></b> &nbsp;&nbsp;-&nbsp;&nbsp; <?=$txt_espace_equipe_cartes_score_golf_de?>&nbsp; <b><?=$planning_golf_nom?></b> &nbsp;&nbsp;-&nbsp;&nbsp; <?=$planning_depart_date?> &nbsp;<?=$txt_espace_equipe_cartes_score_a?>&nbsp; <?=$planning_depart_heure?></span><br><br><br>

						<table border="0" id="carte_score">
							<tr>
								<td class="carte_entete_ligne"><?=$txt_espace_equipe_cartes_score_trou?></td>
								<td class="carte_entete">1</td>
								<td class="carte_entete">2</td>
								<td class="carte_entete">3</td>
								<td class="carte_entete">4</td>
								<td class="carte_entete">5</td>
								<td class="carte_entete">6</td>
								<td class="carte_entete">7</td>
								<td class="carte_entete">8</td>
								<td class="carte_entete">9</td>
								<td class="carte_entete">10</td>
								<td class="carte_entete">11</td>
								<td class="carte_entete">12</td>
								<td class="carte_entete">13</td>
								<td class="carte_entete">14</td>
								<td class="carte_entete">15</td>
								<td class="carte_entete">16</td>
								<td class="carte_entete">17</td>
								<td class="carte_entete">18</td>
								<td class="carte_entete" style="width: 60px;"><?=$txt_espace_equipe_cartes_score_retour?></td>
								<td class="carte_entete" style="width: 60px;"><?=$txt_espace_equipe_cartes_score_aller?></td>
								<td class="carte_entete" style="width: 60px;">Total</td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Par</td>
								<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne"><?=$tab_trou[1]?></td>
								<?php } ?>
								<td class="carte_ligne" style="width: 60px;"><?=$tab_roadbook_par[($planning_golf_id-1)][1]?></td>
								<td class="carte_ligne" style="width: 60px;"><?=$tab_roadbook_par[($planning_golf_id-1)][2]?></td>
								<td class="carte_ligne" style="width: 60px;"><?=$tab_roadbook_par[($planning_golf_id-1)][3]?></td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Handicap</td>
								<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne"><?=$tab_trou[1]?></td>
								<?php } ?>
								<td class="carte_ligne" colspan="3" style="width: 60px;">&nbsp;</td>
							</tr>
						</table>

						<table border="0" id="carte_score">
							<?php 
							// Sélection des joueurs de l'équipe sélectionnée
							$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom, joueur_profil, joueur_handicap FROM joueurs WHERE joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$planning_equipe.'") AND joueur_actif="1" AND joueur_profil<>"acc" ORDER BY joueur_profil DESC, joueur_handicap, joueur_nom, joueur_prenom');
							$nb_joueurs = mysqli_num_rows($requete_joueurs);
							if($nb_joueurs!=0){
								for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
									$resultat_joueur = mysqli_fetch_array($requete_joueurs);
									$joueur_id = $resultat_joueur[0];
									$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
									$joueur_prenom = substr(decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2]))), 0, 1).'.';
									$joueur_profil = $resultat_joueur[3];
									$joueur_handicap = number_format($resultat_joueur[4], 1, '.', '');

									/**************************************************************/
									/***  Calcul et attribution des coups reçus pour le joueur  ***/
									/**************************************************************/
									$tab_joueur_coups_recus = array();
									$joueur_coups_recus = round(($joueur_handicap/4)*3);
									foreach($tab_golf_hcp_coups_recus[$planning_golf_id] as $tab_golf_hcp){
										if($tab_golf_hcp<=$joueur_coups_recus){
											array_push($tab_joueur_coups_recus, 1);
										}else{
											array_push($tab_joueur_coups_recus, 0);
										}
									}

									if(substr($joueur_handicap, -2)=='.0'){ $joueur_handicap_libelle = substr($joueur_handicap, 0, -2); }else{ $joueur_handicap_libelle = $joueur_handicap; }
									if($joueur_profil=='am'){ $joueur_handicap_libelle = '<br><span style="font-weight: normal;">('.$joueur_handicap_libelle.')</span>'; }else{ $joueur_handicap_libelle = ''; }
							?>
									<tr>
										<td class="carte_entete_ligne_score" style="width: 125px;"><?=$joueur_nom.' '.$joueur_prenom.$joueur_handicap_libelle?></td>
										<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
											<td class="carte_ligne_score"><?php if(isset($score[$joueur_id][$boucle_trou])){ echo $score[$joueur_id][$boucle_trou]; } ?></td>
										<?php } ?>
										<?php if($joueur_profil!='am'){ ?>
											<td class="carte_ligne_score" style="width: 60px;"><?php if(isset($score_retour)){ echo $score_retour; }else{ echo '&nbsp;'; } ?></td>
											<td class="carte_ligne_score" style="width: 60px;"><?php if(isset($score_aller)){ echo $score_aller; }else{ echo '&nbsp;'; } ?></td>
											<td class="carte_ligne_score" style="width: 60px;"><?php if($score_joueur_pro_abandon==1){ echo '<span style="font-weight: normal; color: #FF5500; font-size: 16px;">ABD'; }elseif(isset($score_total)){ echo $score_total; }else{ echo '&nbsp;'; } ?></td>
										<?php }else{ ?>
											<td colspan="3" class="carte_ligne_score" style="width: 180px;" rowspan="2">&nbsp;</td>
										<?php } ?>
										</tr>
									<?php if($joueur_profil=='am'){ ?>
										<tr>
											<td class="carte_entete_ligne_coupsrecus" style="font-weight: normal; text-align: right;"><?=$txt_espace_equipe_cartes_score_coups_recus?></td>
											<?php 
											foreach($tab_joueur_coups_recus as $tab_joueur_coup_recu){
												echo '<td class="carte_ligne_coupsrecus" style="height: 15px;">'.$tab_joueur_coup_recu.'</td>'."\n";
											}
											?>
										</tr>
							<?php
									} 
								}
							}
							?>
						</table>

						<table border="0" id="carte_score">
							<tr>
								<td class="carte_entete_ligne">Brut</td>
								<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
									<td class="carte_ligne"><?php if(isset($resultat_brut[$boucle_trou])){ echo $resultat_brut[$boucle_trou]; }else{ echo '&nbsp;'; } ?></td>
								<?php } ?>
								<td class="carte_ligne" style="width: 60px;"><?php if(isset($resultat_brut_retour)){ echo $resultat_brut_retour; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_ligne" style="width: 60px;"><?php if(isset($resultat_brut_aller)){ echo $resultat_brut_aller; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_ligne" style="width: 60px;"><?php if(isset($resultat_brut_total)){ echo $resultat_brut_total; }else{ echo '&nbsp;'; } ?></td>
							</tr>
							<tr>
								<td class="carte_entete_ligne">Net</td>
								<?php for($boucle_trou=0; $boucle_trou<=17; $boucle_trou++){ ?>
									<td class="carte_ligne"><?php if(isset($resultat_net[$boucle_trou])){ echo $resultat_net[$boucle_trou]; } ?></td>
								<?php } ?>
								<td class="carte_ligne" style="width: 60px;"><?php if(isset($resultat_net_retour)){ echo $resultat_net_retour; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_ligne" style="width: 60px;"><?php if(isset($resultat_net_aller)){ echo $resultat_net_aller; }else{ echo '&nbsp;'; } ?></td>
								<td class="carte_ligne" style="width: 60px;"><?php if(isset($resultat_net_total)){ echo $resultat_net_total; }else{ echo '&nbsp;'; } ?></td>
							</tr>
						</table>

						<table border="0" id="carte_score">
							<tr>
								<td class="carte_entete_ligne"><?=$txt_espace_equipe_cartes_score_blanches?></td>
								<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne_distance"><?=$tab_trou[3]?></td>
								<?php } ?>
							</tr>
							<tr>
								<td class="carte_entete_ligne"><?=$txt_espace_equipe_cartes_score_jaunes?></td>
								<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne_distance"><?=$tab_trou[4]?></td>
								<?php } ?>
							</tr>
							<tr>
								<td class="carte_entete_ligne"><?=$txt_espace_equipe_cartes_score_rouges?></td>
								<?php foreach($tab_roadbook[$planning_golf_id] as $tab_trou_cle=>$tab_trou){ ?>
									<td class="carte_ligne_distance"><?=$tab_trou[5]?></td>
								<?php } ?>
							</tr>
						</table>
						<br>

						<div class="separateur" style="width: 920px;"></div>

			<?php 
					}
				}

			}
			?>

			<input type="button" value=" Retour " onclick="window.location='./compte.php'" style="margin: 20px 0px 100px 0px;">

		</div>

	</div>

</div>

</body>
</html>
