<?php 
include '../lib/configuration.inc';

if(!isset($_SESSION['SessionWeb_joueur_id'])){
	header('Location: ./compte_deconnexion.php');
	exit;
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?=$_SESSION['SessionWeb_langue']?>" xml:lang="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
<head>
	<title><?=$txt_espace_equipe_titre?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=8">
	<meta name="language" content="<?=strtolower($_SESSION['SessionWeb_langue'])?>">
	<meta name="robots" content="index, follow">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico">
	<link rel="shortcut icon" href="/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$web_commun?>commun.css">
</head>

<body scroll="auto">

<div id="page" align="center">

	<div id="contenu">

		<?php $espace='equipe'; include './commun/entete.inc'; ?>

		<div id="contenu_bis">

			<div id="menu">

				<?php include './commun/menu.inc'; ?>

			</div>

			<div id="formulaire_bis">

				<h1><?=$txt_espace_equipe_equipe_titre?></h1>

				<div class="separateur"></div>

				<?php 
				// Récupération de l'ID de l'équipe
				$requete_equipe = mysqli_query($connexion_mysql, 'SELECT ej_equipe, equipe_nom FROM equipes_joueurs A INNER JOIN equipes B ON A.ej_equipe=B.equipe_id WHERE ej_joueur="'.$_SESSION['SessionWeb_joueur_id'].'"');
				$resultat_equipe = mysqli_fetch_array($requete_equipe);
				$equipe_id = $resultat_equipe[0];
				$equipe_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_equipe[1])));
				?>

				<span style="font-weight: normal;"><?=$txt_espace_equipe_equipe_equipe?> :</span>&nbsp; <?=$equipe_nom?><br><br><br>

				<?php 
				// Sélection des joueurs de l'équipe sélectionnée
				$requete_joueurs = mysqli_query($connexion_mysql, 'SELECT joueur_id, joueur_nom, joueur_prenom, joueur_email, joueur_profil, joueur_handicap FROM joueurs WHERE joueur_id IN (SELECT ej_joueur FROM equipes_joueurs WHERE ej_equipe="'.$equipe_id.'") AND joueur_actif="1" ORDER BY joueur_profil DESC, joueur_nom, joueur_prenom');
				$nb_joueurs = mysqli_num_rows($requete_joueurs);
				if($nb_joueurs!=0){

					for($joueur_boucle=0; $joueur_boucle<$nb_joueurs; $joueur_boucle++){
						$resultat_joueur = mysqli_fetch_array($requete_joueurs);
						$joueur_id = $resultat_joueur[0];
						$joueur_nom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[1])));
						$joueur_prenom = decodage_apostrophe(html_entity_decode(stripslashes($resultat_joueur[2])));
						$joueur_email = $resultat_joueur[3];
						$joueur_profil = $resultat_joueur[4];
						$joueur_handicap = number_format($resultat_joueur[5], 1, ',', '');

						if($joueur_profil=='pro'){ $joueur_profil = $txt_professionnel; }elseif($joueur_profil=='am'){ $joueur_profil = $txt_amateur; }else{ $joueur_profil = $txt_accompagnateur; }
						if($joueur_handicap!='0,0'){ $joueur_handicap = $txt_espace_equipe_equipe_hcp.' '.preg_replace('/,0/', '', $joueur_handicap); }else{ $joueur_handicap = ''; }
				?>

						<?php if(strlen(trim($joueur_email))!=0){ ?>
							<div style="float: left; width: 220px;"><a href="mailto:<?=$joueur_email?>"><?=$joueur_nom.' '.$joueur_prenom?></a></div>
						<?php }else{ ?>
							<div style="float: left; width: 220px;"><?=$joueur_nom.' '.$joueur_prenom?></div>
						<?php } ?>
						<div style="float: left; width: 150px;"><?=ucfirst($joueur_profil)?></div>
						<div style="float: left; width: 100px;"><?=$joueur_handicap?></div>
						<br clear="all"><br>

				<?php 
					}
				}
				?>

			</div>
			<br clear="all">

		</div>

	</div>

</div>

</body>
</html>
