<?php 
require_once '../../../../lib/configuration.inc';

// Vérification si l'accès est valide
if(!isset($_SESSION['SessionADMIN_compte_id'])){
	header('Location: ../../../auth.php');
	exit;
}

// Vérification si l'utilisateur a les droits d'accès
if($_SESSION['SessionADMIN_compte_type']=='utilisateur' AND (in_array(8, $_SESSION['SessionADMIN_compte_acces_modules'])==false OR in_array(10, $_SESSION['SessionADMIN_compte_acces_rubriques'])==false)){
	header('Location: ../../../');
	exit;
}


if(isset($action) AND $action=='ajouter'){

	/******************************/
	/**  Traitement des erreurs  **/
	/******************************/
	if(strlen(trim($competition_date_debut))==0){
		$erreur_message .= "- la date de début est manquante<br>";
	}
	if(strlen(trim($competition_heure_debut))==0){
		$erreur_message .= "- l'heure de début est manquante<br>";
	}else{
		if(preg_match('/:/', $competition_heure_debut)==false){
			$erreur_message .= "- l'heure de début est incorrecte<br>";
		}
	}
	if(strlen(trim($competition_sponsor_1))==0){
		$erreur_message .= "- le sponsor du 1er jour est manquant<br>";
	}
	if(strlen(trim($competition_sponsor_2))==0){
		$erreur_message .= "- le sponsor du 2ème jour est manquant<br>";
	}
	if(strlen(trim($competition_sponsor_3))==0){
		$erreur_message .= "- le sponsor du 3ème jour est manquant<br>";
	}
	if(strlen(trim($competition_sponsor_4))==0){
		$erreur_message .= "- le sponsor du 4ème jour est manquant<br>";
	}

	/******************************/
	/**  Traitement des données  **/
	/******************************/
	$competition_sponsor_1 = htmlentities(strtoupper($competition_sponsor_1), ENT_QUOTES);
	$competition_sponsor_2 = htmlentities(strtoupper($competition_sponsor_2), ENT_QUOTES);
	$competition_sponsor_3 = htmlentities(strtoupper($competition_sponsor_3), ENT_QUOTES);
	$competition_sponsor_4 = htmlentities(strtoupper($competition_sponsor_4), ENT_QUOTES);
	if(!isset($competition_active)){ $competition_active = 0; }

	/****************************************/
	/**  Enregistrement des modifications  **/
	/****************************************/
	if($erreur_message==''){

		$competition_id = uniqid();

		$tab_date_debut = explode('/', $competition_date_debut);
		$competition_date_debut_jour = $tab_date_debut[0];
		$competition_date_debut_mois = $tab_date_debut[1];
		$competition_date_debut_annee = $tab_date_debut[2];


		//$competition_date_fin
		//$competition_date_fin = date('d/m/Y', mktime(0, 0, 0, $competition_date_debut_mois, $competition_date_debut_jour+($competition_nb_jours-1), $competition_date_debut_annee));

		// competition_date_debut

		if(isset($competition_sponsors_classement)){ $competition_sponsors_classement = implode(',', $competition_sponsors_classement); }

		// Requête d'insertion de la compétition
		$requete_insertion = mysqli_query($connexion_mysql, 'INSERT INTO competitions (competition_id, competition_annee, competition_date_debut, competition_date_fin, competition_heure_debut, competition_sponsor_1, competition_sponsor_2, competition_sponsor_3, competition_sponsor_4, competition_sponsors_classement, competition_active, prix_forfait, single_no_pisc, single_pisc, no_heb_pro_no_hotel, no_heb_pro_hotel, text_heb, text_heb_pro, date_debut_hotel, date_fin_hotel, double_no_pisc, acc_double_pisc, acc_single_pisc, acc_double_no_pisc, acc_single_no_pisc, text_heb_acc, text_heb_2, text_heb_3, text_heb_4, text_heb_pro_2, text_heb_pro_3, text_heb_2_en, text_heb_3_en, text_heb_4_en, text_heb_pro_2_en, text_heb_pro_3_en, text_acc_final_FR, text_acc_final_EN) VALUES("'.$competition_id.'", "'.$competition_date_debut_annee.'", STR_TO_DATE("'.$competition_date_debut.'", "%d/%m/%Y"), STR_TO_DATE("'.$competition_date_fin.'", "%d/%m/%Y"), STR_TO_DATE("'.$competition_heure_debut.'", "%H:%i"), "'.$competition_sponsor_1.'", "'.$competition_sponsor_2.'", "'.$competition_sponsor_3.'", "'.$competition_sponsor_4.'", "'.$competition_sponsors_classement.'", "'.$competition_active.'", "'.$prix_forfait.'", "'.$single_no_pisc.'", "'.$single_pisc.'", "'.$no_heb_pro_no_hotel.'", "'.$no_heb_pro_hotel.'", "'.$text_heb.'", "'.$text_heb_pro.'", STR_TO_DATE("'.$date_debut_hotel.'", "%d/%m/%Y"), STR_TO_DATE("'.$date_fin_hotel.'", "%d/%m/%Y"), "'.$double_no_pisc.'", "'.$acc_double_pisc.'", "'.$acc_single_pisc.'", "'.$acc_double_no_pisc.'", "'.$acc_single_no_pisc.'", "'.$text_heb_acc.'", "'.$text_heb_2.'", "'.$text_heb_3.'", "'.$text_heb_4.'", "'.$text_heb_pro_2.'", "'.$text_heb_pro_3.'", "'.$text_heb_2_en.'", "'.$text_heb_3_en.'", "'.$text_heb_4_en.'", "'.$text_heb_pro_2_en.'", "'.$text_heb_pro_3_en.'", "'.$text_acc_final_FR.'", "'.$text_acc_final_EN.'")');

			// text_acc_final_FR

		header('Location: ./');
		exit;

	} else {
		$competition_sponsor_1 = stripslashes($competition_sponsor_1);
		$competition_sponsor_2 = stripslashes($competition_sponsor_2);
		$competition_sponsor_3 = stripslashes($competition_sponsor_3);
		$competition_sponsor_4 = stripslashes($competition_sponsor_4);
		$competition_sponsors_classement = explode(',', $competition_sponsors_classement);
	}

}


if(isset($erreur_message) AND $erreur_message==''){

	// Initialisation des champs
	$competition_active = 1;
	$competition_date_debut = '';
	$competition_date_fin = '';
	$competition_heure_debut = '08:00';
	$competition_sponsor_1 = '';
	$competition_sponsor_2 = '';
	$competition_sponsor_3 = '';
	$competition_sponsor_4 = '';

}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><?=$admin_titre?></title>
	<link rel="shortcut icon" type="image/png" href="<?=$admin_domaine?>favicon.png">
	<link rel="stylesheet" type="text/css" href="<?=$admin_css_page?>">
	<script type="text/javascript" src="<?=$admin_js?>jquery/jquery.js"></script>
	<script type="text/javascript" src="<?=$admin_js?>commun.js"></script>
	<meta name="robots" content="none">
</head>

<body>

<?php 
include $general_path_relatif.'sources/entete.inc';
include $general_path_relatif.'sources/menu.inc';
?>

<div id="contenu_1"<?=$correction_contenu_1?>><div id="contenu_2">

	<div id="contenu_3" align="left" style="width: 650px;">

		<div id="titres">
			<span class="titre_1"><a href="./">Compétitions</a> <span class="separateur">/</span> <span class="titre_2">Ajouter</span></span>
		</div>
		<br clear="all">

		<div id="bloc_bis">

			<?php if(isset($erreur_message) AND $erreur_message!=''){ ?>
				<div align="center"><div id="message_erreur" align="left"><b><?=$erreur_message_introduction.'</b><br>'.$erreur_message?></div></div>
			<?php } ?>

			<form name="ajouter" action="<?=$PHP_SELF?>" method="post" enctype="multipart/form-data">

				<input type="hidden" name="action" value="ajouter">

				<div id="formulaire_ligne">
					<div id="formulaire_libelle">Activation</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="checkbox" name="competition_active" value="1" <?php if($competition_active==1){ echo 'checked'; } ?>></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date de début</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_date_debut" value="<?=$competition_date_debut?>" class="input" style="width: 80px;">&nbsp;&nbsp;&nbsp; (format: dd/mm/aaaa)</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date de fin</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_date_fin" value="<?=$competition_date_fin?>" class="input" style="width: 80px;">&nbsp;&nbsp;&nbsp; (format: dd/mm/aaaa)</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Heure de début</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="competition_heure_debut" value="<?=$competition_heure_debut?>" class="input" style="width: 40px;">&nbsp;&nbsp;&nbsp; (format: hh:mm)</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">SPONSORS JOURNALIERS</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">1er jour</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="competition_sponsor_1" value="<?=$competition_sponsor_1?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">2ème jour</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="competition_sponsor_2" value="<?=$competition_sponsor_2?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">3ème jour</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="competition_sponsor_3" value="<?=$competition_sponsor_3?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>
				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">4ème jour</div>
					<div id="formulaire_champ" style="width: 500px;">
						<input type="text" name="competition_sponsor_4" value="<?=$competition_sponsor_4?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne_intertitre">SPONSORS DU CLASSEMENT</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Sponsors</div>
					<div id="formulaire_champ" style="width: 500px;">
						<?php 
						// Sélection des sponsors enregistrées pour le classement
						$requete_sponsors_classement = mysqli_query($connexion_mysql, 'SELECT sponsor_id, sponsor_nom FROM sponsors WHERE sponsor_actif=1 ORDER BY sponsor_classement');
						$nb_sponsors_classement = mysqli_num_rows($requete_sponsors_classement);
						if($nb_sponsors_classement!=0){
							for($sponsor_classement_boucle=0; $sponsor_classement_boucle<$nb_sponsors_classement; $sponsor_classement_boucle++){
								$resultat_sponsor_classement = mysqli_fetch_array($requete_sponsors_classement);
								$sponsor_classement_id = $resultat_sponsor_classement[0];
								$sponsor_classement_nom = $resultat_sponsor_classement[1];

								if(isset($competition_sponsors_classement) AND in_array($sponsor_classement_id, $competition_sponsors_classement)==true){ $sponsor_classement_selection = ' checked'; }else{ $sponsor_classement_selection = ''; }

								echo '<input type="checkbox" id="sponsor_classement_'.$sponsor_classement_id.'" name="competition_sponsors_classement[]" value="'.$sponsor_classement_id.'" class="checbox"'.$sponsor_classement_selection.'> <label for="sponsor_classement_'.$sponsor_classement_id.'">'.$sponsor_classement_nom.'</label><br>'."\n";

							}
						}else{
							echo 'Aucun sponsor disponible pour le classement.';
						}
						?>
					</div>
					<br clear="all">
				</div>



				<div id="formulaire_ligne_intertitre">Prix forfait</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix standard</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="prix_forfait" value="<?=$prix_forfait?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Ajout single</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="single_no_pisc" value="<?=$single_no_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Ajout single + piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="single_pisc" value="<?=$single_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Ajout double , pas de piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="double_no_pisc" value="<?=$double_no_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix sans hébergement, professionnel non logé</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="no_heb_pro_no_hotel" value="<?=$no_heb_pro_no_hotel?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix sans hébergement, professionnel logé</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="no_heb_pro_hotel" value="<?=$no_heb_pro_hotel?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>



				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix acc double + piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="acc_double_pisc" value="<?=$acc_double_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix acc single + piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="acc_single_pisc" value="<?=$acc_single_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix acc double no piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="acc_double_no_pisc" value="<?=$acc_double_no_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Prix acc single no piscine</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="acc_single_no_pisc" value="<?=$acc_single_no_pisc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte hébergement</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb" value="<?=$text_heb?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte hébergement pro</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_pro" value="<?=$text_heb_pro?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte hébergement acc</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_heb_acc" value="<?=$text_heb_acc?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>




				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte final acc FR</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_acc_final_FR" value="<?=$text_acc_final_FR?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>


				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Texte final acc EN</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="text_acc_final_EN" value="<?=$text_acc_final_EN?>" class="input" style="width: 470px;"></div>
					<br clear="all">
				</div>




				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date de début hôtel</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="date_debut_hotel" value="<?=$date_debut_hotel?>" class="input" style="width: 80px;">&nbsp;&nbsp;&nbsp; (format: dd/mm/aaaa)</div>
					<br clear="all">
				</div>

				<div id="formulaire_ligne">
					<div id="formulaire_libelle_obligatoire">Date de fin hôtel</div>
					<div id="formulaire_champ" style="width: 500px;"><input type="text" name="date_fin_hotel" value="<?=$date_fin_hotel?>" class="input" style="width: 80px;">&nbsp;&nbsp;&nbsp; (format: dd/mm/aaaa)</div>
					<br clear="all">
				</div>



				<div id="formulaire_boutons"><input type="image" src="<?=$admin_img?>btn_enregistrer.png" width="150" height="32" align="absmiddle" style="margin: 15px 5px 20px 0px;"> ou&nbsp; <a href="./" class="lien_annuler">annuler</a></div>

			</form>

		</div>

	</div>
	<br clear="all">

</div></div>

<?php include $general_path_relatif.'sources/pied_page.inc'; ?>

<script language="Javascript">
	<!-- 
	document.ajouter.competition_date_debut.focus();
	//-->
</script>

</body>
</html>
